/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.parser;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.parser.IFileParser;
import com.seeyon.ctp.util.XXEUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Excel2007EventUserModelParser
implements IFileParser {
    private static final Log log = CtpLogFactory.getLog(Excel2007EventUserModelParser.class);
    private OPCPackage xlsxPackage;
    private StringBuilder output = new StringBuilder();

    public Excel2007EventUserModelParser(String input) {
        try {
            this.xlsxPackage = OPCPackage.open((String)input, (PackageAccess)PackageAccess.READ);
        }
        catch (InvalidFormatException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public Excel2007EventUserModelParser(InputStream input) {
        try {
            this.xlsxPackage = OPCPackage.open((InputStream)input);
        }
        catch (InvalidFormatException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void processSheet(StylesTable styles, ReadonlySharedStringsTable strings, InputStream sheetInputStream) throws IOException, ParserConfigurationException, SAXException {
        InputSource sheetSource = new InputSource(sheetInputStream);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxFactory.newSAXParser();
        XMLReader sheetParser = saxParser.getXMLReader();
        XXEUtil.prevent(sheetParser);
        MyXSSFSheetHandler handler = new MyXSSFSheetHandler(styles, strings, this.output);
        sheetParser.setContentHandler(handler);
        sheetParser.parse(sheetSource);
    }

    public void process() throws IOException, OpenXML4JException, ParserConfigurationException, SAXException {
        ReadonlySharedStringsTable strings = new ReadonlySharedStringsTable(this.xlsxPackage);
        XSSFReader xssfReader = new XSSFReader(this.xlsxPackage);
        StylesTable styles = xssfReader.getStylesTable();
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        while (iter.hasNext()) {
            InputStream stream = iter.next();
            String sheetName = iter.getSheetName();
            this.output.append(sheetName + " ");
            this.processSheet(styles, strings, stream);
            stream.close();
        }
    }

    @Override
    public void setFile(File file) {
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public String getContentString() {
        try {
            this.process();
        }
        catch (IOException iOException) {
        }
        catch (OpenXML4JException openXML4JException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.output != null) {
            return this.output.toString();
        }
        return "";
    }

    @Override
    public Reader getContentReader() {
        return null;
    }

    @Override
    public String getMetadata(String metadataname) {
        return null;
    }

    class MyXSSFSheetHandler
    extends DefaultHandler {
        private StylesTable stylesTable;
        private ReadonlySharedStringsTable sharedStringsTable;
        private final StringBuilder output;
        private boolean vIsOpen;
        private xssfDataType nextDataType;
        private short formatIndex;
        private String formatString;
        private final DataFormatter formatter;
        private int thisColumn = -1;
        private int lastColumnNumber = -1;
        private StringBuilder value;

        public MyXSSFSheetHandler(StylesTable styles, ReadonlySharedStringsTable strings, StringBuilder target) {
            this.stylesTable = styles;
            this.sharedStringsTable = strings;
            this.output = target;
            this.value = new StringBuilder();
            this.nextDataType = xssfDataType.NUMBER;
            this.formatter = new DataFormatter();
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("inlineStr".equals(name) || "v".equals(name)) {
                this.vIsOpen = true;
                this.value.setLength(0);
            } else if ("c".equals(name)) {
                String r = attributes.getValue("r");
                int firstDigit = -1;
                for (int c = 0; c < r.length(); ++c) {
                    if (!Character.isDigit(r.charAt(c))) continue;
                    firstDigit = c;
                    break;
                }
                this.thisColumn = this.nameToColumn(r.substring(0, firstDigit));
                this.nextDataType = xssfDataType.NUMBER;
                this.formatIndex = (short)-1;
                this.formatString = null;
                String cellType = attributes.getValue("t");
                String cellStyleStr = attributes.getValue("s");
                if ("b".equals(cellType)) {
                    this.nextDataType = xssfDataType.BOOL;
                } else if ("e".equals(cellType)) {
                    this.nextDataType = xssfDataType.ERROR;
                } else if ("inlineStr".equals(cellType)) {
                    this.nextDataType = xssfDataType.INLINESTR;
                } else if ("s".equals(cellType)) {
                    this.nextDataType = xssfDataType.SSTINDEX;
                } else if ("str".equals(cellType)) {
                    this.nextDataType = xssfDataType.FORMULA;
                } else if (cellStyleStr != null) {
                    int styleIndex = Integer.parseInt(cellStyleStr);
                    XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
                    this.formatIndex = style.getDataFormat();
                    this.formatString = style.getDataFormatString();
                    if (this.formatString == null) {
                        this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            String thisStr = null;
            if ("v".equals(name)) {
                switch (this.nextDataType) {
                    case FORMULA: {
                        thisStr = this.value.toString();
                        break;
                    }
                    case INLINESTR: {
                        XSSFRichTextString rtsi = new XSSFRichTextString(this.value.toString());
                        thisStr = rtsi.toString();
                        break;
                    }
                    case SSTINDEX: {
                        String sstIndex = this.value.toString();
                        try {
                            int idx = Integer.parseInt(sstIndex);
                            XSSFRichTextString rtss = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx));
                            thisStr = rtss.toString();
                        }
                        catch (NumberFormatException idx) {}
                        break;
                    }
                    case NUMBER: {
                        String n = this.value.toString();
                        if (this.formatString != null) {
                            thisStr = this.formatter.formatRawCellContents(Double.parseDouble(n), (int)this.formatIndex, this.formatString);
                            break;
                        }
                        thisStr = n;
                        break;
                    }
                }
                if (this.lastColumnNumber == -1) {
                    this.lastColumnNumber = 0;
                }
                this.output.append(thisStr + " ");
                if (this.thisColumn > -1) {
                    this.lastColumnNumber = this.thisColumn;
                }
            } else if ("row".equals(name)) {
                if (this.lastColumnNumber == -1) {
                    this.lastColumnNumber = 0;
                }
                this.lastColumnNumber = -1;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.vIsOpen) {
                this.value.append(ch, start, length);
            }
        }

        private int nameToColumn(String name) {
            int column = -1;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                column = (column + 1) * 26 + c - 65;
            }
            return column;
        }
    }

    static class ReadonlySharedStringsTable
    extends DefaultHandler {
        private int count;
        private int uniqueCount;
        private String[] strings;
        private StringBuilder characters;
        private boolean tIsOpen;
        private int index;

        public ReadonlySharedStringsTable(OPCPackage pkg) throws IOException, SAXException, ParserConfigurationException {
            ArrayList parts = pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
            if (parts != null && !parts.isEmpty()) {
                PackagePart sstPart = (PackagePart)parts.get(0);
                this.readFrom(sstPart.getInputStream());
            }
        }

        public ReadonlySharedStringsTable(PackagePart part, PackageRelationship relIgnored) throws IOException, SAXException, ParserConfigurationException {
            this.readFrom(part.getInputStream());
        }

        public void readFrom(InputStream is) throws IOException, SAXException, ParserConfigurationException {
            InputSource sheetSource = new InputSource(is);
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxFactory.newSAXParser();
            XMLReader sheetParser = saxParser.getXMLReader();
            XXEUtil.prevent(sheetParser);
            sheetParser.setContentHandler(this);
            sheetParser.parse(sheetSource);
        }

        public int getCount() {
            return this.count;
        }

        public int getUniqueCount() {
            return this.uniqueCount;
        }

        public String getEntryAt(int idx) {
            return this.strings[idx];
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("sst".equals(name)) {
                String count = attributes.getValue("count");
                String uniqueCount = attributes.getValue("uniqueCount");
                this.count = Integer.parseInt(count);
                this.uniqueCount = Integer.parseInt(uniqueCount);
                this.strings = new String[this.uniqueCount];
                this.index = 0;
                this.characters = new StringBuilder();
            } else if ("si".equals(name)) {
                this.characters.setLength(0);
            } else if ("t".equals(name)) {
                this.tIsOpen = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if ("si".equals(name)) {
                this.strings[this.index] = this.characters.toString();
                ++this.index;
            } else if ("t".equals(name)) {
                this.tIsOpen = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.tIsOpen) {
                this.characters.append(ch, start, length);
            }
        }
    }

    static enum xssfDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER;

    }
}

