/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.parser;

import com.seeyon.ctp.common.encrypt.PipeHandle;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.parser.Excel2003EventUserModelParser;
import com.seeyon.ctp.common.parser.Excel2007EventUserModelParser;
import com.seeyon.ctp.common.parser.IFileParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.poi.extractor.POITextExtractor;
import org.apache.poi.ooxml.extractor.ExtractorFactory;

public class OfficeExtractor
implements IFileParser {
    private static final Log log = CtpLogFactory.getLog(OfficeExtractor.class);
    private File file;

    @Override
    public Reader getContentReader() {
        String s = this.getContentString();
        StringReader reader = null;
        if (s != null) {
            reader = new StringReader(s);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExcel2003EventModelParser() {
        block5: {
            String string;
            PipedInputStream in = null;
            FileInputStream fis = null;
            PipedOutputStream out = null;
            try {
                fis = new FileInputStream(this.file);
                in = new PipedInputStream();
                out = new PipedOutputStream(in);
                PipeHandle handle = new PipeHandle(fis, out);
                Thread t = new Thread(handle);
                t.start();
                Excel2003EventUserModelParser parser = new Excel2003EventUserModelParser(in);
                string = OfficeExtractor.docTextFilter(parser.getContentString());
                IOUtils.closeQuietly((InputStream)in);
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                break block5;
            }
            finally {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((InputStream)fis);
                IOUtils.closeQuietly(out);
            }
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly((OutputStream)out);
            return string;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExcel2007EventModelParser() {
        block5: {
            String string;
            PipedInputStream in = null;
            FileInputStream fis = null;
            PipedOutputStream out = null;
            try {
                fis = new FileInputStream(this.file);
                in = new PipedInputStream();
                out = new PipedOutputStream(in);
                PipeHandle handle = new PipeHandle(fis, out);
                Thread t = new Thread(handle);
                t.start();
                Excel2007EventUserModelParser parser = new Excel2007EventUserModelParser(in);
                string = OfficeExtractor.docTextFilter(parser.getContentString());
                IOUtils.closeQuietly((InputStream)in);
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                break block5;
            }
            finally {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((InputStream)fis);
                IOUtils.closeQuietly(out);
            }
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly((OutputStream)out);
            return string;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentString(String ... mimeType) {
        if (mimeType.length != 0 && "application/vnd.ms-excel".equals(mimeType[0])) {
            String str = "";
            try {
                str = this.getExcel2003EventModelParser();
            }
            catch (Exception e) {
                str = this.getExcel2007EventModelParser();
            }
            return str;
        }
        if (mimeType.length != 0 && "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(mimeType[0])) {
            String str = "";
            try {
                str = this.getExcel2007EventModelParser();
            }
            catch (Exception e) {
                str = this.getExcel2003EventModelParser();
            }
            return str;
        }
        PipedInputStream in = null;
        FileInputStream fis = null;
        PipedOutputStream out = null;
        POITextExtractor extractor = null;
        try {
            fis = new FileInputStream(this.file);
            in = new PipedInputStream();
            out = new PipedOutputStream(in);
            PipeHandle handle = new PipeHandle(fis, out);
            Thread t = new Thread(handle);
            t.start();
            extractor = ExtractorFactory.createExtractor((InputStream)in);
            String str = extractor.getText();
            String string = OfficeExtractor.docTextFilter(str);
            return string;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (extractor != null) {
                try {
                    extractor.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return "";
    }

    @Override
    public String getMetadata(String metadataname) {
        return null;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    public static String docTextFilter(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        str = str.replace("\u0013 TOC \\o \"1-3\" \\h \\z \\u \u0014", "").replace("TOC \\o \"1-2\" \\t \"", "").replaceAll("\u0013 HYPERLINK .. \"_Toc\\w*\" \u0001\u0014", "").replaceAll("\u0013 PAGEREF _Toc\\d{0,20} .{0,2} ", "").replaceAll("\u0013 HYPERLINK \".*\" \u0001\u0014", "").replaceAll("\u0013 PAGEREF _Toc\\d{0,20} ", "").replaceAll("\u0013 SHAPE  .\\* MERGEFORMAT ", "").replaceAll("\u0013 PAGE   .. MERGEFORMAT .*", "").replaceAll("\u0014", "").replaceAll("\u0007", "").replaceAll("\u000b", "").replaceAll("\u0015", "").replaceAll("\b", "").replaceAll("\u0001", "").replaceAll("\u0013", "").replaceAll("EMBED PBrush", "").replaceAll("null", "").replaceAll("[\\t\\n\\x0B\\f\\r]", "").replaceAll("<\\?xml:namespace.*?/>", "");
        return str;
    }

    @Override
    public String getContentString() {
        return null;
    }
}

