/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.parser;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class PDFDocumentHandler {
    private static final Log log = CtpLogFactory.getLog(PDFDocumentHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocument(InputStream is) {
        COSDocument cosDoc = null;
        String docText = null;
        try {
            cosDoc = PDFDocumentHandler.parseDocument(is);
            PDFTextStripper stripper = new PDFTextStripper();
            docText = stripper.getText(new PDDocument(cosDoc));
        }
        catch (IOException e) {
            log.error((Object)("\u6587\u6863\u4e2d\u5b58\u5728\u4e0d\u517c\u5bb9\u7684\u5185\u5bb9\uff0c\u5bf9\u8be5\u6587\u6863\u4e0d\u521b\u5efa\u7d22\u5f15(" + e.getLocalizedMessage() + "),\u5ffd\u7565"), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("error in get text(" + e.getLocalizedMessage() + "),\u5ffd\u7565"), (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)("PDF \u6587\u6863\u5185\u5bb9\u4e0d\u80fd\u89e3\u6790(" + e.getLocalizedMessage() + "),\u5ffd\u7565"), e);
        }
        finally {
            this.closeCOSDocument(cosDoc);
        }
        return docText;
    }

    private static COSDocument parseDocument(InputStream is) throws IOException {
        PDFParser parser = new PDFParser((RandomAccessRead)new RandomAccessBuffer(is));
        parser.parse();
        return parser.getDocument();
    }

    private void closeCOSDocument(COSDocument cosDoc) {
        if (cosDoc != null) {
            try {
                cosDoc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closePDDocument(PDDocument pdDoc) {
        if (pdDoc != null) {
            try {
                pdDoc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

