/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.parser;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.parser.IFileParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class PDFFileParser
implements IFileParser {
    private static final Log log = CtpLogFactory.getLog(PDFFileParser.class);
    private File file;
    private String title;
    private Map metadata;
    private String PASSWORD = "";
    private int START_PAGE = 0;
    private int END_PAGE = 0;

    public PDFFileParser() {
    }

    public PDFFileParser(File file) {
        this.setFile(file);
    }

    public PDFFileParser(File file, String password, int startpage, int endpage) {
        this.setFile(file, password, startpage, endpage);
    }

    @Override
    public void setFile(File file) {
        this.file = file;
        this.title = file.getName();
        this.metadata = new Hashtable();
    }

    public void setFile(File file, String password, int startpage, int endpage) {
        this.file = file;
        this.title = file.getName();
        this.PASSWORD = password;
        this.START_PAGE = startpage;
        this.END_PAGE = endpage;
        this.metadata = new HashMap();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContentString() {
        String s = "";
        try {
            PDFTextStripper stripper = new PDFTextStripper();
            StringWriter output = new StringWriter();
            PDDocument document = null;
            document = PDDocument.load((File)this.file);
            if (document.isEncrypted()) {
                try {
                    document = PDDocument.load((File)this.file, (String)this.PASSWORD);
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            if (this.START_PAGE != 0) {
                stripper.setStartPage(this.START_PAGE);
            }
            if (this.END_PAGE != 0) {
                stripper.setEndPage(this.END_PAGE);
            }
            stripper.writeText(document, (Writer)output);
            s = output.toString();
            output.close();
            document.close();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return s;
    }

    @Override
    public Reader getContentReader() {
        FileReader reader = null;
        try {
            reader = new FileReader(this.file);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return reader;
    }

    @Override
    public String getMetadata(String metadataname) {
        return (String)this.metadata.get(metadataname);
    }
}

