/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.progressBar;

import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.progressBar.CTPProgressBar;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CTPProgressUtil {
    private static final Map<String, CTPProgressBar> progressBars = new ConcurrentHashMap<String, CTPProgressBar>();

    public static void createNewProgressBar(String progressBarName, int total, String type, boolean reset) throws BusinessException {
        if (progressBars.get(progressBarName) != null && !reset) {
            throw new BusinessException("\u5df2\u5b58\u5728\u540c\u540d\u7684\u8fdb\u5ea6\u6761\uff0c\u6216\u8005\u4e4b\u524d\u7684\u8fdb\u5ea6\u6761\u6ca1\u6709\u91ca\u653e");
        }
        CTPProgressBar progressBar = new CTPProgressBar(total, 0, type);
        progressBars.put(progressBarName, progressBar);
    }

    public static int getCount4Type(String type) {
        int count = 0;
        ArrayList<CTPProgressBar> list = new ArrayList<CTPProgressBar>(progressBars.values());
        for (CTPProgressBar progress : list) {
            if (!progress.getType().equals(type)) continue;
            ++count;
        }
        return count;
    }

    public static void addOne(String progressBarName) throws BusinessException {
        CTPProgressBar progressBar = progressBars.get(progressBarName);
        if (progressBar == null) {
            throw new BusinessException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8fdb\u5ea6\u6761");
        }
        int current = progressBar.getCurrent();
        progressBar.setCurrent(++current);
        progressBars.put(progressBarName, progressBar);
    }

    public static void addMany(String progressBarName, int current) throws BusinessException {
        CTPProgressBar progressBar = progressBars.get(progressBarName);
        if (progressBar == null) {
            throw new BusinessException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8fdb\u5ea6\u6761");
        }
        progressBar.setCurrent(current);
        progressBars.put(progressBarName, progressBar);
    }

    public static CTPProgressBar getProgressBar(String progressBarName) {
        return progressBars.get(progressBarName);
    }

    public static void clearProgressBar(String progressBarName) {
        progressBars.remove(progressBarName);
    }
}

