/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.quartz;

import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.config.PropertiesLoader;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.quartz.QuartzRecover;
import com.seeyon.ctp.util.JDBCAgent;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.util.StopWatch;

public class QuartzListener
extends AbstractSystemInitializer {
    private static Log log = CtpLogFactory.getLog(QuartzListener.class);
    private static SchedulerFactory sf;
    private static Scheduler sched;

    @Override
    public int getSortOrder() {
        return super.getSortOrder() >= 0 ? 300 : super.getSortOrder();
    }

    @Override
    public void destroy() {
        try {
            sched.shutdown();
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void initialize() {
        try {
            QuartzRecover.clearIllegalTriggers();
            QuartzListener.getScheduler();
            new Thread((Runnable)new QuartzStarterThread(), QuartzStarterThread.class.getSimpleName()).start();
        }
        catch (Exception e) {
            log.error((Object)"*************************************************");
            log.error((Object)"***************  Quartz \u542f\u52a8\u51fa\u9519     *****************");
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            log.error((Object)"*************************************************");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Scheduler getScheduler() throws SchedulerException {
        if (sched == null) {
            try {
                String absolutePath = AppContext.getCfgHome().getAbsolutePath();
                String filename = absolutePath + "/base/quartz.properties";
                String dbType = JDBCAgent.getDBType();
                if (dbType == null) {
                    Connection conn = null;
                    try {
                        conn = JDBCAgent.getRawConnection("java:comp/env/jdbc/ctpDataSource");
                        dbType = conn.getMetaData().getDatabaseProductName();
                    }
                    catch (SQLException e) {
                        log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    finally {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException e) {
                                log.error((Object)"\u8fde\u63a5\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                            }
                        }
                    }
                }
                if (NotificationManager.getInstance().isEnabled()) {
                    filename = "SQLServer".equalsIgnoreCase(dbType) ? absolutePath + "/base/quartz-cluster-sqlserver.properties" : absolutePath + "/base/quartz-cluster.properties";
                    log.info((Object)"\u542f\u52a8Quartz\u96c6\u7fa4\u3002");
                } else {
                    log.info((Object)"\u542f\u52a8Quartz\u5355\u673a\u3002");
                }
                Properties properties = PropertiesLoader.load(new File(filename));
                if ("PostgreSQL".equalsIgnoreCase(dbType)) {
                    properties.put("org.quartz.jobStore.driverDelegateClass", "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate");
                }
                if (SystemEnvironment.isDistributedMode()) {
                    properties.put("org.quartz.scheduler.instanceName", "CTPQuartzScheduler_" + SystemEnvironment.getAppId());
                }
                sf = new StdSchedulerFactory(properties);
                sched = sf.getScheduler();
            }
            catch (SchedulerException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return sched;
    }

    static {
        sched = null;
    }

    class QuartzStarterThread
    implements Runnable {
        QuartzStarterThread() {
        }

        @Override
        public void run() {
            if (sched == null) {
                log.error((Object)"Quartz \u542f\u52a8\u51fa\u9519 \u8bf7\u68c0\u67e5Quartz\u914d\u7f6e *****************");
            } else {
                try {
                    StopWatch watch = new StopWatch();
                    watch.start();
                    sched.start();
                    watch.stop();
                    log.info((Object)("Quartz \u542f\u52a8\u5b8c\u6210\uff01\u8017\u65f6\uff1a" + watch.getTotalTimeMillis() + "\u6beb\u79d2"));
                }
                catch (Exception e) {
                    log.error((Object)"*************************************************");
                    log.error((Object)"***************  Quartz \u542f\u52a8\u51fa\u9519  *****************");
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    log.error((Object)"*************************************************");
                }
            }
        }
    }
}

