/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.quartz;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.datasource.CtpDynamicDataSource;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMSQLOperation;
import com.seeyon.ctp.util.JDBCAgent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.quartz.Job;

public class QuartzRecover {
    private static Log log = CtpLogFactory.getLog(QuartzRecover.class);
    private static AtomicBoolean hasInitializeSql = new AtomicBoolean(false);
    private static final String SELECT_DISTINCT_JOB_CLASS_NAME = "select distinct JOB_CLASS_NAME from JK_JOB_DETAILS";
    private static String deleteSimpleTrigger = "from JK_SIMPLE_TRIGGERS st where exists(select 1 from JK_TRIGGERS tr where st.TRIGGER_NAME=tr.TRIGGER_NAME and st.TRIGGER_GROUP=tr.TRIGGER_GROUP and exists(select 1 from JK_JOB_DETAILS jd where jd.JOB_NAME=tr.JOB_NAME and jd.JOB_GROUP=tr.JOB_GROUP and jd.JOB_CLASS_NAME = ?))";
    private static String deleteCronTrigger = "from JK_CRON_TRIGGERS st where exists(select 1 from JK_TRIGGERS tr where st.TRIGGER_NAME=tr.TRIGGER_NAME and st.TRIGGER_GROUP=tr.TRIGGER_GROUP and exists(select 1 from JK_JOB_DETAILS jd where jd.JOB_NAME=tr.JOB_NAME and jd.JOB_GROUP=tr.JOB_GROUP and jd.JOB_CLASS_NAME = ?))";
    private static String deleteTrigger = "from JK_TRIGGERS tr where exists(select 1 from JK_JOB_DETAILS jd where jd.JOB_NAME=tr.JOB_NAME and jd.JOB_GROUP=tr.JOB_GROUP and jd.JOB_CLASS_NAME = ?)";
    private static String deleteRubbishSimpleTrigger = "from JK_SIMPLE_TRIGGERS st where not exists(select 1 from JK_TRIGGERS tr where st.TRIGGER_NAME=tr.TRIGGER_NAME and st.TRIGGER_GROUP=tr.TRIGGER_GROUP) or exists(select 1 from JK_TRIGGERS tr where st.TRIGGER_NAME=tr.TRIGGER_NAME and st.TRIGGER_GROUP=tr.TRIGGER_GROUP and not exists(select 1 from JK_JOB_DETAILS jd where jd.JOB_NAME=tr.JOB_NAME and jd.JOB_GROUP=tr.JOB_GROUP))";
    private static String deleteRubbishCronTrigger = "from JK_CRON_TRIGGERS st where not exists(select 1 from JK_TRIGGERS tr where st.TRIGGER_NAME=tr.TRIGGER_NAME and st.TRIGGER_GROUP=tr.TRIGGER_GROUP) or exists(select 1 from JK_TRIGGERS tr where st.TRIGGER_NAME=tr.TRIGGER_NAME and st.TRIGGER_GROUP=tr.TRIGGER_GROUP and not exists(select 1 from JK_JOB_DETAILS jd where jd.JOB_NAME=tr.JOB_NAME and jd.JOB_GROUP=tr.JOB_GROUP))";
    private static String deleteRubbishTrigger = "from JK_TRIGGERS tr where not exists(select 1 from JK_JOB_DETAILS jd where jd.JOB_NAME=tr.JOB_NAME and jd.JOB_GROUP=tr.JOB_GROUP) or (not exists (select 1 from JK_SIMPLE_TRIGGERS jst where jst.TRIGGER_NAME=tr.TRIGGER_NAME and jst.TRIGGER_GROUP=tr.TRIGGER_GROUP) and not exists (select 1 from JK_CRON_TRIGGERS jct where jct.TRIGGER_NAME=tr.TRIGGER_NAME and jct.TRIGGER_GROUP=tr.TRIGGER_GROUP))";
    private static String deleteRubbishJob = "from JK_JOB_DETAILS jd where not exists(select 1 from JK_TRIGGERS tr where jd.JOB_NAME=tr.JOB_NAME and jd.JOB_GROUP=tr.JOB_GROUP)";
    private static final String DELETE_JOB = "delete from JK_JOB_DETAILS where JOB_CLASS_NAME = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void clearIllegalTriggers() {
        block11: {
            log.info((Object)"**************** Begin Clear Illegal Triggers **************** ");
            Connection conn = null;
            PreparedStatement pStmt = null;
            ResultSet rs = null;
            int jobCount = 0;
            int triggerCount = 0;
            try {
                CtpDynamicDataSource.setDataSourceKey(DataSourceName.BASE.getSource());
                conn = JDBCAgent.getRawConnection();
                conn.setAutoCommit(false);
                String databaseType = conn.getMetaData().getDatabaseProductName().toUpperCase();
                QuartzRecover.initializeSql(databaseType);
                pStmt = conn.prepareStatement(SELECT_DISTINCT_JOB_CLASS_NAME);
                HashSet<String> badClassSet = new HashSet<String>();
                JDBCAgent.putTrackTableInfo(JMSQLOperation.Select, "JK_JOB_DETAILS");
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    String clzName = rs.getString(1);
                    try {
                        if (Job.class.isAssignableFrom(Class.forName(clzName))) continue;
                        log.info((Object)("----\u53d1\u73b0\u6ca1\u6709\u5b9e\u73b0Job\u63a5\u53e3\u7684JobDetail\uff0cClassName\uff1a" + clzName));
                        badClassSet.add(clzName);
                    }
                    catch (ClassNotFoundException ce) {
                        log.info((Object)("----\u53d1\u73b0\u6ca1\u6709\u76f8\u5e94Class\u7c7b\u7684JobDetail\uff0cClassName\uff1a" + clzName));
                        badClassSet.add(clzName);
                    }
                }
                QuartzRecover.closeResultSet(rs);
                QuartzRecover.closePStmt(pStmt);
                for (String badClzName : badClassSet) {
                    JDBCAgent.putTrackTableInfo(JMSQLOperation.Delete, "JK_SIMPLE_TRIGGERS", "JK_TRIGGERS");
                    pStmt = conn.prepareStatement(deleteSimpleTrigger);
                    pStmt.setString(1, badClzName);
                    pStmt.executeUpdate();
                    QuartzRecover.closePStmt(pStmt);
                    JDBCAgent.putTrackTableInfo(JMSQLOperation.Delete, "JK_CRON_TRIGGERS", "JK_TRIGGERS");
                    pStmt = conn.prepareStatement(deleteCronTrigger);
                    pStmt.setString(1, badClzName);
                    pStmt.executeUpdate();
                    QuartzRecover.closePStmt(pStmt);
                    JDBCAgent.putTrackTableInfo(JMSQLOperation.Delete, "JK_TRIGGERS", "JK_JOB_DETAILS");
                    pStmt = conn.prepareStatement(deleteTrigger);
                    pStmt.setString(1, badClzName);
                    triggerCount += pStmt.executeUpdate();
                    QuartzRecover.closePStmt(pStmt);
                    JDBCAgent.putTrackTableInfo(JMSQLOperation.Delete, "JK_JOB_DETAILS");
                    pStmt = conn.prepareStatement(DELETE_JOB);
                    pStmt.setString(1, badClzName);
                    jobCount += pStmt.executeUpdate();
                    QuartzRecover.closePStmt(pStmt);
                }
                JDBCAgent.putTrackTableInfo(JMSQLOperation.Delete, "JK_SIMPLE_TRIGGERS", "JK_TRIGGERS");
                pStmt = conn.prepareStatement(deleteRubbishSimpleTrigger);
                QuartzRecover.closePStmt(pStmt);
                JDBCAgent.putTrackTableInfo(JMSQLOperation.Delete, "JK_CRON_TRIGGERS", "JK_TRIGGERS");
                pStmt = conn.prepareStatement(deleteRubbishCronTrigger);
                QuartzRecover.closePStmt(pStmt);
                JDBCAgent.putTrackTableInfo(JMSQLOperation.Delete, "JK_TRIGGERS", "JK_JOB_DETAILS");
                pStmt = conn.prepareStatement(deleteRubbishTrigger);
                triggerCount += pStmt.executeUpdate();
                QuartzRecover.closePStmt(pStmt);
                JDBCAgent.putTrackTableInfo(JMSQLOperation.Delete, "JK_JOB_DETAILS", "JK_TRIGGERS");
                pStmt = conn.prepareStatement(deleteRubbishJob);
                jobCount += pStmt.executeUpdate();
                QuartzRecover.closePStmt(pStmt);
                conn.commit();
                QuartzRecover.closeResultSet(rs);
            }
            catch (SQLException e) {
                QuartzRecover.rollbackConn(conn);
                log.error((Object)e.getMessage(), (Throwable)e);
                break block11;
            }
            catch (Exception e2) {
                QuartzRecover.rollbackConn(conn);
                log.error((Object)e2.getMessage(), (Throwable)e2);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                QuartzRecover.closeResultSet(rs);
                QuartzRecover.closePStmt(pStmt);
                QuartzRecover.closeConn(conn);
                CtpDynamicDataSource.clearDataSourceKey();
                log.info((Object)("\u672c\u6b21\u5171\u6e05\u7406 " + triggerCount + "\u6761  triggers \u548c  " + jobCount + "\u6761 jobs"));
            }
            QuartzRecover.closePStmt(pStmt);
            QuartzRecover.closeConn(conn);
            CtpDynamicDataSource.clearDataSourceKey();
            log.info((Object)("\u672c\u6b21\u5171\u6e05\u7406 " + triggerCount + "\u6761  triggers \u548c  " + jobCount + "\u6761 jobs"));
        }
    }

    private static synchronized void initializeSql(String databaseType) {
        if (hasInitializeSql.get()) {
            return;
        }
        if ("MYSQL".equals(databaseType) || databaseType.contains("SQL SERVER")) {
            deleteSimpleTrigger = "delete st " + deleteSimpleTrigger;
            deleteCronTrigger = "delete st " + deleteCronTrigger;
            deleteTrigger = "delete tr " + deleteTrigger;
            deleteRubbishSimpleTrigger = "delete st " + deleteRubbishSimpleTrigger;
            deleteRubbishCronTrigger = "delete st " + deleteRubbishCronTrigger;
            deleteRubbishTrigger = "delete tr " + deleteRubbishTrigger;
            deleteRubbishJob = "delete jd " + deleteRubbishJob;
        } else {
            deleteSimpleTrigger = "delete " + deleteSimpleTrigger;
            deleteCronTrigger = "delete " + deleteCronTrigger;
            deleteTrigger = "delete " + deleteTrigger;
            deleteRubbishSimpleTrigger = "delete " + deleteRubbishSimpleTrigger;
            deleteRubbishCronTrigger = "delete " + deleteRubbishCronTrigger;
            deleteRubbishTrigger = "delete " + deleteRubbishTrigger;
            deleteRubbishJob = "delete " + deleteRubbishJob;
        }
        hasInitializeSql.set(true);
    }

    private static void rollbackConn(Connection conn) {
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void closeConn(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void closePStmt(PreparedStatement pStmt) {
        if (pStmt != null) {
            try {
                pStmt.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

