/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.script;

import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class CompiledScriptRunner {
    private ScriptEngineManager manager = new ScriptEngineManager();
    private final ScriptEngine engine;
    private CompiledScript cscript;
    private final String script;

    public CompiledScriptRunner(String script) {
        this("groovy", script);
    }

    public CompiledScriptRunner(ScriptEngine engine, String script) {
        this.engine = engine;
        this.script = script;
    }

    public CompiledScriptRunner(String engineName, String script) {
        this.engine = this.manager.getEngineByName(engineName);
        this.script = script;
    }

    private void compile() throws ScriptException {
        if (this.cscript == null) {
            Compilable compEngine = (Compilable)((Object)this.engine);
            this.cscript = compEngine.compile(this.script);
        }
    }

    public Object eval(Map<String, Object> params) throws ScriptException {
        this.compile();
        SimpleBindings bindings = new SimpleBindings(params);
        return this.cscript.eval(bindings);
    }

    public String toString() {
        if (this.cscript != null) {
            return this.cscript.getClass().toString();
        }
        return "";
    }
}

