/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.security;

import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.exceptions.BusinessException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class AnonymousRequestPolicy {
    private static Log LOG = LogFactory.getLog(AnonymousRequestPolicy.class);
    private static int valueThreshold = SystemProperties.getInstance().getIntegerProperty("ctp.anonymous.request.param.valueLengthThreshold");
    private static int totalThreshold = SystemProperties.getInstance().getIntegerProperty("ctp.anonymous.request.param.totalLengthThreshold");
    private static int paramCountThreshold = SystemProperties.getInstance().getIntegerProperty("ctp.anonymous.request.param.countThreshold");

    public static void accept(ServletRequest req, ServletResponse resp) throws BusinessException {
        if (req instanceof HttpServletRequest && resp instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpSession session = request.getSession(false);
            if (session != null && session.getAttribute("com.seeyon.current_user") != null) {
                return;
            }
            String uri = request.getRequestURI();
            String url = uri + "?" + request.getQueryString();
            boolean isMultipart = request instanceof MultipartHttpServletRequest;
            if (isMultipart) {
                throw new BusinessException("\u4e0d\u63a5\u53d7\u53d1\u8d77Multipart\u7c7b\u578b\u7684\u533f\u540d\u8bf7\u6c42\u3002" + request.getQueryString());
            }
        }
    }

    private static void accept(int value, int threshold, String msg) throws BusinessException {
        if (value > threshold) {
            String message = msg + threshold + "\uff0c\u5f53\u524d\u503c\u4e3a" + value;
            LOG.error((Object)message);
        }
    }
}

