/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.service;

import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.code.CustomCode;
import com.seeyon.ctp.common.code.EnumsCode;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.common.service.CTPCodeManager;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UniqueList;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.ctp.util.json.model.JSONValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LinkedMap;

public class CTPCodeManagerImpl
implements CTPCodeManager {
    private EnumManager enumManagerNew;

    /*
     * Could not resolve type clashes
     */
    @Override
    public Object select(String jsonStr) throws BusinessException {
        try {
            Object jsonData = JSONUtil.parseJSONString(jsonStr);
            if (jsonData instanceof List) {
                List data = (List)jsonData;
                HashMap cache = new HashMap();
                for (int i = 0; i < data.size(); ++i) {
                    LinkedHashMap option1;
                    Map<String, String> option;
                    Map dmap = (Map)data.get(i);
                    LinkedMap mp = new LinkedMap();
                    for (String key : dmap.keySet()) {
                        mp.put(key.trim(), String.valueOf(dmap.get(key)).trim());
                    }
                    dmap.putAll(mp);
                    String codeTypeStr = (String)dmap.get("codeType");
                    String codeIdStr = (String)dmap.get("codeId");
                    String valueType = "";
                    String codeIdType = "";
                    String showLevel = "";
                    if (dmap.containsKey("valueType")) {
                        valueType = (String)dmap.get("valueType");
                    }
                    if (dmap.containsKey("codeIdType")) {
                        codeIdType = (String)dmap.get("codeIdType");
                    }
                    if (dmap.containsKey("showLevel")) {
                        showLevel = (String)dmap.get("showLevel");
                    }
                    if (codeIdStr == null) continue;
                    if ("java".equals(codeTypeStr)) {
                        option = new LinkedHashMap();
                        Class<?> cls = Class.forName(codeIdStr);
                        Class<?>[] intClses = cls.getInterfaces();
                        boolean isCode = false;
                        boolean isCustomCode = false;
                        for (String[] intCls : intClses) {
                            if (intCls.equals(EnumsCode.class)) {
                                isCode = true;
                                break;
                            }
                            if (!intCls.equals(CustomCode.class)) continue;
                            isCustomCode = true;
                            break;
                        }
                        if (isCode && cls.isEnum()) {
                            Enum[] enums;
                            String excludes = (String)dmap.get("excludes");
                            ArrayList<String> excludesList = null;
                            if (Strings.isNotBlank(excludes)) {
                                String[] intCls;
                                String[] excludeArray = excludes.split(",");
                                excludesList = new ArrayList<String>();
                                intCls = excludeArray;
                                int n = intCls.length;
                                for (int j = 0; j < n; ++j) {
                                    String excludeKey = intCls[j];
                                    if (!Strings.isNotBlank(excludeKey)) continue;
                                    excludesList.add(excludeKey.trim());
                                }
                            }
                            boolean isModuleTypeActivePlugin = cls.equals(ModuleType.class) && "true".equals(dmap.get("activePlugin"));
                            for (Enum em : enums = (Enum[])cls.getEnumConstants()) {
                                if (isModuleTypeActivePlugin) {
                                    boolean match = false;
                                    for (String pluginId : SystemEnvironment.getPluginIds()) {
                                        if (!pluginId.equalsIgnoreCase(em.name())) continue;
                                        match = true;
                                        break;
                                    }
                                    if (!match) continue;
                                }
                                EnumsCode enuCode = (EnumsCode)((Object)em);
                                if (null != excludesList && excludesList.contains(enuCode.getValue())) continue;
                                option.put(enuCode.getValue(), enuCode.getText());
                            }
                        } else if (isCustomCode) {
                            HashMap cacheKey = new HashMap();
                            for (String ckey : dmap.keySet()) {
                                if ("eleid".equals(ckey) || "defaultValue".equals(ckey)) continue;
                                cacheKey.put(ckey, dmap.get(ckey));
                            }
                            if (cache.containsKey(cacheKey)) {
                                option = (Map)cache.get(cacheKey);
                            } else {
                                CustomCode customCode = (CustomCode)cls.newInstance();
                                option = customCode.getCodesMap(cacheKey);
                                cache.put(cacheKey, option);
                            }
                        }
                        option1 = option;
                    } else {
                        option = new LinkedHashMap();
                        Long id = this.enumManagerNew.getEnumIdByProCode(codeIdStr);
                        if ("id".equals(codeIdType)) {
                            try {
                                id = Long.valueOf(codeIdStr);
                            }
                            catch (Exception intClses) {
                                // empty catch block
                            }
                        }
                        if (id != null) {
                            boolean isQuery = "true".equals(dmap.get("query"));
                            List<Object> items = new UniqueList();
                            items = "first".equals(showLevel) ? this.enumManagerNew.getFirstLevelItemsByEmumId(id) : ("last".equals(showLevel) ? this.enumManagerNew.getLastCtpEnumItem(id) : this.enumManagerNew.getEmumItemByEmumId(id));
                            for (CtpEnumItem item : items) {
                                if (isQuery && !Strings.equals(item.getOutputSwitch(), 1) || !isQuery && !Strings.equals(item.getState(), 1)) continue;
                                String text = item.getShowvalue();
                                if (Strings.equals(item.getI18n(), 1)) {
                                    text = ResourceUtil.getString(text);
                                }
                                if ("enumId".equals(valueType)) {
                                    option.put(item.getId().toString(), text);
                                    continue;
                                }
                                option.put(item.getEnumvalue(), text);
                            }
                        }
                        option1 = option;
                    }
                    dmap.put("options", option1);
                }
                return jsonData;
            }
            throw new BusinessException("\u975e\u6cd5\u7684\u8bf7\u6c42\u6570\u636e\u683c\u5f0f\uff01");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BusinessException(e);
        }
    }

    @Override
    public String selectCode(String jsonStr) throws BusinessException {
        JSONValue jdata = JSONValue.decorate(this.select(jsonStr));
        String result = jdata.render(false);
        return result;
    }

    public EnumManager getEnumManagerNew() {
        return this.enumManagerNew;
    }

    public void setEnumManagerNew(EnumManager enumManager) {
        this.enumManagerNew = enumManager;
    }
}

