/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.service;

import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.security.NeedlessLoginBean;
import com.seeyon.ctp.util.annotation.AnnotationAware;
import com.seeyon.ctp.util.annotation.AnnotationFactory;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.springframework.core.io.ClassPathResource;

public class NeedlessCheckLoginAnnotationAware
extends AbstractSystemInitializer
implements AnnotationAware {
    private static Log logger = CtpLogFactory.getLog(NeedlessCheckLoginAnnotationAware.class);
    public static Map<String, Set<String>> needlessUrlMap = new HashMap<String, Set<String>>();
    private AnnotationFactory annotationFactory;

    @Override
    public void setAnnotationFactory(AnnotationFactory annotationFactory) {
        this.annotationFactory = annotationFactory;
    }

    public Map<String, Set<String>> getNeedlessUrlMap() {
        return needlessUrlMap;
    }

    @Override
    public void initialize() {
        this.initNeedlessLoginBeans();
    }

    private void initNeedlessLoginBeans() {
        XStream xStream = new XStream();
        try {
            xStream.allowTypes(new Class[]{NeedlessLoginBean.class});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        xStream.aliasType("bean", NeedlessLoginBean.class);
        xStream.aliasType("beans", ArrayList.class);
        xStream.aliasType("method", String.class);
        ClassPathResource needlessCheckLoginResource = new ClassPathResource("needless_check_login.xml");
        try {
            List needlessLoginBeans = (List)xStream.fromXML(needlessCheckLoginResource.getInputStream());
            for (NeedlessLoginBean bean : needlessLoginBeans) {
                if (bean.getId() == null || bean.getMethods() == null) continue;
                HashSet<String> methods = new HashSet<String>();
                for (String method : bean.getMethods()) {
                    methods.add(method);
                }
                needlessUrlMap.put(bean.getId(), methods);
            }
        }
        catch (IOException e) {
            logger.error((Object)"\u89e3\u6790needless_check_login.xml\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getSortOrder() {
        return -5;
    }
}

