/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.task;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.datasource.CtpDynamicDataSource;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.thread.ThreadInfoHolder;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

public abstract class AsynchronousBatchTask<E> {
    private static final Log log = CtpLogFactory.getLog(AsynchronousBatchTask.class);
    private List<E> tasks = new ArrayList(100);
    private Object lock = new Object();
    private Class clazz;
    private int intervalTime = 8;
    private AsynchronousBatchTaskThread t;
    private DataSourceName dataSourceName = DataSourceName.MAIN;
    private volatile boolean settedDSName = false;

    public void setDataSourceName(DataSourceName dataSourceName) {
        if (this.settedDSName || dataSourceName == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getClass().getSimpleName() + "[AsynchronousBatchTask] set dataSource[" + dataSourceName.getSource() + "]"));
        }
        this.dataSourceName = dataSourceName;
        this.settedDSName = true;
    }

    private void start0() {
        if (this.t == null) {
            this.t = new AsynchronousBatchTaskThread();
            this.t.start();
            log.info((Object)("\u542f\u52a8\u5f02\u6b65\u6279\u91cf\u4efb\u52a1\u7ebf\u7a0b\uff1a" + this.t.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(E e) {
        if (e == null) {
            return;
        }
        if (this.clazz == null) {
            this.clazz = e.getClass();
        }
        Object object = this.lock;
        synchronized (object) {
            this.start0();
            this.tasks.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<E> getAll() {
        ArrayList<E> result = null;
        Object object = this.lock;
        synchronized (object) {
            result = new ArrayList<E>(this.tasks);
            this.tasks.clear();
        }
        return result;
    }

    public int getLength() {
        return this.tasks.size();
    }

    public boolean isStarted() {
        return this.t != null && this.t.running;
    }

    public String getABThreadName() {
        return this.clazz != null ? this.clazz.getSimpleName() : "unknow";
    }

    public int getIntervalTime() {
        return this.intervalTime;
    }

    protected abstract void doBatch(List<E> var1);

    class AsynchronousBatchTaskThread
    extends Thread {
        boolean running = true;

        public AsynchronousBatchTaskThread() {
            AsynchronousBatchTask.this.intervalTime = Math.max(AsynchronousBatchTask.this.getIntervalTime(), 5);
            super.setName("BatchTask-" + AsynchronousBatchTask.this.getABThreadName() + "_" + AsynchronousBatchTask.this.intervalTime);
        }

        @Override
        public synchronized void start() {
            super.start();
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    CtpDynamicDataSource.setDataSourceKey(AsynchronousBatchTask.this.dataSourceName.getSource());
                    ThreadInfoHolder.getInstance().initThread(Thread.currentThread());
                    try {
                        List list = AsynchronousBatchTask.this.getAll();
                        if (!Strings.isEmpty(list)) {
                            AsynchronousBatchTask.this.doBatch(list);
                        }
                    }
                    catch (Throwable e) {
                        log.error((Object)"", e);
                    }
                }
                finally {
                    CtpDynamicDataSource.clearDataSourceKey();
                    ThreadInfoHolder.getInstance().remove(Thread.currentThread());
                }
                try {
                    Thread.sleep((long)AsynchronousBatchTask.this.intervalTime * 1000L);
                }
                catch (Throwable e) {
                    log.error((Object)"", e);
                }
            }
        }
    }
}

