/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.urlshortener;

import com.seeyon.ctp.common.dao.BaseDao;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.po.urlshortener.CtpShortURL;
import com.seeyon.ctp.common.urlshortener.URLMapperDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.classic.Session;
import org.hibernate.jdbc.Work;
import org.springframework.orm.hibernate3.HibernateCallback;

public class URLMapperDaoImpl
extends BaseDao<CtpShortURL>
implements URLMapperDao {
    private static final Log LOG = LogFactory.getLog(URLMapperDaoImpl.class);

    @Override
    public CtpShortURL findByUrl(String url) throws BusinessException {
        List list = super.findBy("url", url);
        if (CollectionUtils.isNotEmpty(list)) {
            return (CtpShortURL)list.get(0);
        }
        return null;
    }

    @Override
    public CtpShortURL findByShortUrl(String shortUrl) throws BusinessException {
        List list = super.findBy("shortUrl", shortUrl);
        if (CollectionUtils.isNotEmpty(list)) {
            return (CtpShortURL)list.get(0);
        }
        return null;
    }

    @Override
    public int getNextSerialNo(CtpShortURL ctx) throws BusinessException {
        final Long id = ctx.getId();
        for (int i = 0; i < 5; ++i) {
            boolean success = this.generateSerialNo(id);
            if (!success) continue;
            final AtomicInteger serial = new AtomicInteger(0);
            Session session = this.getSessionFactory().openSession();
            session.doWork(new Work(){
                private String sql = "select serial_no from ctp_short_url where id=?";

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(Connection connection) throws SQLException {
                    block6: {
                        PreparedStatement stmt = null;
                        ResultSet rs = null;
                        try {
                            stmt = connection.prepareStatement(this.sql);
                            stmt.setLong(1, id);
                            rs = stmt.executeQuery();
                            if (rs.next()) {
                                serial.set(rs.getInt(1));
                            }
                            URLMapperDaoImpl.closeQuietly(rs);
                        }
                        catch (Exception e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                            break block6;
                        }
                        finally {
                            URLMapperDaoImpl.closeQuietly(rs);
                            URLMapperDaoImpl.closeQuietly(stmt);
                        }
                        URLMapperDaoImpl.closeQuietly(stmt);
                    }
                }
            });
            session.close();
            int serialNo = serial.get();
            if (serialNo == 0) continue;
            return serialNo;
        }
        throw new BusinessException("can not generate serial no");
    }

    private boolean generateSerialNo(final Long id) {
        final AtomicBoolean lockSuccess = new AtomicBoolean(true);
        this.getHibernateTemplate().executeWithNewSession(new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                session.doWork(new Work(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(Connection connection) throws SQLException {
                        boolean autoCommit = connection.getAutoCommit();
                        if (autoCommit) {
                            connection.setAutoCommit(false);
                        }
                        PreparedStatement stmt = null;
                        try {
                            String sql = "insert into ctp_short_url (serial_no,id,s_algorithm) select COALESCE(MAX(serial_no)+1, 1),?,? from ctp_short_url where s_algorithm=?";
                            stmt = connection.prepareStatement(sql);
                            stmt.setLong(1, id);
                            stmt.setInt(2, 1);
                            stmt.setInt(3, 1);
                            stmt.execute();
                            connection.commit();
                        }
                        catch (Exception e) {
                            try {
                                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                lockSuccess.set(false);
                            }
                            catch (Throwable throwable) {
                                URLMapperDaoImpl.closeQuietly(stmt);
                                if (autoCommit) {
                                    connection.setAutoCommit(true);
                                }
                                throw throwable;
                            }
                            URLMapperDaoImpl.closeQuietly(stmt);
                            if (autoCommit) {
                                connection.setAutoCommit(true);
                            }
                        }
                        URLMapperDaoImpl.closeQuietly(stmt);
                        if (autoCommit) {
                            connection.setAutoCommit(true);
                        }
                    }
                });
                return null;
            }
        });
        return lockSuccess.get();
    }

    public static void closeQuietly(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public static void closeQuietly(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

