/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.urlshortener;

import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.po.urlshortener.CtpShortURL;
import com.seeyon.ctp.common.urlshortener.SerialManager;
import com.seeyon.ctp.common.urlshortener.URLGenerator;
import com.seeyon.ctp.common.urlshortener.URLMapper;
import org.springframework.util.Assert;

public class URLShortener {
    private static URLMapper urlMapperManager;
    public static final int ALGORITHM = 1;

    public static URLMapper getUrlMapper() {
        return urlMapperManager;
    }

    public static void setUrlMapperManager(URLMapper urlMapper) {
        urlMapperManager = urlMapper;
    }

    public static String getShortURL(String url) throws BusinessException {
        String shortUrl;
        Assert.notNull((Object)url);
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        if ((shortUrl = urlMapperManager.getShortUrl(url)) != null) {
            return shortUrl;
        }
        CtpShortURL po = new CtpShortURL();
        po.setUrl(url);
        int serialNo = ((SerialManager)((Object)urlMapperManager)).getNextSerialNo(po);
        po.setSerialNo(serialNo);
        po.setAlgorithm(1);
        shortUrl = URLGenerator.encode(serialNo);
        po.setShortUrl(shortUrl);
        urlMapperManager.mapping(po);
        return shortUrl;
    }

    public static String getUrl(String shortUrl) throws BusinessException {
        Assert.notNull((Object)shortUrl);
        return urlMapperManager.getUrl(shortUrl.toLowerCase());
    }
}

