/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.web.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.owasp.csrfguard.log.ILogger;
import org.owasp.csrfguard.log.LogLevel;

public class CTPCsrfJavaLogger
implements ILogger {
    private static final long serialVersionUID = -4857601483759096197L;
    private static final Log LOGGER = LogFactory.getLog(CTPCsrfJavaLogger.class);

    public void log(String msg) {
        LOGGER.info((Object)msg.replaceAll("(\\r|\\n)", ""));
    }

    public void log(LogLevel level, String msg) {
        String sanitizedMsg = msg.replaceAll("(\\r|\\n)", "");
        switch (level) {
            case Trace: {
                LOGGER.trace((Object)sanitizedMsg);
                break;
            }
            case Debug: {
                LOGGER.debug((Object)sanitizedMsg);
                break;
            }
            case Info: {
                LOGGER.info((Object)sanitizedMsg);
                break;
            }
            case Warning: {
                LOGGER.warn((Object)sanitizedMsg);
                break;
            }
            case Error: {
                LOGGER.error((Object)sanitizedMsg);
                break;
            }
            case Fatal: {
                LOGGER.fatal((Object)sanitizedMsg);
                break;
            }
            default: {
                throw new RuntimeException("unsupported log level " + level);
            }
        }
    }

    public void log(Exception exception) {
        LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
    }

    public void log(LogLevel level, Exception exception) {
        switch (level) {
            case Trace: {
                LOGGER.trace((Object)exception.getLocalizedMessage(), (Throwable)exception);
                break;
            }
            case Debug: {
                LOGGER.debug((Object)exception.getLocalizedMessage(), (Throwable)exception);
                break;
            }
            case Info: {
                LOGGER.info((Object)exception.getLocalizedMessage(), (Throwable)exception);
                break;
            }
            case Warning: {
                LOGGER.warn((Object)exception.getLocalizedMessage(), (Throwable)exception);
                break;
            }
            case Error: {
                LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                break;
            }
            case Fatal: {
                LOGGER.fatal((Object)exception.getLocalizedMessage(), (Throwable)exception);
                break;
            }
            default: {
                throw new RuntimeException("unsupported log level " + level);
            }
        }
    }
}

