/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.web.filter;

import com.seeyon.ctp.common.rate.SeeyonRateLimitException;
import com.seeyon.ctp.common.rate.SeeyonRateLimiter;
import com.seeyon.ctp.common.web.filter.CTPPasswordRequestFacade;
import com.seeyon.ctp.common.web.filter.CTPRequestFacade;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class CharacterEncodingFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object req = null;
        boolean isMultipart = request instanceof MultipartHttpServletRequest;
        String requestBodyEncoding = request.getCharacterEncoding();
        req = isMultipart ? (HttpServletRequest)request : ("UTF-8".equalsIgnoreCase(requestBodyEncoding) ? new CTPPasswordRequestFacade((HttpServletRequest)request) : new CTPRequestFacade((HttpServletRequest)request));
        if (SeeyonRateLimiter.isLimitValid()) {
            this.checkRateLimit((HttpServletRequest)req);
        }
        chain.doFilter((ServletRequest)req, response);
    }

    private void checkRateLimit(HttpServletRequest req) throws SeeyonRateLimitException {
        String uri = req.getRequestURI();
        uri = uri.substring(req.getContextPath().length() + 1, uri.length());
        Map<String, SeeyonRateLimiter.RateLimit> limitMap = null;
        limitMap = SeeyonRateLimiter.getLimitMap(uri);
        if (limitMap != null) {
            SeeyonRateLimiter.RateLimit matchRateLimit = null;
            block0: for (Map.Entry<String, SeeyonRateLimiter.RateLimit> rateLimitEntry : limitMap.entrySet()) {
                if (matchRateLimit != null) break;
                SeeyonRateLimiter.RateLimit rateLimit = rateLimitEntry.getValue();
                Map<String, String> paramMap = rateLimit.getParamMap();
                if (paramMap != null) {
                    for (Map.Entry<String, String> paramEntry : paramMap.entrySet()) {
                        if (paramEntry.getValue().equals(req.getParameter(paramEntry.getKey()))) {
                            matchRateLimit = rateLimit;
                            continue;
                        }
                        matchRateLimit = null;
                        continue block0;
                    }
                    continue;
                }
                matchRateLimit = rateLimit;
                break;
            }
            if (matchRateLimit != null && !SeeyonRateLimiter.acquire(matchRateLimit)) {
                req.setAttribute("HINT_INFO", (Object)matchRateLimit.getHintInfo());
                req.setAttribute("TO_URL", (Object)matchRateLimit.getToUrl());
                throw new SeeyonRateLimitException();
            }
        }
    }

    public void destroy() {
    }
}

