/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.web.util;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceBundleUtil;
import com.seeyon.ctp.util.Strings;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;

public class WebUtil {
    private static final String EXCEPTION_ATTRIBUTE_KEY = "message_key";
    private static final String EXCEPTION_ATTRIBUTE_EXCEPTION = "message_exception";
    private static final String EXCEPTION_ATTRIBUTE_PARAMETER = "message_parameters";
    private static final String EXCEPTION_ATTRIBUTE_JAVASCRIPT = "message_javascript";
    private static final String EXCEPTION_ATTRIBUTE_ALERT_KEY = "message_alert_key";
    private static final String EXCEPTION_ATTRIBUTE_ALERT_PARAMETER = "message_alert_parameters";
    private static final String EXCEPTION_ATTRIBUTE_OBJECT = "message_object";
    private static ThreadLocal<HttpServletRequest> _request = new ThreadLocal();
    private static ThreadLocal<HttpServletResponse> _response = new ThreadLocal();

    public static void remove() {
        _request.remove();
        _response.remove();
    }

    public static void setRequest(HttpServletRequest request) {
        _request.set(request);
    }

    public static HttpServletRequest getRequest() {
        HttpServletRequest request = _request.get();
        return request;
    }

    public static void setResponse(HttpServletResponse response) {
        _response.set(response);
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = _response.get();
        return response;
    }

    public static void saveJavascript(String javascript) {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return;
        }
        HttpSession session = request.getSession();
        if (javascript != null && !"".equals(javascript.trim())) {
            AppContext.putSessionContext(EXCEPTION_ATTRIBUTE_JAVASCRIPT, javascript);
        }
    }

    public static void saveAlert(String key, Object ... paramters) {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return;
        }
        HttpSession session = request.getSession();
        if (key != null && !"".equals(key.trim())) {
            AppContext.putSessionContext(EXCEPTION_ATTRIBUTE_ALERT_KEY, key);
            AppContext.putSessionContext(EXCEPTION_ATTRIBUTE_ALERT_PARAMETER, paramters);
        }
    }

    public static String flash(PageContext pageContext) {
        String alert;
        String javascript;
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return null;
        }
        HttpSession session = request.getSession();
        StringBuilder sb = new StringBuilder();
        String message = (String)session.getAttribute("message");
        if (message != null) {
            sb.append("<div>" + message + "</div>");
            session.removeAttribute("message");
        }
        if ((javascript = (String)session.getAttribute(EXCEPTION_ATTRIBUTE_JAVASCRIPT)) != null) {
            sb.append("<script language=\"javascript\">" + javascript + "</script>");
            session.removeAttribute(EXCEPTION_ATTRIBUTE_JAVASCRIPT);
        }
        if ((alert = (String)session.getAttribute(EXCEPTION_ATTRIBUTE_ALERT_KEY)) != null) {
            Object[] params = (Object[])session.getAttribute(EXCEPTION_ATTRIBUTE_ALERT_PARAMETER);
            String msg = ResourceBundleUtil.getString(pageContext, alert, params);
            sb.append("<script language=\"javascript\">alert(\"" + Strings.escapeJavascript(msg) + "\");</script>");
            session.removeAttribute(EXCEPTION_ATTRIBUTE_ALERT_KEY);
            session.removeAttribute(EXCEPTION_ATTRIBUTE_ALERT_PARAMETER);
        }
        return sb.toString();
    }

    public static String flash(String resource, Locale locale) {
        String alert;
        String javascript;
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return null;
        }
        HttpSession session = request.getSession();
        StringBuilder sb = new StringBuilder();
        String message = (String)session.getAttribute("message");
        if (message != null) {
            sb.append("<div>" + message + "</div>");
            session.removeAttribute("message");
        }
        if ((javascript = (String)session.getAttribute(EXCEPTION_ATTRIBUTE_JAVASCRIPT)) != null) {
            sb.append("<script language=\"javascript\">" + javascript + "</script>");
            session.removeAttribute(EXCEPTION_ATTRIBUTE_JAVASCRIPT);
        }
        if ((alert = (String)session.getAttribute(EXCEPTION_ATTRIBUTE_ALERT_KEY)) != null) {
            Object[] params = (Object[])session.getAttribute(EXCEPTION_ATTRIBUTE_ALERT_PARAMETER);
            String msg = ResourceBundleUtil.getString(resource, locale, alert, params);
            sb.append("<script language=\"javascript\">alert(\"" + Strings.escapeJavascript(msg) + "\");</script>");
            session.removeAttribute(EXCEPTION_ATTRIBUTE_ALERT_KEY);
            session.removeAttribute(EXCEPTION_ATTRIBUTE_ALERT_PARAMETER);
        }
        return sb.toString();
    }

    public static void saveException(BusinessException e) {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return;
        }
        HttpSession session = request.getSession();
        AppContext.putSessionContext(EXCEPTION_ATTRIBUTE_EXCEPTION, e);
    }

    public static void saveMessage(String key, Object ... params) {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return;
        }
        HttpSession session = request.getSession();
        AppContext.putSessionContext(EXCEPTION_ATTRIBUTE_KEY, key);
        AppContext.putSessionContext(EXCEPTION_ATTRIBUTE_PARAMETER, params);
    }

    public static String getMessage(PageContext pageContext) {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return null;
        }
        HttpSession session = request.getSession();
        String key = (String)session.getAttribute(EXCEPTION_ATTRIBUTE_KEY);
        Object[] params = (Object[])session.getAttribute(EXCEPTION_ATTRIBUTE_PARAMETER);
        String msg = null;
        if (StringUtils.isNotBlank((CharSequence)key)) {
            msg = ResourceBundleUtil.getString(pageContext, key, params);
        }
        session.removeAttribute(EXCEPTION_ATTRIBUTE_KEY);
        session.removeAttribute(EXCEPTION_ATTRIBUTE_PARAMETER);
        return msg;
    }

    public static void saveObject(Object object) {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return;
        }
        HttpSession session = request.getSession();
        AppContext.putSessionContext(EXCEPTION_ATTRIBUTE_OBJECT, object);
    }

    public static Object getObject() {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return null;
        }
        HttpSession session = request.getSession();
        Object o = session.getAttribute(EXCEPTION_ATTRIBUTE_OBJECT);
        session.removeAttribute(EXCEPTION_ATTRIBUTE_OBJECT);
        return o;
    }

    public static String escape(String src) {
        StringBuilder tmp = new StringBuilder();
        tmp.ensureCapacity(src.length() * 6);
        for (int i = 0; i < src.length(); ++i) {
            char j = src.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public static String unescape(String src) {
        StringBuilder tmp = new StringBuilder();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }

    public static boolean checkEtag(HttpServletRequest request, HttpServletResponse response, String ETag) throws IOException {
        if (SystemEnvironment.isDistributedMode() && request == null) {
            return false;
        }
        if (request == null) {
            return false;
        }
        String previousToken = request.getHeader("If-None-Match");
        if (previousToken != null && previousToken.equals(ETag)) {
            response.setStatus(304);
            response.setHeader("ETag", ETag);
            return true;
        }
        return false;
    }

    public static void writeETag(HttpServletRequest request, HttpServletResponse response, String ETag) {
        WebUtil.writeETag(request, response, ETag, 0L);
    }

    public static String buildETag(long etag) {
        return String.valueOf((long)AppContext.getLocale().toString().hashCode() + etag);
    }

    public static void writeETag(HttpServletRequest request, HttpServletResponse response, String ETag, long cacheDate) {
        if (response == null) {
            return;
        }
        if (cacheDate > 0L) {
            response.setHeader("Expires", String.valueOf(System.currentTimeMillis() + cacheDate));
            response.setHeader("Cache-Control", "max-age=" + String.valueOf(cacheDate));
        } else if (Strings.isNotBlank(ETag)) {
            Calendar cal = Calendar.getInstance();
            cal.set(14, 0);
            Date lastModified = cal.getTime();
            if (SystemEnvironment.isDistributedMode() && request == null) {
                return;
            }
            response.setHeader("ETag", ETag);
            response.setDateHeader("Last-Modified", lastModified.getTime());
        }
    }
}

