/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.login;

import com.seeyon.ctp.cluster.ClusterConfigBean;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.i18n.ResourceBundleUtil;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.web.util.WebUtil;
import com.seeyon.ctp.login.DefaultOnlineStateMessage;
import com.seeyon.ctp.login.OnlineStateMessage;
import com.seeyon.ctp.login.online.OnlineManager;
import com.seeyon.ctp.login.online.OnlineRecorder;
import com.seeyon.ctp.login.online.OnlineUser;
import com.seeyon.ctp.util.Strings;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;

public class CurrentUserToSeeyonApp {
    private static final Log LOGGER = CtpLogFactory.getLog(CurrentUserToSeeyonApp.class);
    private static OnlineManager onLineManager = null;
    private static final Map<Constants.LoginOfflineOperation, String> LOGIN_STATE_CODE = new HashMap<Constants.LoginOfflineOperation, String>(){
        private static final long serialVersionUID = -2532804987054841416L;
        {
            this.put(Constants.LoginOfflineOperation.adminKickoff, "1003");
            this.put(Constants.LoginOfflineOperation.networkOff, "1004");
            this.put(Constants.LoginOfflineOperation.changePassword, "1005");
            this.put(Constants.LoginOfflineOperation.kickOff, "1006");
            this.put(Constants.LoginOfflineOperation.loginAnotherone, "1007");
            this.put(Constants.LoginOfflineOperation.unknown, "1010");
        }
    };
    private static Map<String, OnlineStateMessage> messages = new HashMap<String, OnlineStateMessage>();

    private static void initOnlineManager() {
        if (onLineManager == null) {
            onLineManager = (OnlineManager)AppContext.getBean("onlineManager");
        }
    }

    public static String getUserOnlineMessage() {
        return CurrentUserToSeeyonApp.getUserOnlineMessage(false);
    }

    static void initMessage(String code, String key) {
        messages.put(code, new DefaultOnlineStateMessage(code, key));
    }

    private static String getMessage(String code, boolean showCode, Object ... params) {
        OnlineStateMessage item = messages.get(code);
        if (item != null) {
            String header;
            User user = AppContext.getCurrentUser();
            if (user != null ? user.getUserAgentFromEnum().equals((Object)Constants.login_useragent_from.ucpc) : "ucpc".equals(header = AppContext.getRawRequest().getHeader("User-Agent-Client"))) {
                return item.toJSON(params);
            }
            String msg = item.getMessage(params);
            if (showCode) {
                msg = item.getCode() + ":" + msg;
            }
            return msg;
        }
        return null;
    }

    public static String getUserOnlineMessage(boolean showCode) {
        CurrentUserToSeeyonApp.initOnlineManager();
        User currentUser = AppContext.getCurrentUser();
        if (currentUser != null && currentUser.isGuest().booleanValue()) {
            return null;
        }
        Constants.LoginUserState state = null;
        if (currentUser == null) {
            state = Constants.LoginUserState.offline;
        } else {
            User.login_state_enum loginState = currentUser.getLoginState();
            if (loginState == User.login_state_enum.logging) {
                return null;
            }
            if (loginState == User.login_state_enum.exceed_max_member) {
                return CurrentUserToSeeyonApp.getMessage("1001", showCode, new Object[0]);
            }
            if (loginState == User.login_state_enum.exceed_max_member_in_account) {
                return CurrentUserToSeeyonApp.getMessage("1002", showCode, new Object[0]);
            }
            if (loginState == User.login_state_enum.ok) {
                state = onLineManager.getOnlineState(currentUser);
                if (Constants.login_useragent_from.email.name().equals(currentUser.getUserAgentFrom())) {
                    return null;
                }
            }
        }
        if (!Constants.LoginUserState.online.equals((Object)state) && !Constants.LoginUserState.leave.equals((Object)state)) {
            Constants.LoginOfflineOperation loginOfflineOperation = Constants.LoginOfflineOperation.unknown;
            if (currentUser != null) {
                loginOfflineOperation = onLineManager.getOfflineOperation(currentUser);
            }
            String message = null;
            if (Constants.LoginOfflineOperation.adminKickoff.equals((Object)loginOfflineOperation)) {
                message = CurrentUserToSeeyonApp.getMessage(LOGIN_STATE_CODE.get((Object)Constants.LoginOfflineOperation.adminKickoff), showCode, 0, "");
            } else if (Constants.LoginOfflineOperation.changePassword.equals((Object)loginOfflineOperation)) {
                String remoteAddr = "";
                message = CurrentUserToSeeyonApp.getMessage(LOGIN_STATE_CODE.get((Object)Constants.LoginOfflineOperation.changePassword), showCode, remoteAddr);
            } else if (Constants.LoginOfflineOperation.kickOff.equals((Object)loginOfflineOperation)) {
                String param = "";
                if (currentUser != null) {
                    String remoteAddr = CurrentUserToSeeyonApp.getRemoteAddr(currentUser);
                    param = !Strings.isEmpty(remoteAddr) ? "(" + remoteAddr + ")" : "!";
                }
                message = CurrentUserToSeeyonApp.getMessage(LOGIN_STATE_CODE.get((Object)Constants.LoginOfflineOperation.kickOff), showCode, param);
            } else if (!Constants.LoginOfflineOperation.loginAnotherone.equals((Object)loginOfflineOperation) || !AppContext.isRunningModeTest()) {
                String loginType = "";
                OnlineUser onlineUser = OnlineRecorder.getOnlineUser((User)currentUser);
                if (onlineUser != null) {
                    Date lastLoginTime = onlineUser.getLastLoginTime();
                    Map<Constants.login_sign, OnlineUser.LoginInfo> loginInfoMap = onlineUser.getLoginInfoMap();
                    for (OnlineUser.LoginInfo info : loginInfoMap.values()) {
                        if (!info.getLoginTime().equals(lastLoginTime)) continue;
                        loginType = info.getLoginType();
                        break;
                    }
                }
                String param = "";
                if (currentUser != null) {
                    String remoteAddr = CurrentUserToSeeyonApp.getRemoteAddr(currentUser);
                    String from = Strings.isEmpty(loginType) ? "" : ResourceUtil.getString("online.loginType." + loginType);
                    param = !Strings.isEmpty(remoteAddr) && !Constants.LoginOfflineOperation.unknown.equals((Object)loginOfflineOperation) ? "(" + from + " " + remoteAddr + ")" : "!";
                }
                message = CurrentUserToSeeyonApp.getMessage(LOGIN_STATE_CODE.get((Object)loginOfflineOperation), showCode, param);
            }
            if (message != null) {
                HttpServletRequest request = AppContext.getRawRequest();
                String uri = "";
                if (request != null) {
                    uri = request.getRequestURI();
                }
                String loginName = "";
                if (currentUser != null) {
                    loginName = currentUser.getLoginName();
                    HttpSession session = request.getSession(false);
                    String sessionId = "";
                    if (session != null) {
                        sessionId = session.getId();
                        sessionId = sessionId.substring(0, 2) + "XX" + sessionId.substring(sessionId.length() - 2);
                    }
                    LOGGER.warn((Object)(message + " uri:" + uri + " " + loginName + " " + (Object)((Object)state) + " " + sessionId));
                }
            }
            if (message != null && ClusterConfigBean.getInstance().isClusterEnabled()) {
                try {
                    String unknown = ResourceBundleUtil.getString("com.seeyon.v3x.main.resources.i18n.MainResources", "loginUserState.unknown", new Object[0]);
                    String networkoff = ResourceBundleUtil.getString("com.seeyon.v3x.main.resources.i18n.MainResources", "loginUserState.networkOff", new Object[0]);
                    if (unknown.equals(message) || networkoff.equals(message)) {
                        StringBuilder info = new StringBuilder();
                        info.append((Object)state).append(",");
                        info.append(Strings.getRemoteAddr(WebUtil.getRequest())).append(",");
                        if (currentUser != null) {
                            info.append(currentUser.getSessionId()).append(",");
                        } else {
                            info.append(",");
                        }
                        LOGGER.debug((Object)info.toString());
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return message;
        }
        return null;
    }

    private static String getRemoteAddr(User currentUser) {
        Map<Constants.login_sign, OnlineUser.LoginInfo> map;
        String remoteAddr = "";
        OnlineUser ou = OnlineRecorder.getOnlineUser((String)currentUser.getLoginName());
        if (ou != null && (map = ou.getLoginInfoMap()) != null) {
            for (OnlineUser.LoginInfo info : map.values()) {
                remoteAddr = info.getRemoteAddr();
                if (info.getLoginSign() != currentUser.getLoginSign()) continue;
            }
        }
        return remoteAddr;
    }

    static {
        CurrentUserToSeeyonApp.initMessage("1001", "login.label.ErrorCode.7");
        CurrentUserToSeeyonApp.initMessage("1002", "login.label.ErrorCode.30");
        CurrentUserToSeeyonApp.initMessage("1002", "login.label.ErrorCode.30");
        CurrentUserToSeeyonApp.initMessage(LOGIN_STATE_CODE.get((Object)Constants.LoginOfflineOperation.adminKickoff), "loginUserState.adminKickoff");
        CurrentUserToSeeyonApp.initMessage(LOGIN_STATE_CODE.get((Object)Constants.LoginOfflineOperation.changePassword), "loginUserState.changePassword");
        CurrentUserToSeeyonApp.initMessage(LOGIN_STATE_CODE.get((Object)Constants.LoginOfflineOperation.kickOff), "loginUserState.kickOff");
        CurrentUserToSeeyonApp.initMessage(LOGIN_STATE_CODE.get((Object)Constants.LoginOfflineOperation.loginAnotherone), "loginUserState.loginAnotherone");
        CurrentUserToSeeyonApp.initMessage(LOGIN_STATE_CODE.get((Object)Constants.LoginOfflineOperation.unknown), "loginUserState.unknown");
    }
}

