/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.login.online;

import com.seeyon.ctp.common.authenticate.domain.LoginUtil;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.Constants;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OnlineUser
implements Serializable {
    private static final long serialVersionUID = 2863954469707621561L;
    Constants.LoginUserState state = Constants.LoginUserState.online;
    Constants.LoginUserOnlineSubState onlineSubState = Constants.LoginUserOnlineSubState.normal;
    private int offlineCount = 0;
    private Long internalId;
    private String loginName;
    private Date lastLoginTime;
    private int loginSign;
    private Long departmentId;
    private String name;
    private String departmentSimpleName;
    private String departmentCanonicalName;
    private String departmentPath;
    private List<SecondePost> secondePosts = new ArrayList<SecondePost>();
    private String postName;
    private String levelName;
    private Long accoutId;
    private boolean isInternal = true;
    private Integer externalType = 0;
    private Map<Constants.login_sign, LoginInfo> loginInfoMap = new ConcurrentHashMap<Constants.login_sign, LoginInfo>();

    public OnlineUser() {
    }

    public OnlineUser(User user) {
        this.setLoginName(user.getLoginName());
        this.setInternalId(user.getId());
        this.setInternal(user.isInternal());
        this.setLastLoginTime(user.getLoginTimestamp());
        this.setName(user.getName());
        this.setAccoutId(user.getAccountId());
        this.setExternalType(user.getExternalType());
    }

    public Integer getExternalType() {
        return this.externalType;
    }

    public void setExternalType(Integer externalType) {
        this.externalType = externalType;
    }

    public String getDepartmentCanonicalName() {
        return this.departmentCanonicalName;
    }

    public void setDepartmentCanonicalName(String departmentCanonicalName) {
        this.departmentCanonicalName = departmentCanonicalName;
    }

    public Long getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentSimpleName() {
        return this.departmentSimpleName;
    }

    public void setDepartmentSimpleName(String departmentSimpleName) {
        this.departmentSimpleName = departmentSimpleName;
    }

    public Long getInternalId() {
        return this.internalId;
    }

    public void setInternalId(Long internalId) {
        this.internalId = internalId;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOfflineCount() {
        return this.offlineCount;
    }

    public void clearOfflineCount() {
        this.offlineCount = 0;
        this.state = Constants.LoginUserState.online;
    }

    public void clearOfflineCount(int loginSign) {
        this.clearOfflineCount();
        LoginInfo loginInfo = this.getLoginInfoByLoginSign(loginSign);
        if (loginInfo != null) {
            loginInfo.clearOfflineCount();
        }
    }

    public void updateOfflineCount(int ch) {
        this.offlineCount += ch;
    }

    public void updateOfflineCount(int loginSign, int ch) {
        this.offlineCount += ch;
        LoginInfo loginInfo = this.getLoginInfoByLoginSign(loginSign);
        if (loginInfo != null) {
            loginInfo.updateOfflineCount(ch);
        }
    }

    public String getPostName() {
        return this.postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    public String getDepartmentPath() {
        return this.departmentPath;
    }

    public void setDepartmentPath(String departmentPath) {
        this.departmentPath = departmentPath;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public Constants.LoginUserState getState() {
        return this.state;
    }

    public void setState(Constants.LoginUserState state) {
        this.state = state;
    }

    public Constants.LoginUserOnlineSubState getOnlineSubState() {
        return this.onlineSubState;
    }

    public void setOnlineSubState(Constants.LoginUserOnlineSubState onlineSubState) {
        this.onlineSubState = onlineSubState;
    }

    public Long getAccoutId() {
        return this.accoutId;
    }

    public void setAccoutId(Long accoutId) {
        this.accoutId = accoutId;
    }

    public Map<Constants.login_sign, LoginInfo> getLoginInfoMap() {
        return this.loginInfoMap;
    }

    public void setLoginInfoMap(Map<Constants.login_sign, LoginInfo> loginInfoMap) {
        this.loginInfoMap = loginInfoMap;
    }

    public void addLoginInfo(Constants.login_sign sign, LoginInfo info) {
        this.loginInfoMap.put(sign, info);
    }

    public void addLoginInfo(LoginInfo info) {
        this.loginInfoMap.put(Constants.login_sign.valueOf(info.getLoginSign()), info);
    }

    public List<SecondePost> getSecondePosts() {
        return this.secondePosts;
    }

    public int getLoginSign() {
        return this.loginSign;
    }

    public void setLoginSign(int loginSign) {
        this.loginSign = loginSign;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public Set<String> getSessionIds() {
        HashSet<String> sessionIds = new HashSet<String>();
        Collection<LoginInfo> infos = this.loginInfoMap.values();
        for (LoginInfo info : infos) {
            sessionIds.add(info.getSessionId());
        }
        return sessionIds;
    }

    public Set<Long> getLoginAccounts() {
        HashSet<Long> accountIds = new HashSet<Long>();
        Collection<LoginInfo> infos = this.loginInfoMap.values();
        for (LoginInfo info : infos) {
            accountIds.add(info.getCurrentAccountId());
        }
        return accountIds;
    }

    public Set<Date> getLoginTimes() {
        HashSet<Date> loginTimes = new HashSet<Date>();
        Collection<LoginInfo> infos = this.loginInfoMap.values();
        for (LoginInfo info : infos) {
            loginTimes.add(info.getLoginTime());
        }
        return loginTimes;
    }

    public LoginInfo getLoginInfoByLoginType(String loginType) {
        Map<Constants.login_sign, LoginInfo> infos = this.getLoginInfoMap();
        if (null == infos) {
            return null;
        }
        for (LoginInfo info : infos.values()) {
            if (!info.getLoginType().equals(loginType)) continue;
            return info;
        }
        return null;
    }

    public LoginInfo getLoginInfoByLoginSign(int loginSign) {
        Map<Constants.login_sign, LoginInfo> infos = this.getLoginInfoMap();
        if (null == infos) {
            return null;
        }
        for (LoginInfo info : infos.values()) {
            if (info.getLoginSign() != loginSign) continue;
            return info;
        }
        return null;
    }

    public Set<String> getLoginTypes() {
        HashSet<String> loginTypes = new HashSet<String>();
        Collection<LoginInfo> infos = this.loginInfoMap.values();
        for (LoginInfo info : infos) {
            loginTypes.add(info.getLoginType());
        }
        return loginTypes;
    }

    public void addSecondePost(Long departmentId, String departmentPath, String departmentSimpleName, String departmentCanonicalName, Long postId, String postName, Long accountId) {
        SecondePost o = new SecondePost(departmentId, departmentPath, departmentSimpleName, departmentCanonicalName, postId, postName, accountId);
        this.secondePosts.add(o);
    }

    public SecondePost getSecondePost(Long accountId, String departmentPath) {
        if (!this.secondePosts.isEmpty()) {
            for (SecondePost secondePost : this.secondePosts) {
                if (!secondePost.getAccountId().equals(accountId) || !"".equals(departmentPath) && !secondePost.getDepartmentPath().equals(departmentPath) && !secondePost.getDepartmentPath().startsWith(departmentPath + ".")) continue;
                return secondePost;
            }
        }
        return null;
    }

    public boolean isFromM1() {
        return LoginUtil.isFromM1(this);
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public void setInternal(boolean isInternal) {
        this.isInternal = isInternal;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OnlineUser [state=").append((Object)this.state).append(", onlineSubState=").append((Object)this.onlineSubState).append(", loginName=").append(this.loginName).append(", departmentId=").append(this.departmentId).append(", name=").append(this.name).append(", departmentSimpleName=").append(this.departmentSimpleName).append(", departmentCanonicalName=").append(this.departmentCanonicalName).append(", departmentPath=").append(this.departmentPath).append(", secondePosts=").append(this.secondePosts).append(", postName=").append(this.postName).append(", levelName=").append(this.levelName).append(", accoutId=").append(this.accoutId).append(", isInternal=").append("]");
        return builder.toString();
    }

    public class LoginInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String sessionId = null;
        private Date loginTime;
        private String loginType;
        private int loginSign;
        private Long loginLogId;
        private Long currentAccountId;
        private String remoteAddr;
        private String city;
        private Double x;
        private Double y;
        private String nodeIndex = "";
        private int offlineCount = 0;

        public String getNodeIndex() {
            return this.nodeIndex;
        }

        public void setNodeIndex(String nodeIndex) {
            this.nodeIndex = nodeIndex;
        }

        public LoginInfo() {
            Date date = new Date();
            this.loginTime = new Date(date.getTime());
        }

        public LoginInfo(User user) {
            this();
            this.setLoginLogId(user.getLoginLogId());
            this.setLoginSign(user.getLoginSign());
            this.setLoginTime(user.getLoginTimestamp());
            this.setLoginType(user.getUserAgentFrom());
            this.setSessionId(user.getSessionId());
            this.setCurrentAccountId(user.getLoginAccount());
            this.setRemoteAddr(user.getRemoteAddr());
            this.setNodeIndex(user.getNodeIndex());
        }

        public void updateOfflineCount(int ch) {
            this.offlineCount += ch;
        }

        public void clearOfflineCount() {
            this.offlineCount = 0;
        }

        public int getOfflineCount() {
            return this.offlineCount;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public Date getLoginTime() {
            return this.loginTime;
        }

        public void setLoginTime(Date loginTime) {
            this.loginTime = loginTime;
        }

        public String getLoginType() {
            return this.loginType;
        }

        public void setLoginType(String loginType) {
            this.loginType = loginType;
        }

        public int getLoginSign() {
            return this.loginSign;
        }

        public void setLoginSign(int loginSign) {
            this.loginSign = loginSign;
        }

        public Long getLoginLogId() {
            return this.loginLogId;
        }

        public void setLoginLogId(Long loginLogId) {
            this.loginLogId = loginLogId;
        }

        public Long getCurrentAccountId() {
            return this.currentAccountId;
        }

        public void setCurrentAccountId(Long currentAccountId) {
            this.currentAccountId = currentAccountId;
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public Double getX() {
            return this.x;
        }

        public void setX(Double x) {
            this.x = x;
        }

        public Double getY() {
            return this.y;
        }

        public void setY(Double y) {
            this.y = y;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LoginInfo [sessionId=").append(this.sessionId).append(", offlineCount=").append(this.offlineCount).append(", loginTime=").append(this.loginTime).append(", internalId=").append(OnlineUser.this.internalId).append(", loginType=").append(this.loginType).append(", loginSign=").append(this.loginSign).append(", city=").append(this.city).append(", x=").append(this.x).append(", y=").append(this.y).append(OnlineUser.this.isInternal).append(", loginLogId=").append(this.loginLogId).append(", currentAccountId=").append(this.currentAccountId).append("]");
            return builder.toString();
        }

        public String getRemoteAddr() {
            return this.remoteAddr;
        }

        public void setRemoteAddr(String remoteAddr) {
            this.remoteAddr = remoteAddr;
        }
    }

    public static class SecondePost
    implements Serializable {
        private static final long serialVersionUID = -3965317104334295912L;
        private Long accountId;
        private Long departmentId;
        private String departmentPath;
        private String departmentSimpleName;
        private String departmentCanonicalName;
        private Long postId;
        private String postName;

        public SecondePost(Long departmentId, String departmentPath, String departmentSimpleName, String departmentCanonicalName, Long postId, String postName, Long accountId) {
            this.departmentId = departmentId;
            this.departmentPath = departmentPath;
            this.departmentSimpleName = departmentSimpleName;
            this.departmentCanonicalName = departmentCanonicalName;
            this.postId = postId;
            this.postName = postName;
            this.accountId = accountId;
        }

        public Long getDepartmentId() {
            return this.departmentId;
        }

        public void setDepartmentId(Long departmentId) {
            this.departmentId = departmentId;
        }

        public String getDepartmentCanonicalName() {
            return this.departmentCanonicalName;
        }

        public void setDepartmentCanonicalName(String departmentCanonicalName) {
            this.departmentCanonicalName = departmentCanonicalName;
        }

        public String getDepartmentSimpleName() {
            return this.departmentSimpleName;
        }

        public void setDepartmentSimpleName(String departmentSimpleName) {
            this.departmentSimpleName = departmentSimpleName;
        }

        public String getDepartmentPath() {
            return this.departmentPath;
        }

        public void setDepartmentPath(String departmentPath) {
            this.departmentPath = departmentPath;
        }

        public Long getPostId() {
            return this.postId;
        }

        public void setPostId(Long postId) {
            this.postId = postId;
        }

        public String getPostName() {
            return this.postName;
        }

        public void setPostName(String postName) {
            this.postName = postName;
        }

        public Long getAccountId() {
            return this.accountId;
        }

        public void setAccountId(Long accountId) {
            this.accountId = accountId;
        }
    }
}

