/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.monitor.perfmon;

import com.seeyon.ctp.common.log.CapabilityLogger;
import com.seeyon.ctp.monitor.perfmon.PerfLogConfig;
import com.seeyon.ctp.monitor.perfmon.PerfmonMisc;
import com.seeyon.ctp.util.UUIDLong;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.aspectj.lang.ProceedingJoinPoint;

public class OperationLog {
    public Object perfmonLog(ProceedingJoinPoint pjp) throws Throwable {
        if (!PerfLogConfig.isRunning()) {
            return pjp.proceed();
        }
        long startTime = System.currentTimeMillis();
        Object retVal = pjp.proceed();
        startTime = System.currentTimeMillis() - startTime;
        if (startTime >= (long)PerfLogConfig.getSlowlaunchManagerTime()) {
            String uuid = PerfmonMisc.getUuid() == null ? String.valueOf(UUIDLong.longUUID()) : PerfmonMisc.getUuid();
            StringBuilder sb = new StringBuilder(PerfmonMisc.getAopProxy(pjp.getTarget()));
            sb.append(",").append(startTime).append(",").append(uuid);
            if (PerfLogConfig.isRecordManagerParam()) {
                sb.append(",").append(this.getParaValue(pjp.getArgs()));
            }
            CapabilityLogger.getInstance().debug(sb.toString());
        }
        return retVal;
    }

    private String getParaValue(Object[] objs) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : objs) {
            sb.append("{");
            try {
                Map map = BeanUtils.describe((Object)obj);
                for (Map.Entry entry : map.entrySet()) {
                    sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(";");
                }
                sb.append("};");
            }
            catch (IllegalAccessException e) {
                CapabilityLogger.getInstance().error(e.getLocalizedMessage(), e);
            }
            catch (InvocationTargetException e) {
                CapabilityLogger.getInstance().error(e.getLocalizedMessage(), e);
            }
            catch (NoSuchMethodException e) {
                CapabilityLogger.getInstance().error(e.getLocalizedMessage(), e);
            }
        }
        return sb.toString();
    }
}

