/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.startup;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.ProductEditionEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.startup.StartupTask;
import com.seeyon.ctp.util.IOUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.util.Strings;

public class StartupSQLTask
implements StartupTask {
    private static Log logger = CtpLogFactory.getLog(StartupSQLTask.class);
    private static final String DS_NAME = "java:comp/env/jdbc/ctpDataSource";
    private Connection connection = null;
    private String dbType = null;
    private boolean deleteFile = true;

    @Override
    public void run() throws BusinessException {
        try {
            String databaseName;
            this.connection = this.getConnection();
            this.dbType = databaseName = this.connection.getMetaData().getDatabaseProductName();
            if (databaseName.startsWith("Microsoft SQL Server")) {
                this.dbType = "Microsoft SQL Server";
            } else if (databaseName.toLowerCase().indexOf("sqlserver") > -1) {
                this.dbType = "Microsoft SQL Server";
            }
            logger.debug((Object)("startup:database type is " + this.dbType));
            this.deleteFile = false;
            this.runIt(AppContext.getCfgHome() + "/startup/sql/");
            this.deleteFile = true;
            this.runIt(AppContext.getCfgHome() + "/startup/sql/runonce/");
        }
        catch (Throwable e) {
            logger.error((Object)e.getLocalizedMessage(), e);
        }
        finally {
            this.closeConnection(this.connection);
        }
    }

    private void runIt(String baseDir) {
        this._run(baseDir);
        this._run(baseDir + ProductEditionEnum.getCurrentProductEditionEnum().getKey() + "/");
    }

    private void _run(String baseDir) {
        File directory = new File(baseDir);
        if (!directory.exists()) {
            logger.debug((Object)("startup:directory is not exist:" + directory.getAbsolutePath()));
            return;
        }
        String[] fileNameArray = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        if (fileNameArray.length == 0) {
            logger.debug((Object)("startup:directory is empty:" + directory.getAbsolutePath()));
            return;
        }
        try {
            ArrayList<String> defaultSqlFiles = new ArrayList<String>();
            ArrayList<String> sqlFiles = new ArrayList<String>();
            for (String name : fileNameArray) {
                if (name.startsWith("default_")) {
                    defaultSqlFiles.add(name);
                    continue;
                }
                if (name.startsWith(this.dbType)) {
                    sqlFiles.add(name);
                    continue;
                }
                this.deleteFile(baseDir + name);
            }
            for (String name : sqlFiles) {
                this.runonce(baseDir, name, this.connection);
            }
            for (String name : defaultSqlFiles) {
                this.runonce(baseDir, name, this.connection);
            }
        }
        catch (Throwable e) {
            logger.error((Object)e.getLocalizedMessage(), e);
        }
    }

    private boolean deleteFile(String fileName) {
        if (!this.deleteFile) {
            return false;
        }
        if (this.isUnittest()) {
            return false;
        }
        logger.debug((Object)("startup:delete file:" + fileName));
        return new File(fileName).delete();
    }

    private void runonce(String baseDir, String name, Connection connection) {
        try {
            String fileName = baseDir + name;
            this.executeSql(fileName, connection);
            this.deleteFile(fileName);
        }
        catch (Throwable e) {
            logger.error((Object)e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(String fileName, Connection connection) throws Exception {
        logger.debug((Object)("startup:execute sql in " + fileName));
        String str = this.readTextFile(fileName);
        if (Strings.isBlank((String)str)) {
            return;
        }
        String[] sqls = str.split("(;\\s*\\r\\n)|(;\\s*\\n)");
        if (sqls.length < 1) {
            return;
        }
        Statement stmt = connection.createStatement();
        try {
            if ("Oracle".equals(this.dbType)) {
                stmt.execute("ALTER SESSION SET NLS_DATE_FORMAT='YYYY-MM-DD HH24:MI:SS'");
                stmt.execute("ALTER SESSION SET NLS_TIMESTAMP_FORMAT='YYYY-MM-DD HH24:MI:SS.FF'");
            }
            for (String sql : sqls) {
                String s = sql.trim();
                if (s.isEmpty() || sql.startsWith("--")) continue;
                if (s.endsWith(";")) {
                    s = s.substring(0, s.length() - 1);
                }
                logger.debug((Object)("startup:execute:" + s));
                try {
                    stmt.execute(s);
                }
                catch (Exception e) {
                    logger.warn((Object)e.getLocalizedMessage());
                }
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readTextFile(String fileName) {
        String str = "";
        FileInputStream input = null;
        try {
            File file = new File(fileName);
            if (file.exists()) {
                input = new FileInputStream(file);
                str = IOUtility.toString((InputStream)input, "UTF-8");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(input);
        }
        return str;
    }

    private Connection getConnection() throws NamingException, SQLException {
        if (this.connection != null) {
            return this.connection;
        }
        InitialContext ctx = new InitialContext();
        String dsName = DS_NAME;
        if (this.isUnittest()) {
            dsName = "jdbc/ctpDataSource";
        }
        DataSource ds = (DataSource)ctx.lookup(dsName);
        this.connection = ds.getConnection();
        return this.connection;
    }

    private boolean isUnittest() {
        return "true".equals(System.getProperty("ctp.mode.test"));
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

