/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.thread;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.thread.StopThreadServerMsg;
import com.seeyon.ctp.thread.ThreadManager;
import com.seeyon.ctp.thread.ThreadRequest;
import com.seeyon.ctp.thread.ThreadServer;
import com.seeyon.ctp.thread.ThreadValue;
import com.seeyon.ctp.thread.monitor.ThreadMonitor;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;

public abstract class CTPThreadServer
extends ThreadServer {
    private static final Log LOGGER = CtpLogFactory.getLog(CTPThreadServer.class);
    public Semaphore sem = null;

    public CTPThreadServer(Integer count) {
        this.sem = new Semaphore(count, true);
    }

    @Override
    public void run() {
        LOGGER.info((Object)("\u542f\u52a8\u7ebf\u7a0b[MThread Server]:" + this.getPortName()));
        ThreadManager.getInstance().register(this.getPortName(), this.getPort());
        ThreadRequest request = null;
        while (this.continueFlag) {
            try {
                this.sem.acquire();
                request = this.getPort().getRequest();
                Object data = request.getData();
                if (data instanceof StopThreadServerMsg) {
                    this.continueFlag = false;
                    this.destroy();
                    ThreadManager.getInstance().remove(this.getPortName());
                    continue;
                }
                Worker worker = new Worker(data);
                new Thread(worker).start();
            }
            catch (Throwable ex) {
                this.sem.release();
                LOGGER.debug((Object)"\u8fdb\u7a0b\u95f4\u901a\u4fe1\u5b88\u62a4\u8fdb\u7a0b\u51fa\u73b0\u9519\u8bef\uff01", (Throwable)new Exception("\u8c03\u7528JAVA\u670d\u52a1\u65f6\u5f02\u5e38\u9519\u8bef:" + ex));
            }
        }
    }

    protected class Worker
    implements Runnable {
        Object request = null;

        protected Worker(Object request) {
            this.request = request;
        }

        @Override
        public void run() {
            try {
                ThreadValue.clear();
                CTPThreadServer.this.threadID = ThreadValue.getThreadId();
                CTPThreadServer.this.init(CTPThreadServer.this.getParameter());
            }
            catch (Throwable e) {
                try {
                    CTPThreadServer.this.sem.release();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                LOGGER.error((Object)"\u521d\u59cb\u5316\u7ebf\u7a0b\u53d8\u91cf\u65f6\u9519\u8bef", e);
                return;
            }
            try {
                CTPThreadServer.this.service(this.request);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    CTPThreadServer.this.sem.release();
                }
                catch (Throwable throwable) {}
            }
            ThreadMonitor.stopMonitor();
        }
    }
}

