/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.thread;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadInfoHolder {
    private static final ThreadInfoHolder instance = new ThreadInfoHolder();
    private Map<Long, CtpThreadInfo> ThreadInfos = new ConcurrentHashMap<Long, CtpThreadInfo>();

    public static ThreadInfoHolder getInstance() {
        return instance;
    }

    public void initThread(Thread t) {
        long id = t.getId();
        CtpThreadInfo ti = new CtpThreadInfo();
        ti.setThreadId(id);
        ti.setWorkBeginTime(System.currentTimeMillis());
        this.ThreadInfos.put(id, ti);
    }

    public void remove(Thread t) {
        this.ThreadInfos.remove(t.getId());
    }

    public void stopThread(Long threadId) {
        CtpThreadInfo ctpThreadInfo = this.ThreadInfos.get(threadId);
        if (ctpThreadInfo == null) {
            return;
        }
        Thread thread = ctpThreadInfo.getThread();
        Thread.State threadState = ctpThreadInfo.getThread().getState();
        if (threadState == Thread.State.BLOCKED || threadState == Thread.State.RUNNABLE) {
            thread.stop();
        }
    }

    public CtpThreadInfo get(Long threadId) {
        return this.ThreadInfos.get(threadId);
    }

    public static class CtpThreadInfo {
        private long threadId;
        private long workBeginTime;
        private Thread thread;

        public long getThreadId() {
            return this.threadId;
        }

        public void setThreadId(long threadId) {
            this.threadId = threadId;
        }

        public long getWorkBeginTime() {
            return this.workBeginTime;
        }

        public void setWorkBeginTime(long workBeginTime) {
            this.workBeginTime = workBeginTime;
        }

        public Thread getThread() {
            return this.thread;
        }

        public void setThread(Thread thread) {
            this.thread = thread;
        }
    }
}

