/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.thread.monitor;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.thread.ThreadUtil;
import com.seeyon.ctp.thread.ThreadValue;
import com.seeyon.ctp.thread.trace.RuntimeData;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;

public class ThreadMonitor {
    private static final Log LOGGER = CtpLogFactory.getLog(ThreadMonitor.class);
    private static ThreadMonitor instance = new ThreadMonitor();
    private Map<String, RuntimeData> threadPool = new ConcurrentHashMap<String, RuntimeData>(257);

    public static ThreadMonitor getInstance() {
        return instance;
    }

    private ThreadMonitor() {
    }

    public Map<String, RuntimeData> getThreadPool() {
        return this.threadPool;
    }

    public static RuntimeData startMonitor(String actionCode) {
        RuntimeData data = new RuntimeData(ThreadUtil.getTraceInfo(), actionCode);
        long startTime = System.currentTimeMillis();
        data.setBeginTime(startTime);
        ThreadMonitor.instance.threadPool.put(ThreadValue.getThreadId(), data);
        return data;
    }

    public static void stopMonitor() {
        RuntimeData data = ThreadMonitor.getData();
        if (data != null && data.isLogDuplicateSQL()) {
            ThreadMonitor.getData().getDaoRuntimeData().printTasklist();
        }
        data = null;
        try {
            String id = ThreadValue.getThreadId();
            data = ThreadMonitor.instance.threadPool.get(id);
            if (data != null) {
                data.release(ThreadUtil.getTraceInfo());
                ThreadMonitor.instance.threadPool.remove(id);
                data = null;
            }
        }
        catch (Throwable e) {
            LOGGER.error((Object)"\u5173\u95ed\u65e5\u5fd7\u9519\u8bef", e);
        }
    }

    public static RuntimeData getData() {
        String id = ThreadValue.getThreadId();
        return ThreadMonitor.getData(id);
    }

    public static RuntimeData getData(String threadID) {
        return ThreadMonitor.instance.threadPool.get(threadID);
    }

    public static RuntimeData[] getThreadList() {
        Map<String, RuntimeData> tp = ThreadMonitor.instance.threadPool;
        Set<Map.Entry<String, RuntimeData>> set = tp.entrySet();
        ArrayList<RuntimeData> t = new ArrayList<RuntimeData>();
        for (Map.Entry<String, RuntimeData> e : set) {
            t.add(e.getValue());
        }
        if (t.size() == 0) {
            return null;
        }
        RuntimeData[] list = new RuntimeData[t.size()];
        t.toArray(list);
        return list;
    }

    public static RuntimeData[] getEventThreadList() {
        Map<String, RuntimeData> tp = ThreadMonitor.instance.threadPool;
        Set<Map.Entry<String, RuntimeData>> set = tp.entrySet();
        ArrayList<RuntimeData> t = new ArrayList<RuntimeData>();
        for (Map.Entry<String, RuntimeData> e : set) {
            if (!e.getValue().isEventThread()) continue;
            t.add(e.getValue());
        }
        if (t.size() == 0) {
            return null;
        }
        RuntimeData[] list = new RuntimeData[t.size()];
        t.toArray(list);
        return list;
    }
}

