/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;

public class BeanCompareUtil {
    private static final Log logger = CtpLogFactory.getLog(BeanCompareUtil.class);

    public static CompareResult compare(Object src, Object target, String[] properties) {
        if (properties == null || properties.length == 0) {
            throw new IllegalArgumentException("\u5fc5\u987b\u6307\u5b9a\u8981\u6bd4\u8f83\u7684bean\u5c5e\u6027\u3002");
        }
        if (src == null || target == null) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301null\u6bd4\u8f83\u3002");
        }
        if (!src.getClass().equals(target.getClass())) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u4e0d\u540c\u7c7b\u578b\u7684\u5bf9\u8c61\u6bd4\u8f83\u3002");
        }
        CompareResult result = new CompareResult();
        for (String name : properties) {
            try {
                Object from = PropertyUtils.getProperty((Object)src, (String)name);
                Object to = PropertyUtils.getProperty((Object)target, (String)name);
                if (from == to || from != null && from.equals(to)) continue;
                result.append(new Change(name, from, to));
            }
            catch (Throwable e) {
                logger.error((Object)e.getLocalizedMessage(), e);
            }
        }
        return result;
    }

    public static boolean equals(Object src, Object target, String[] properties) {
        boolean isEquals = true;
        if (properties == null || properties.length == 0) {
            properties = new String[]{"id"};
        }
        if (src == null || target == null) {
            isEquals = false;
            throw new IllegalArgumentException("\u6bd4\u8f83\u5bf9\u8c61\u51fa\u73b0\u7a7a\uff1asrc=" + src + "\uff0ctarget=" + target);
        }
        for (String name : properties) {
            Object from = null;
            Object to = null;
            try {
                from = PropertyUtils.getProperty((Object)src, (String)name);
                to = PropertyUtils.getProperty((Object)target, (String)name);
            }
            catch (Throwable e) {
                logger.error((Object)e.getLocalizedMessage(), e);
            }
            if (from == to || from != null && from.equals(to)) continue;
            isEquals = false;
            throw new IllegalArgumentException("\u6bd4\u8f83\u5bf9\u8c61\u5c5e\u6027\u4e0d\u6210\u529f\uff1asrc." + name + "=" + from + "\uff0ctarget." + name + "=" + to);
        }
        return isEquals;
    }

    public static boolean equals(Object src, Object target) {
        return BeanCompareUtil.equals(src, target, null);
    }

    public static boolean equals(Collection<Object> src, Collection<Object> target) {
        boolean isEquals = true;
        if (src == null || target == null) {
            isEquals = false;
        }
        HashSet<Object> toList = new HashSet<Object>();
        for (Object object : target) {
            try {
                Object to = PropertyUtils.getProperty((Object)object, (String)"id");
                toList.add(to);
            }
            catch (Throwable e) {
                logger.error((Object)e.getLocalizedMessage(), e);
            }
        }
        for (Object object : src) {
            try {
                Object from = PropertyUtils.getProperty((Object)object, (String)"id");
                if (toList.contains(from)) continue;
                isEquals = false;
                break;
            }
            catch (Throwable e) {
                logger.error((Object)e.getLocalizedMessage(), e);
            }
        }
        return isEquals;
    }

    public static String toString(CompareResult result, TranslateRule rule) {
        return result.toString(rule);
    }

    static class DefaultTranslateRule
    extends AbstractTranslateRule {
        private static DefaultTranslateRule INSTANCE = new DefaultTranslateRule();

        DefaultTranslateRule() {
        }

        public static final DefaultTranslateRule getInstance() {
            return INSTANCE;
        }
    }

    public static abstract class AbstractTranslateRule
    implements TranslateRule {
        @Override
        public Map<String, String> getPropertyNames() {
            return new HashMap<String, String>();
        }

        @Override
        public Object translate(String property, Object value) {
            return value;
        }

        @Override
        public String getChangeFormat() {
            return "\u5c5e\u6027{0}\u7531[{1}]\u6539\u4e3a[{2}]";
        }
    }

    static interface TranslateRule {
        public Map<String, String> getPropertyNames();

        public Object translate(String var1, Object var2);

        public String getChangeFormat();
    }

    static class Change
    implements Serializable {
        private static final long serialVersionUID = 5744518619883010672L;
        private final String property;
        private final Object from;
        private final Object to;

        Change(String property, Object from, Object to) {
            this.property = property;
            this.from = from;
            this.to = to;
        }

        public String toString() {
            String format = "\u5c5e\u6027{0}\u7531[{1}]\u6539\u4e3a[{2}]";
            return this.toString(format);
        }

        public String toString(String format) {
            return MessageFormat.format(format, this.property, this.from, this.to);
        }

        public String toString(TranslateRule rule) {
            String propertyName = rule.getPropertyNames().get(this.property);
            propertyName = propertyName == null ? this.property : propertyName;
            String string = MessageFormat.format(rule.getChangeFormat(), propertyName, rule.translate(this.property, this.from), rule.translate(this.property, this.to));
            return string;
        }

        public Object getFrom() {
            return this.from;
        }

        public Object getTo() {
            return this.to;
        }
    }

    public static class CompareResult
    implements Serializable {
        private static final long serialVersionUID = -6573196427200999445L;
        private final List<Change> changes = new ArrayList<Change>();

        public String toString() {
            return this.toString(DefaultTranslateRule.getInstance());
        }

        public String toString(TranslateRule rule) {
            StringBuilder sb = new StringBuilder();
            for (Change change : this.changes) {
                sb.append(change.toString(rule)).append(" ");
            }
            return sb.toString();
        }

        public List<Change> getChanges() {
            return this.changes;
        }

        CompareResult append(Change change) {
            this.changes.add(change);
            return this;
        }

        public boolean hasChanged() {
            return this.changes.size() > 0;
        }
    }
}

