/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.FlipInfo;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.DetachedCriteriaConversion;
import org.hibernate.criterion.Projections;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.type.StringType;
import org.springframework.orm.hibernate3.CTPHibernateTemplate;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;
import org.springframework.orm.hibernate3.support.CTPHibernateDaoSupport;

public final class DBAgent {
    private static final Log logger = CtpLogFactory.getLog(DBAgent.class);
    private static final int RECORD_NUM_THRESHOLD = 500;
    public static final int batch_size = 1000;

    public static <T> T get(Class<T> entityClass, Serializable id) {
        return (T)DBAgent.currentHibernateDaoSupport().getHibernateTpl().get(entityClass, id);
    }

    public static List loadAll(Class entityClass) {
        return DBAgent.loadAll(entityClass, null);
    }

    public static List loadAll(Class entityClass, FlipInfo fi) {
        CTPHibernateTemplate ht = DBAgent.currentHibernateDaoSupport().getHibernateTpl();
        if (fi != null) {
            ht.setFlipInfo(fi);
        }
        List result = ht.loadAll(entityClass);
        if (fi != null) {
            fi.setData(result);
        }
        return result;
    }

    public static Object save(Object entity) {
        return DBAgent.currentHibernateDaoSupport().getHibernateTpl().save(entity);
    }

    public static List saveAll(List entities) {
        return DBAgent.saveAll(entities, false);
    }

    public static List saveAllForceFlush(List entities) {
        return DBAgent.saveAll(entities, true);
    }

    private static List saveAll(final List entities, final boolean forceFlush) {
        final ArrayList results = new ArrayList();
        DBAgent.currentHibernateDaoSupport().getHibernateTpl().executeWithNativeSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                int i = 0;
                try {
                    for (Object object : entities) {
                        results.add(session.save(object));
                        if (++i % 1000 != 0) continue;
                        session.flush();
                        session.clear();
                    }
                    if (forceFlush && entities.size() % 1000 != 0) {
                        session.flush();
                        session.clear();
                    }
                }
                catch (HibernateException he) {
                    logger.error((Object)"\u6279\u91cf\u63d2\u5165\u5f02\u5e38", (Throwable)he);
                    throw he;
                }
                catch (Exception e) {
                    logger.error((Object)"\u6279\u91cf\u63d2\u5165\u5f02\u5e38", (Throwable)e);
                }
                return null;
            }
        });
        return results;
    }

    private static List saveAllOld(List entities, boolean forceFlush) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < entities.size(); ++i) {
            results.add(DBAgent.save(entities.get(i)));
            if ((i + 1) % 1000 != 0) continue;
            DBAgent.currentHibernateDaoSupport().getHibernateTpl().flush();
            DBAgent.currentHibernateDaoSupport().getHibernateTpl().clear();
        }
        if (forceFlush && entities.size() % 1000 != 0) {
            DBAgent.currentHibernateDaoSupport().getHibernateTpl().flush();
            DBAgent.currentHibernateDaoSupport().getHibernateTpl().clear();
        }
        return results;
    }

    public static void savePatchAll(List entities) {
        DBAgent.savePatchAll(entities, false);
    }

    public static void savePatchAll(final List entities, final boolean forceFlush) {
        DBAgent.currentHibernateDaoSupport().getHibernateTpl().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                int i = 0;
                try {
                    for (Object object : entities) {
                        session.save(object);
                        if (++i % 1000 != 0) continue;
                        session.flush();
                        session.clear();
                    }
                    if (forceFlush && entities.size() % 1000 != 0) {
                        session.flush();
                        session.clear();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"\u6279\u91cf\u63d2\u5165\u5f02\u5e38", (Throwable)e);
                }
                return null;
            }
        });
    }

    public static void update(Object entity) {
        CTPHibernateTemplate tpl = DBAgent.currentHibernateDaoSupport().getHibernateTpl();
        tpl.update(entity);
    }

    public static void merge(Object entity) {
        CTPHibernateTemplate tpl = DBAgent.currentHibernateDaoSupport().getHibernateTpl();
        tpl.merge(entity);
    }

    public static void updateNoMerge(Object entity) {
        CTPHibernateTemplate tpl = DBAgent.currentHibernateDaoSupport().getHibernateTpl();
        tpl.update(entity);
    }

    public static void updateAll(final List entities) {
        DBAgent.currentHibernateDaoSupport().getHibernateTpl().executeWithNativeSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                int i = 0;
                try {
                    for (Object object : entities) {
                        session.update(object);
                        if (++i % 1000 != 0) continue;
                        session.flush();
                        session.clear();
                    }
                    if (entities.size() % 1000 != 0) {
                        session.flush();
                        session.clear();
                    }
                }
                catch (HibernateException he) {
                    logger.error((Object)"\u6279\u91cf\u4fee\u6539\u5f02\u5e38", (Throwable)he);
                    throw he;
                }
                catch (Exception e) {
                    logger.error((Object)"\u6279\u91cf\u4fee\u6539\u5f02\u5e38", (Throwable)e);
                }
                return null;
            }
        });
    }

    private static void updateAllOld(List entities) {
        for (int i = 0; i < entities.size(); ++i) {
            DBAgent.update(entities.get(i));
            if ((i + 1) % 1000 != 0) continue;
            DBAgent.currentHibernateDaoSupport().getHibernateTpl().flush();
            DBAgent.currentHibernateDaoSupport().getHibernateTpl().clear();
        }
        if (entities.size() % 1000 != 0) {
            DBAgent.currentHibernateDaoSupport().getHibernateTpl().flush();
            DBAgent.currentHibernateDaoSupport().getHibernateTpl().clear();
        }
    }

    public static void mergeAll(final List entities) {
        DBAgent.currentHibernateDaoSupport().getHibernateTpl().executeWithNativeSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                int i = 0;
                try {
                    for (Object object : entities) {
                        session.merge(object);
                        if (++i % 1000 != 0) continue;
                        session.flush();
                        session.clear();
                    }
                    if (entities.size() % 1000 != 0) {
                        session.flush();
                        session.clear();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"\u6279\u91cf\u4fee\u6539\u5f02\u5e38", (Throwable)e);
                }
                return null;
            }
        });
    }

    private static void mergeAllOld(List entities) {
        for (int i = 0; i < entities.size(); ++i) {
            DBAgent.merge(entities.get(i));
            if ((i + 1) % 1000 != 0) continue;
            DBAgent.currentHibernateDaoSupport().getHibernateTpl().flush();
            DBAgent.currentHibernateDaoSupport().getHibernateTpl().clear();
        }
        if (entities.size() % 1000 != 0) {
            DBAgent.currentHibernateDaoSupport().getHibernateTpl().flush();
            DBAgent.currentHibernateDaoSupport().getHibernateTpl().clear();
        }
    }

    public static void delete(Object entity) {
        DBAgent.currentHibernateDaoSupport().getHibernateTpl().delete(entity);
    }

    public static void deleteAll(List entities) {
        DBAgent.currentHibernateDaoSupport().getHibernateTpl().deleteAll(entities);
    }

    @Deprecated
    public static void saveOrUpdate(Object entity) {
        DBAgent.currentHibernateDaoSupport().getHibernateTpl().saveOrUpdate(entity);
    }

    public static void evict(Object entity) {
        DBAgent.currentHibernateDaoSupport().getHibernateTpl().evict(entity);
    }

    public static List findByCriteria(DetachedCriteria criteria) {
        return DBAgent.currentHibernateDaoSupport().getHibernateTpl().findByCriteria(criteria);
    }

    public static List findByCriteria(DetachedCriteria criteria, FlipInfo fi) {
        CTPHibernateTemplate ht = DBAgent.currentHibernateDaoSupport().getHibernateTpl();
        ht.setFlipInfo(fi);
        List l = ht.findByCriteria(criteria);
        fi.setData(l);
        return l;
    }

    public static List find(String queryString) {
        return DBAgent.find(queryString, null);
    }

    public static List find(String queryString, Map params) {
        return DBAgent.find(queryString, params, null);
    }

    public static List find(String queryString, Map params, FlipInfo fi) {
        return DBAgent.findBy(queryString, params, fi, false);
    }

    public static List findByValueBean(String queryString, Object valueBean) {
        return DBAgent.findBy(queryString, valueBean, null, false);
    }

    public static List findByValueBean(String queryString, Object valueBean, FlipInfo fi) {
        return DBAgent.findBy(queryString, valueBean, fi, false);
    }

    public static List findByNamedQuery(String queryName) {
        return DBAgent.findByNamedQuery(queryName, null);
    }

    public static List findByNamedQuery(String queryString, Map params) {
        return DBAgent.findByNamedQuery(queryString, params, null);
    }

    public static List findByNamedQuery(String queryString, Map params, FlipInfo fi) {
        return DBAgent.findBy(queryString, params, fi, true);
    }

    public static List findByNamedQueryAndValueBean(String queryName, Object valueBean) {
        return DBAgent.findBy(queryName, valueBean, null, true);
    }

    public static List findByNamedQueryAndValueBean(String queryName, Object valueBean, FlipInfo fi) {
        return DBAgent.findBy(queryName, valueBean, fi, true);
    }

    public static int bulkUpdate(String hql, Object ... values) {
        CTPHibernateTemplate ht = DBAgent.currentHibernateDaoSupport().getHibernateTpl();
        return ht.bulkUpdate(hql, values);
    }

    public static int bulkUpdate(String hql, Map<String, Object> nameParameters) {
        CTPHibernateTemplate ht = DBAgent.currentHibernateDaoSupport().getHibernateTpl();
        return ht.bulkUpdate(hql, nameParameters);
    }

    public static boolean exists(String hql) {
        return DBAgent.exists(hql, null);
    }

    public static boolean exists(String hql, Map params) {
        FlipInfo fi = new FlipInfo(1, 1);
        fi.setNeedTotal(false);
        List result = DBAgent.find(hql, params, fi);
        return result != null && result.size() != 0;
    }

    public static int count(String hql) {
        return DBAgent.count(hql, null);
    }

    public static int count(final DetachedCriteria detachedCriteria) {
        Integer count = (Integer)DBAgent.currentHibernateDaoSupport().getHibernateTpl().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                DetachedCriteriaConversion.conversion(detachedCriteria);
                Criteria criteria = detachedCriteria.getExecutableCriteria(session);
                criteria.setProjection(Projections.rowCount());
                criteria.setFirstResult(0);
                criteria.setMaxResults(1);
                List totalCount = criteria.list();
                return totalCount == null || totalCount.isEmpty() ? Integer.valueOf(0) : totalCount.get(0);
            }
        });
        return count;
    }

    public static int count(String hql, Map params) {
        String countHql = CTPHibernateTemplate.countSQL(hql);
        List objects = DBAgent.find(countHql, params);
        return objects == null || objects.isEmpty() ? 0 : ((Number)objects.get(0)).intValue();
    }

    public static List memoryPaging(List dataList, FlipInfo fi) {
        int end;
        int start;
        int size = fi.getSize();
        int page = fi.getPage();
        List datas = dataList;
        fi.setTotal(datas.size());
        ArrayList resultList = new ArrayList();
        if (start > datas.size()) {
            fi.setData(resultList);
            return fi.getData();
        }
        int n = end = start + size > fi.getTotal() ? fi.getTotal() : start + size;
        for (start = fi.getStartAt().intValue(); start < end; ++start) {
            resultList.add(datas.get(start));
        }
        fi.setData(resultList);
        return fi.getData();
    }

    static CTPHibernateDaoSupport currentHibernateDaoSupport() {
        CTPHibernateDaoSupport dao = (CTPHibernateDaoSupport)((Object)AppContext.getThreadContext("SPRING_HIBERNATE_DAO_SUPPORT"));
        if (dao == null) {
            dao = (CTPHibernateDaoSupport)((Object)AppContext.getBean("hibernateDaoSupport"));
        }
        return dao;
    }

    private static List findBy(String query, Object params, FlipInfo fi, boolean namedQuery) {
        CTPHibernateTemplate ht = DBAgent.currentHibernateDaoSupport().getHibernateTpl();
        if (fi != null) {
            ht.setFlipInfo(fi);
        }
        List result = new ArrayList();
        result = params == null || params instanceof Map ? (namedQuery ? ht.findByNamedQueryAndNamedParam(query, (Map)params) : ht.findByNamedParam(query, (Map)params)) : (namedQuery ? ht.findByNamedQueryAndValueBean(query, params) : ht.findByValueBean(query, params));
        if (fi != null) {
            fi.setData(result);
        }
        if (result != null && result.size() > 500) {
            StringBuilder warnStrBuilder = new StringBuilder();
            warnStrBuilder.append("\u67e5\u8be2\u8bb0\u5f55\u6570\u5927\u4e8e\u9600\u503c\uff08");
            warnStrBuilder.append(500);
            warnStrBuilder.append(") \u5f53\u524d\u8bb0\u5f55\u6570 ");
            warnStrBuilder.append(result.size());
            logger.debug((Object)warnStrBuilder.toString());
        }
        return result;
    }

    public static List<String> validateByHibernateModel(Object obj) {
        LocalSessionFactoryBean sf = (LocalSessionFactoryBean)AppContext.getBean("&sessionFactory");
        PersistentClass clazz = sf.getConfiguration().getClassMapping(obj.getClass().getName());
        ArrayList<String> errors = new ArrayList<String>();
        Table table = clazz.getTable();
        Iterator iterator = table.getColumnIterator();
        while (iterator.hasNext()) {
            Object val;
            Column column = (Column)iterator.next();
            String name = column.getName();
            Iterator p = clazz.getPropertyClosureIterator();
            Property property = null;
            while (p.hasNext()) {
                Property prop = (Property)p.next();
                Iterator columns2 = prop.getColumnIterator();
                while (columns2.hasNext()) {
                    Column column2 = (Column)columns2.next();
                    if (!column2.getName().equals(column.getName())) continue;
                    property = prop;
                    break;
                }
                if (property == null) continue;
                break;
            }
            if (property == null || (val = property.getGetter(obj.getClass()).get(obj)) == null) continue;
            String value = val.toString();
            if (!(property.getType() instanceof StringType) || value.length() <= column.getLength()) continue;
            errors.add(ResourceUtil.getString("validate.exceedMaxLength", name, column.getLength()));
        }
        return errors;
    }

    public static void commit() {
        CTPHibernateTemplate tpl = DBAgent.currentHibernateDaoSupport().getHibernateTpl();
        tpl.flush();
        tpl.clear();
    }

    public static void clear() {
        CTPHibernateTemplate tpl = DBAgent.currentHibernateDaoSupport().getHibernateTpl();
        tpl.clear();
    }
}

