/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.util.Datetimes;
import java.beans.PropertyEditorSupport;
import java.util.Date;
import org.springframework.util.StringUtils;

public class DateBinder
extends PropertyEditorSupport {
    private final boolean allowEmpty;
    private final int exactDateLength;

    public DateBinder(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
        this.exactDateLength = -1;
    }

    public DateBinder(boolean allowEmpty, int exactDateLength) {
        this.allowEmpty = allowEmpty;
        this.exactDateLength = exactDateLength;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (!this.allowEmpty || StringUtils.hasText((String)text)) {
            if (text != null && this.exactDateLength >= 0 && text.length() != this.exactDateLength) {
                throw new IllegalArgumentException("Could not parse date: it is not exactly" + this.exactDateLength + "characters long");
            }
            try {
                this.setValue(Datetimes.parse(text));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Could not parse date: " + ex.getMessage());
            }
        }
    }

    @Override
    public String getAsText() {
        Date value = (Date)this.getValue();
        return value != null ? Datetimes.formatDatetime(value) : "";
    }
}

