/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheObject;
import com.seeyon.ctp.common.cache.ThreadCacheFactory;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.TimeZoneUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class DateUtil {
    private static final Log logger = CtpLogFactory.getLog(DateUtil.class);
    public static final String YEAR_MONTH_DAY_HOUR_MINUTE_SECOND_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String YEAR_MONTH_DAY_HOUR_MINUTE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String YEAR_MONTH_DAY_PATTERN = "yyyy-MM-dd";
    public static final String HOUR_MINUTE_SECOND_PATTERN = "HH:mm:ss";
    public static final String YMDHMS_PATTERN = "yyyy-MM-dd HH:mm";
    private static final String FORMAT_STR = "0000-00-00 00:00";
    private static final String FORMAT_STANDARD_19 = "yyyy-MM-dd HH:mm:ss";
    private static ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    public static Date newDate() {
        CacheObject<Integer> dateOffset;
        CacheAccessable instance = ThreadCacheFactory.getInstance(DateUtil.class);
        int offset = 0;
        String cacheName = "dateOffset";
        if (instance.isExist(cacheName)) {
            dateOffset = instance.getObject(cacheName);
            offset = (Integer)dateOffset.get();
        } else {
            dateOffset = instance.createObject(cacheName);
        }
        dateOffset.set(++offset);
        return new Date(System.currentTimeMillis() + (long)offset);
    }

    public static Date currentDate() {
        return new Date();
    }

    public static String currentDateString(String pattern) {
        return Datetimes.formatNoTimeZone(DateUtil.currentDate(), pattern);
    }

    public static String currentDateDefaultString() {
        return DateUtil.format(DateUtil.currentDate(), YEAR_MONTH_DAY_PATTERN);
    }

    public static int getYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1);
    }

    public static int getMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2) + 1;
    }

    public static int getDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static int getHour(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(10);
    }

    public static int getMinute(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(12);
    }

    public static int getSecond(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(13);
    }

    public static int getWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int week = c.get(7);
        if (week == 1) {
            return 7;
        }
        return week - 1;
    }

    public static Integer getYearMonth(Date date) {
        return new Integer(DateUtil.format(date, "yyyyMM"));
    }

    public static Date parseYearMonth(Integer yearMonth) throws ParseException {
        return DateUtil.parse(String.valueOf(yearMonth), "yyyyMM");
    }

    public static Date addYear(Date date, int ammount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, ammount);
        return c.getTime();
    }

    public static Date addMonth(Date date, int ammount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, ammount);
        return c.getTime();
    }

    public static Date addDay(Date date, int ammount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, ammount);
        return c.getTime();
    }

    public static Integer addMonth(Integer yearMonth, int ammount) throws ParseException {
        return DateUtil.getYearMonth(DateUtil.addMonth(DateUtil.parseYearMonth(yearMonth), ammount));
    }

    public static int beforeYears(Date beforeDate, Date afterDate) {
        Calendar beforeCalendar = Calendar.getInstance();
        beforeCalendar.setTime(beforeDate);
        beforeCalendar.set(2, 1);
        beforeCalendar.set(5, 1);
        beforeCalendar.set(10, 0);
        beforeCalendar.set(13, 0);
        beforeCalendar.set(12, 0);
        Calendar afterCalendar = Calendar.getInstance();
        afterCalendar.setTime(afterDate);
        afterCalendar.set(2, 1);
        afterCalendar.set(5, 1);
        afterCalendar.set(10, 0);
        afterCalendar.set(13, 0);
        afterCalendar.set(12, 0);
        boolean positive = true;
        if (beforeDate.after(afterDate)) {
            positive = false;
        }
        int beforeYears = 0;
        while (true) {
            boolean yearEqual;
            boolean bl = yearEqual = beforeCalendar.get(1) == afterCalendar.get(1);
            if (yearEqual) break;
            if (positive) {
                ++beforeYears;
                beforeCalendar.add(1, 1);
                continue;
            }
            --beforeYears;
            beforeCalendar.add(1, -1);
        }
        return beforeYears;
    }

    public static int beforeMonths(Date beforeDate, Date afterDate) {
        Calendar beforeCalendar = Calendar.getInstance();
        beforeCalendar.setTime(beforeDate);
        beforeCalendar.set(5, 1);
        beforeCalendar.set(10, 0);
        beforeCalendar.set(13, 0);
        beforeCalendar.set(12, 0);
        Calendar afterCalendar = Calendar.getInstance();
        afterCalendar.setTime(afterDate);
        afterCalendar.set(5, 1);
        afterCalendar.set(10, 0);
        afterCalendar.set(13, 0);
        afterCalendar.set(12, 0);
        boolean positive = true;
        if (beforeDate.after(afterDate)) {
            positive = false;
        }
        int beforeMonths = 0;
        while (true) {
            boolean monthEqual;
            boolean yearEqual = beforeCalendar.get(1) == afterCalendar.get(1);
            boolean bl = monthEqual = beforeCalendar.get(2) == afterCalendar.get(2);
            if (yearEqual && monthEqual) break;
            if (positive) {
                ++beforeMonths;
                beforeCalendar.add(2, 1);
                continue;
            }
            --beforeMonths;
            beforeCalendar.add(2, -1);
        }
        return beforeMonths;
    }

    public static int beforeDays(Date beforeDate, Date afterDate) {
        Calendar beforeCalendar = Calendar.getInstance();
        beforeCalendar.setTime(beforeDate);
        beforeCalendar.set(10, 0);
        beforeCalendar.set(13, 0);
        beforeCalendar.set(12, 0);
        Calendar afterCalendar = Calendar.getInstance();
        afterCalendar.setTime(afterDate);
        afterCalendar.set(10, 0);
        afterCalendar.set(13, 0);
        afterCalendar.set(12, 0);
        boolean positive = true;
        if (beforeDate.after(afterDate)) {
            positive = false;
        }
        int beforeDays = 0;
        while (true) {
            boolean dayEqual;
            boolean yearEqual = beforeCalendar.get(1) == afterCalendar.get(1);
            boolean monthEqual = beforeCalendar.get(2) == afterCalendar.get(2);
            boolean bl = dayEqual = beforeCalendar.get(5) == afterCalendar.get(5);
            if (yearEqual && monthEqual && dayEqual) break;
            if (positive) {
                ++beforeDays;
                beforeCalendar.add(5, 1);
                continue;
            }
            --beforeDays;
            beforeCalendar.add(5, -1);
        }
        return beforeDays;
    }

    public static int beforeRoundYears(Date beforeDate, Date afterDate) {
        Date bDate = beforeDate;
        Date aDate = afterDate;
        boolean positive = true;
        if (beforeDate.after(afterDate)) {
            positive = false;
            bDate = afterDate;
            aDate = beforeDate;
        }
        int beforeYears = DateUtil.beforeYears(bDate, aDate);
        int bMonth = DateUtil.getMonth(bDate);
        int aMonth = DateUtil.getMonth(aDate);
        if (aMonth < bMonth) {
            --beforeYears;
        } else if (aMonth == bMonth) {
            int bDay = DateUtil.getDay(bDate);
            int aDay = DateUtil.getDay(aDate);
            if (aDay < bDay) {
                --beforeYears;
            }
        }
        if (positive) {
            return beforeYears;
        }
        return new BigDecimal(beforeYears).negate().intValue();
    }

    public static int beforeRoundAges(Date beforeDate, Date afterDate) {
        Date bDate = beforeDate;
        Date aDate = afterDate;
        boolean positive = true;
        if (beforeDate.after(afterDate)) {
            positive = false;
            bDate = afterDate;
            aDate = beforeDate;
        }
        int beforeYears = DateUtil.beforeYears(bDate, aDate);
        int bMonth = DateUtil.getMonth(bDate);
        int aMonth = DateUtil.getMonth(aDate);
        if (aMonth < bMonth) {
            --beforeYears;
        }
        if (positive) {
            return beforeYears;
        }
        return new BigDecimal(beforeYears).negate().intValue();
    }

    public static int beforeRoundMonths(Date beforeDate, Date afterDate) {
        Date bDate = beforeDate;
        Date aDate = afterDate;
        boolean positive = true;
        if (beforeDate.after(afterDate)) {
            positive = false;
            bDate = afterDate;
            aDate = beforeDate;
        }
        int beforeMonths = DateUtil.beforeMonths(bDate, aDate);
        int bDay = DateUtil.getDay(bDate);
        int aDay = DateUtil.getDay(aDate);
        if (aDay < bDay) {
            --beforeMonths;
        }
        if (positive) {
            return beforeMonths;
        }
        return new BigDecimal(beforeMonths).negate().intValue();
    }

    public static Date getDate(int year, int month, int date) {
        Calendar c = Calendar.getInstance();
        c.set(year + 1900, month, date);
        return c.getTime();
    }

    public static String format(Date date, String pattern) {
        return Datetimes.format(date, pattern);
    }

    public static String format(Date date) {
        return DateUtil.format(date, YEAR_MONTH_DAY_PATTERN);
    }

    public static String formatDateTime(Date date) {
        return DateUtil.format(date, "yyyy-MM-dd HH:mm");
    }

    public static Date parse(String dateStr, String pattern) throws ParseException {
        return Datetimes.parse(dateStr, pattern);
    }

    public static Date parse(String dateStr) throws ParseException {
        return Datetimes.parse(dateStr);
    }

    public static boolean isYearMonth(Integer yearMonth) {
        String yearMonthStr = yearMonth.toString();
        return DateUtil.isYearMonth(yearMonthStr);
    }

    public static boolean isYearMonth(String yearMonthStr) {
        if (yearMonthStr.length() != 6) {
            return false;
        }
        String yearStr = yearMonthStr.substring(0, 4);
        String monthStr = yearMonthStr.substring(4, 6);
        try {
            int year = Integer.parseInt(yearStr);
            int month = Integer.parseInt(monthStr);
            if (year < 1800 || year > 3000) {
                return false;
            }
            return month >= 1 && month <= 12;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List getYearMonths(Integer from, Integer to) throws ParseException {
        Date toDate;
        ArrayList<Integer> yearMonths = new ArrayList<Integer>();
        Date fromDate = DateUtil.parseYearMonth(from);
        if (fromDate.after(toDate = DateUtil.parseYearMonth(to))) {
            throw new IllegalArgumentException("'from' date should before 'to' date!");
        }
        Date tempDate = fromDate;
        while (tempDate.before(toDate)) {
            yearMonths.add(DateUtil.getYearMonth(tempDate));
            tempDate = DateUtil.addMonth(tempDate, 1);
        }
        if (!from.equals(to)) {
            yearMonths.add(to);
        }
        return yearMonths;
    }

    public static Timestamp parseTimestamp(String dateStr, String pattern) throws ParseException {
        return new Timestamp(DateUtil.parse(dateStr, pattern).getTime());
    }

    public static Timestamp parseTimestamp(String dateStr) throws ParseException {
        return new Timestamp(DateUtil.parse(dateStr).getTime());
    }

    public static Timestamp currentTimestamp() {
        return new Timestamp(DateUtil.currentDate().getTime());
    }

    public static String getStandard19DateAndTime(Date date) {
        String result = "";
        if (date != null) {
            result = threadLocal.get().format(date);
        }
        return result;
    }

    public static Date getByStandard19DateAndTime(String dateStr) {
        try {
            return threadLocal.get().parse(dateStr);
        }
        catch (ParseException e) {
            logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }

    public static String getDate() {
        String date = "";
        DateFormat df = DateFormat.getDateInstance();
        try {
            date = df.format(new Date());
        }
        catch (Exception e) {
            logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
        }
        return date;
    }

    public static String getDate(String format) {
        String date = "";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            date = sdf.format(new Date());
        }
        catch (Exception e) {
            logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
        }
        return date;
    }

    public static String getDate(Date date, String format) {
        String rs = "";
        if (date != null) {
            SimpleDateFormat f = new SimpleDateFormat(format);
            try {
                rs = f.format(date);
            }
            catch (Exception e) {
                rs = FORMAT_STR;
            }
        }
        return rs;
    }

    public static String getDate(Date d) {
        String date = "";
        if (d != null) {
            DateFormat df = DateFormat.getDateInstance();
            try {
                date = df.format(d);
            }
            catch (Exception e) {
                logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return date;
    }

    public static String getLocalDate(Date d) {
        String date = "";
        if (d != null) {
            Locale l = new Locale("zh", "CN");
            DateFormat df = DateFormat.getDateInstance(0, l);
            try {
                date = df.format(d);
            }
            catch (Exception e) {
                logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return date;
    }

    public static String getLocalDate() {
        String date = "";
        Locale l = new Locale("zh", "CN");
        DateFormat df = DateFormat.getDateInstance(0, l);
        try {
            date = df.format(new Date());
        }
        catch (Exception e) {
            logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
        }
        return date;
    }

    public static String getLocalTime() {
        Locale l = new Locale("zh", "CN");
        DateFormat df = DateFormat.getTimeInstance(1, l);
        String time = "";
        try {
            time = df.format(new Date());
        }
        catch (Exception e) {
            logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
        }
        return time;
    }

    public static String getLocalTime(Date d) {
        Locale l = new Locale("zh", "CN");
        DateFormat df = DateFormat.getTimeInstance(1, l);
        String time = "";
        try {
            time = df.format(d);
        }
        catch (Exception e) {
            logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
        }
        return time;
    }

    public static String getTime(Date d) {
        String time = "";
        if (d != null) {
            DateFormat df = DateFormat.getTimeInstance();
            try {
                time = df.format(d);
            }
            catch (Exception e) {
                logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return time;
    }

    public static String getTime() {
        DateFormat df = DateFormat.getTimeInstance();
        String time = "";
        try {
            time = df.format(new Date());
        }
        catch (Exception e) {
            logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
        }
        return time;
    }

    public static String get19DateAndTime() {
        return DateUtil.getDate("yyyy-MM-dd HH:mm:ss");
    }

    public static String getDateAndTime() {
        String date = "";
        DateFormat df = DateFormat.getDateTimeInstance();
        try {
            date = df.format(new Date());
        }
        catch (Exception e) {
            logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
        }
        return date;
    }

    public static String getDateAndTime(Date d) {
        String date = "";
        if (d != null) {
            DateFormat df = DateFormat.getDateTimeInstance();
            try {
                date = df.format(d);
            }
            catch (Exception e) {
                logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return date;
    }

    public static String getLocalDateAndTime() {
        Locale l = new Locale("zh", "CN");
        DateFormat df = DateFormat.getDateTimeInstance(0, 3, l);
        String dateAndTime = "";
        try {
            dateAndTime = df.format(new Date());
        }
        catch (Exception e) {
            logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
        }
        return dateAndTime;
    }

    public static String getLocalDateAndTime(Date d) {
        String dateAndTime = "";
        if (d != null) {
            Locale l = new Locale("zh", "CN");
            DateFormat df = DateFormat.getDateTimeInstance(1, 3, l);
            try {
                dateAndTime = df.format(d);
            }
            catch (Exception e) {
                logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return dateAndTime;
    }

    public static int getYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        Date date = new Date();
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(calendar.getTime()), YEAR_MONTH_DAY_PATTERN);
        }
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth() {
        GregorianCalendar calendar = new GregorianCalendar();
        Date date = new Date();
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(calendar.getTime()), YEAR_MONTH_DAY_PATTERN);
        }
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getDay() {
        GregorianCalendar calendar = new GregorianCalendar();
        Date date = new Date();
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(calendar.getTime()), YEAR_MONTH_DAY_PATTERN);
        }
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static Date toDate(String date, String pattern) {
        if (date != null) {
            try {
                return Datetimes.parse(date, pattern);
            }
            catch (Exception e) {
                logger.error((Object)("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return null;
    }

    public static Date toDate(String date) {
        return DateUtil.toDate(date, "yyyy-MM-dd hh:mm:ss");
    }
}

