/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.i18n.ResourceBundleUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.TimeZoneUtil;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;

public final class Datetimes {
    private static final Log logger = CtpLogFactory.getLog(Datetimes.class);
    public static final String datetimeStyle = "yyyy-MM-dd HH:mm:ss";
    public static final String datetimeStyleNoSeparator = "yyyyMMddHHmmss";
    public static final String dateStyle = "yyyy-MM-dd";
    public static final String dateStyleWithoutYear = "MM-dd";
    public static final String datetimeStartWithMonthStyle = "MM-dd HH:mm";
    public static final String datetimeWithoutSecondStyle = "yyyy-MM-dd HH:mm";
    public static final String datetimeAllStyle = "yyyy-MM-dd HH:mm:ss.S";
    private static final String datetimeCSTStyle = "EEE MMM dd HH:mm:ss Z yyyy";
    private static final int[] seasonFirstMonth = new int[]{0, 0, 0, 3, 3, 3, 6, 6, 6, 9, 9, 9};
    private static final int[] seasonLastMonth = new int[]{2, 2, 2, 5, 5, 5, 8, 8, 8, 11, 11, 11};
    public static final String TIME_BUCKET_TYPE_THIS_WEEK = "thisWeek";
    public static final String TIME_BUCKET_TYPE_THIS_MONTH = "thisMonth";
    public static final String TIME_BUCKET_TYPE_THIS_SEASON = "thisSeason";
    public static final String TIME_BUCKET_TYPE_THIS_YEAR = "thisYear";
    public static final String TIME_BUCKET_TYPE_LAST_MONTH = "lastMonth";
    public static final String TIME_BUCKET_TYPE_LAST_2_MONTH = "last2Month";
    public static final String TIME_BUCKET_TYPE_LAST_3_MONTH = "last3Month";
    public static final SimpleDateFormat cstDateFormatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.US);

    public static Date getFirstDayInWeek(Date date, Locale locale) {
        GregorianCalendar calendar = new GregorianCalendar(locale);
        calendar.setTime(date);
        int firstDayOfWeek = calendar.getFirstDayOfWeek();
        int week = calendar.get(7);
        int dayOfWeek = 0;
        dayOfWeek = firstDayOfWeek == week ? 1 : (firstDayOfWeek > week ? 7 - week + firstDayOfWeek - 1 : week - firstDayOfWeek + 1);
        calendar.add(7, 1 - dayOfWeek);
        calendar.set(11, calendar.getActualMinimum(11));
        calendar.set(12, calendar.getActualMinimum(12));
        calendar.set(13, calendar.getActualMinimum(13));
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDayInWeek(Date date) {
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(date), dateStyle);
        }
        return Datetimes.getFirstDayInWeek(date, Locale.getDefault());
    }

    public static Date getFirstDayInWeek0(Date date) {
        Date date0 = Datetimes.getFirstDayInWeek(date, Locale.getDefault());
        return Datetimes.parse(Datetimes.formatNoTimeZone(date0, datetimeStyle), datetimeStyle);
    }

    public static Date getLastDayInWeek(Date date, Locale locale) {
        GregorianCalendar calendar = new GregorianCalendar(locale);
        calendar.setTime(date);
        int firstDayOfWeek = calendar.getFirstDayOfWeek();
        int week = calendar.get(7);
        int dayOfWeek = 0;
        dayOfWeek = firstDayOfWeek == week ? 1 : (firstDayOfWeek > week ? 7 - week + firstDayOfWeek - 1 : week - firstDayOfWeek + 1);
        calendar.add(7, 7 - dayOfWeek);
        calendar.set(11, calendar.getActualMaximum(11));
        calendar.set(12, calendar.getActualMaximum(12));
        calendar.set(13, calendar.getActualMaximum(13));
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDayInWeek(Date date) {
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(date), dateStyle);
        }
        return Datetimes.getLastDayInWeek(date, Locale.getDefault());
    }

    public static Date getLastDayInWeek0(Date date) {
        Date date0 = Datetimes.getLastDayInWeek(date, Locale.getDefault());
        return Datetimes.parse(Datetimes.formatNoTimeZone(date0, datetimeStyle), datetimeStyle);
    }

    public static Date getFirstDayInMonth(Date date, Locale locale) {
        GregorianCalendar calendar = new GregorianCalendar(locale);
        calendar.setTime(date);
        int day = calendar.getActualMinimum(5);
        calendar.set(5, day);
        calendar.set(11, calendar.getActualMinimum(11));
        calendar.set(12, calendar.getActualMinimum(12));
        calendar.set(13, calendar.getActualMinimum(13));
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDayInMonth(Date date) {
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(date), dateStyle);
        }
        return Datetimes.getFirstDayInMonth(date, Locale.getDefault());
    }

    public static Date getFirstDayInMonth0(Date date) {
        Date date0 = Datetimes.getFirstDayInMonth(date, Locale.getDefault());
        return Datetimes.parse(Datetimes.formatNoTimeZone(date0, datetimeStyle), datetimeStyle);
    }

    public static Date getLastDayInMonth(Date date, Locale locale) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int day = calendar.getActualMaximum(5);
        calendar.set(5, day);
        calendar.set(11, calendar.getActualMaximum(11));
        calendar.set(12, calendar.getActualMaximum(12));
        calendar.set(13, calendar.getActualMaximum(13));
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDayInMonth(Date date) {
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(date), dateStyle);
        }
        return Datetimes.getLastDayInMonth(date, Locale.getDefault());
    }

    public static Date getLastDayInMonth0(Date date) {
        Date date0 = Datetimes.getLastDayInMonth(date, Locale.getDefault());
        return Datetimes.parse(Datetimes.formatNoTimeZone(date0, datetimeStyle), datetimeStyle);
    }

    public static Date getFirstDayInSeason(Date date, Locale locale) {
        GregorianCalendar calendar = new GregorianCalendar(locale);
        calendar.setTime(Datetimes.getStartDayInMonth(date));
        int currentMonth = calendar.get(2);
        calendar.set(2, seasonFirstMonth[currentMonth]);
        calendar.set(11, calendar.getActualMinimum(11));
        calendar.set(12, calendar.getActualMinimum(12));
        calendar.set(13, calendar.getActualMinimum(13));
        calendar.set(14, 0);
        GregorianCalendar calendar2 = new GregorianCalendar();
        calendar2.setTime(calendar.getTime());
        int day = calendar2.getActualMinimum(5);
        calendar2.set(5, day);
        calendar2.set(11, calendar2.getActualMinimum(11));
        calendar2.set(12, calendar2.getActualMinimum(12));
        calendar2.set(13, calendar2.getActualMinimum(13));
        calendar2.set(14, 0);
        return calendar2.getTime();
    }

    private static Date getStartDayInMonth(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int day = calendar.getActualMinimum(5);
        calendar.set(5, day);
        calendar.set(11, calendar.getActualMinimum(11));
        calendar.set(12, calendar.getActualMinimum(12));
        calendar.set(13, calendar.getActualMinimum(13));
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDayInSeason(Date date) {
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(date), dateStyle);
        }
        return Datetimes.getFirstDayInSeason(date, Locale.getDefault());
    }

    public static Date getFirstDayInSeason0(Date date) {
        Date date0 = Datetimes.getFirstDayInSeason(date, Locale.getDefault());
        return Datetimes.parse(Datetimes.formatNoTimeZone(date0, datetimeStyle), datetimeStyle);
    }

    public static Date getLastDayInSeason(Date date, Locale locale) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(Datetimes.getStartDayInMonth(date));
        int currentMonth = calendar.get(2);
        calendar.set(2, seasonLastMonth[currentMonth]);
        calendar.set(11, calendar.getActualMaximum(11));
        calendar.set(12, calendar.getActualMaximum(12));
        calendar.set(13, calendar.getActualMaximum(13));
        calendar.set(14, 0);
        GregorianCalendar calendar2 = new GregorianCalendar();
        calendar2.setTime(calendar.getTime());
        int day = calendar2.getActualMaximum(5);
        calendar2.set(5, day);
        calendar2.set(11, calendar2.getActualMaximum(11));
        calendar2.set(12, calendar2.getActualMaximum(12));
        calendar2.set(13, calendar2.getActualMaximum(13));
        calendar2.set(14, 0);
        return calendar2.getTime();
    }

    public static Date getLastDayInSeason(Date date) {
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(date), dateStyle);
        }
        return Datetimes.getLastDayInSeason(date, Locale.getDefault());
    }

    public static Date getLastDayInSeason0(Date date) {
        Date date0 = Datetimes.getLastDayInSeason(date, Locale.getDefault());
        return Datetimes.parse(Datetimes.formatNoTimeZone(date0, datetimeStyle), datetimeStyle);
    }

    public static Date getFirstDayInYear(Date date, Locale locale) {
        GregorianCalendar calendar = new GregorianCalendar(locale);
        calendar.setTime(date);
        calendar.set(2, calendar.getActualMinimum(2));
        calendar.set(11, calendar.getActualMinimum(11));
        calendar.set(12, calendar.getActualMinimum(12));
        calendar.set(13, calendar.getActualMinimum(13));
        calendar.set(14, 0);
        GregorianCalendar calendar2 = new GregorianCalendar();
        calendar2.setTime(calendar.getTime());
        int day = calendar.getActualMinimum(5);
        calendar2.set(5, day);
        calendar2.set(11, calendar2.getActualMinimum(11));
        calendar2.set(12, calendar2.getActualMinimum(12));
        calendar2.set(13, calendar2.getActualMinimum(13));
        calendar2.set(14, 0);
        return calendar2.getTime();
    }

    public static Date getFirstDayInYear(Date date) {
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(date), dateStyle);
        }
        return Datetimes.getFirstDayInYear(date, Locale.getDefault());
    }

    public static Date getFirstDayInYear0(Date date) {
        Date date0 = Datetimes.getFirstDayInYear(date, Locale.getDefault());
        return Datetimes.parse(Datetimes.formatNoTimeZone(date0, datetimeStyle), datetimeStyle);
    }

    public static Date getLastDayInYear(Date date, Locale locale) {
        GregorianCalendar calendar = new GregorianCalendar(locale);
        calendar.setTime(date);
        calendar.set(2, calendar.getActualMaximum(2));
        calendar.set(11, calendar.getActualMaximum(11));
        calendar.set(12, calendar.getActualMaximum(12));
        calendar.set(13, calendar.getActualMaximum(13));
        calendar.set(14, 0);
        GregorianCalendar calendar2 = new GregorianCalendar();
        calendar2.setTime(calendar.getTime());
        int day = calendar2.getActualMaximum(5);
        calendar2.set(5, day);
        calendar2.set(11, calendar2.getActualMaximum(11));
        calendar2.set(12, calendar2.getActualMaximum(12));
        calendar2.set(13, calendar2.getActualMaximum(13));
        calendar2.set(14, 0);
        return calendar2.getTime();
    }

    public static Date getLastDayInYear(Date date) {
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(date), dateStyle);
        }
        return Datetimes.getLastDayInYear(date, Locale.getDefault());
    }

    public static Date getLastDayInYear0(Date date) {
        Date date0 = Datetimes.getLastDayInYear(date, Locale.getDefault());
        return Datetimes.parse(Datetimes.formatNoTimeZone(date0, datetimeStyle), datetimeStyle);
    }

    public static Date getTheLastMonth(Date date, Locale locale, int i) {
        GregorianCalendar calendar = new GregorianCalendar(locale);
        calendar.setTime(date);
        calendar.add(2, i);
        calendar.set(11, calendar.getActualMinimum(11));
        calendar.set(12, calendar.getActualMinimum(12));
        calendar.set(13, calendar.getActualMinimum(13));
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getTheLastmonth(Date date, int i) {
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(date), dateStyle);
        }
        return Datetimes.getTheLastMonth(date, Locale.getDefault(), i);
    }

    public static Date getTheLastMonth0(Date date, int i) {
        Date date0 = Datetimes.getTheLastMonth(date, Locale.getDefault(), i);
        return Datetimes.parse(Datetimes.formatNoTimeZone(date0, datetimeStyle), datetimeStyle);
    }

    public static Date getTodayFirstTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        if (TimeZoneUtil.isEnable()) {
            TimeZoneUtil.transCalendarToCustomer(calendar);
        }
        calendar.set(11, ((Calendar)calendar).getActualMinimum(11));
        calendar.set(12, ((Calendar)calendar).getActualMinimum(12));
        calendar.set(13, ((Calendar)calendar).getActualMinimum(13));
        calendar.set(14, 0);
        return Datetimes.parse(Datetimes.formatNoTimeZone(calendar.getTime(), datetimeStyle), datetimeStyle);
    }

    public static Date getTodayFirstTimeNoTimeZone() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, ((Calendar)calendar).getActualMinimum(11));
        calendar.set(12, ((Calendar)calendar).getActualMinimum(12));
        calendar.set(13, ((Calendar)calendar).getActualMinimum(13));
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getTodayFirstTime(Date date) {
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(date), datetimeStyle);
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(11, ((Calendar)calendar).getActualMinimum(11));
        calendar.set(12, ((Calendar)calendar).getActualMinimum(12));
        calendar.set(13, ((Calendar)calendar).getActualMinimum(13));
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getTodayFirstTime(String dateStr) {
        return Datetimes.getTodayFirstTime(Datetimes.parseNoTimeZone(dateStr, dateStyle));
    }

    public static String getFirstTimeStr(String dateStr) {
        String date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(dateStyle);
        try {
            date = sdf.format(sdf.parse(dateStr)) + " 00:00:00";
        }
        catch (ParseException e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return date;
    }

    public static Date getFirstTime(Date date) {
        return Datetimes.parse(Datetimes.getFirstTimeStr(Datetimes.formatNoTimeZone(date, dateStyle)), datetimeStyle);
    }

    public static Date getFirstNoTimeZone(Date date) {
        return Datetimes.parseNoTimeZone(Datetimes.getFirstTimeStr(Datetimes.formatNoTimeZone(date, dateStyle)), datetimeStyle);
    }

    public static String getServiceFirstTime(String date) {
        return Datetimes.formatNoTimeZone(Datetimes.getFirstTime(Datetimes.parseNoTimeZone(date, null)), datetimeStyle);
    }

    public static Date getLastTime(Date date) {
        return Datetimes.parse(Datetimes.getLastTimeStr(Datetimes.formatNoTimeZone(date, dateStyle)), datetimeStyle);
    }

    public static Date getLastTimeNoTimeZone(Date date) {
        return Datetimes.parseNoTimeZone(Datetimes.getLastTimeStr(Datetimes.formatNoTimeZone(date, dateStyle)), datetimeStyle);
    }

    public static String getServiceLastTime(String date) {
        return Datetimes.formatNoTimeZone(Datetimes.getLastTime(Datetimes.parseNoTimeZone(date, null)), datetimeStyle);
    }

    public static Date getTodayLastTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        if (TimeZoneUtil.isEnable()) {
            TimeZoneUtil.transCalendarToCustomer(calendar);
        }
        calendar.set(11, ((Calendar)calendar).getActualMaximum(11));
        calendar.set(12, ((Calendar)calendar).getActualMaximum(12));
        calendar.set(13, ((Calendar)calendar).getActualMaximum(13));
        calendar.set(14, 0);
        return Datetimes.parse(Datetimes.formatNoTimeZone(calendar.getTime(), datetimeStyle), datetimeStyle);
    }

    public static Date getTodayLastTimeNoTimeZone() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, ((Calendar)calendar).getActualMaximum(11));
        calendar.set(12, ((Calendar)calendar).getActualMaximum(12));
        calendar.set(13, ((Calendar)calendar).getActualMaximum(13));
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getTodayLastTime(Date date) {
        if (TimeZoneUtil.isEnable()) {
            date = Datetimes.parseNoTimeZone(Datetimes.formatDatetime(date), datetimeStyle);
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(11, ((Calendar)calendar).getActualMaximum(11));
        calendar.set(12, ((Calendar)calendar).getActualMaximum(12));
        calendar.set(13, ((Calendar)calendar).getActualMaximum(13));
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getTodayLastTime(String dateStr) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(Datetimes.parseNoTimeZone(dateStr, dateStyle));
        calendar.set(11, ((Calendar)calendar).getActualMaximum(11));
        calendar.set(12, ((Calendar)calendar).getActualMaximum(12));
        calendar.set(13, ((Calendar)calendar).getActualMaximum(13));
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getLastTimeStr(String dateStr) {
        String date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(dateStyle);
        try {
            date = sdf.format(sdf.parse(dateStr)) + " 23:59:59";
        }
        catch (ParseException e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return date;
    }

    public static String formatDatetime(Date datetime) {
        return Datetimes.format(datetime, datetimeStyle);
    }

    public static String formatDatetime(Date datetime, TimeZone timezone) {
        return Datetimes.format(datetime, datetimeStyle, timezone);
    }

    public static String formatDatetimeWithoutSecond(Date datetime) {
        return Datetimes.format(datetime, datetimeWithoutSecondStyle);
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return Datetimes.format(date, dateStyle);
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        TimeZone timeZone = null;
        timeZone = TimeZoneUtil.isEnable() ? TimeZoneUtil.getCustomerTimeZone() : TimeZone.getDefault();
        return DateFormatUtils.format((Date)date, (String)pattern, (TimeZone)timeZone);
    }

    public static String formatNoTimeZone(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static String formatDate(Date date, Locale locale) {
        if (date == null) {
            return null;
        }
        return Datetimes.format(date, dateStyle, locale);
    }

    public static String format(Date date, Locale locale) {
        if (date == null) {
            return null;
        }
        TimeZone timeZone = null;
        timeZone = TimeZoneUtil.isEnable() ? TimeZoneUtil.getCustomerTimeZone() : TimeZone.getDefault();
        return DateFormatUtils.format((Date)date, (String)datetimeStyle, (Locale)locale);
    }

    public static String format(Date date, String pattern, Locale locale) {
        if (date == null) {
            return null;
        }
        TimeZone timeZone = null;
        timeZone = TimeZoneUtil.isEnable() ? TimeZoneUtil.getCustomerTimeZone() : TimeZone.getDefault();
        return DateFormatUtils.format((Date)date, (String)pattern, (TimeZone)timeZone, (Locale)locale);
    }

    public static String format(Date date, String pattern, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        if (null == timeZone && TimeZoneUtil.isEnable()) {
            timeZone = TimeZoneUtil.getCustomerTimeZone();
        }
        return DateFormatUtils.format((Date)date, (String)pattern, (TimeZone)timeZone);
    }

    public static String format(Date date, String pattern, TimeZone zone, Locale locale) {
        if (date == null) {
            return null;
        }
        if (null == zone && TimeZoneUtil.isEnable()) {
            zone = TimeZoneUtil.getCustomerTimeZone();
        }
        return DateFormatUtils.format((Date)date, (String)pattern, (TimeZone)zone, (Locale)locale);
    }

    public static String formatDateOrDatetime(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0) {
            return Datetimes.formatDate(date);
        }
        return Datetimes.formatDatetime(date);
    }

    public static Date parseDatetime(String datetime) {
        return Datetimes.parse(datetime, null, datetimeStyle);
    }

    public static Date parseDatetime(String datetime, TimeZone timeZone) {
        return Datetimes.parse(datetime, timeZone, datetimeStyle);
    }

    public static Date parseDate(String date) {
        return Datetimes.parse(date, null, dateStyle);
    }

    public static Date parseDatetimeWithoutSecond(String date) {
        return Datetimes.parse(date, null, datetimeWithoutSecondStyle);
    }

    public static Date parse(String dateStr) {
        return Datetimes.parse(dateStr, null, null);
    }

    public static Date parse(String dateStr, TimeZone timeZone) {
        return Datetimes.parse(dateStr, timeZone, null);
    }

    public static Date parse(String dateStr, String pattern) {
        return Datetimes.parse(dateStr, null, pattern);
    }

    public static Date parse(String dateStr, TimeZone timeZone, String pattern) {
        if (Strings.isBlank(dateStr)) {
            return null;
        }
        if (null == timeZone) {
            timeZone = TimeZoneUtil.isEnable() ? TimeZoneUtil.getCustomerTimeZone() : TimeZone.getDefault();
        }
        Date date = null;
        SimpleDateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        parser = new SimpleDateFormat();
        parser.setTimeZone(timeZone);
        try {
            if (Strings.isNotBlank(pattern)) {
                parser.applyPattern(pattern);
                date = parser.parse(dateStr, pos);
            }
            if (date == null) {
                String[] parsePatterns = new String[]{dateStyle, datetimeWithoutSecondStyle, datetimeStyle, datetimeAllStyle};
                for (int i = 0; i < parsePatterns.length; ++i) {
                    parser.applyPattern(parsePatterns[i]);
                    pos.setIndex(0);
                    date = parser.parse(dateStr, pos);
                    if (date != null && pos.getIndex() == dateStr.length()) break;
                }
            }
            if (date == null) {
                pos.setIndex(0);
                date = cstDateFormatter.parse(dateStr, pos);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return date;
    }

    public static Date parseNoTimeZone(String dateStr, String pattern) {
        if (Strings.isBlank(dateStr)) {
            return null;
        }
        String[] parsePatterns = null;
        parsePatterns = Strings.isBlank(pattern) ? new String[]{dateStyle, datetimeWithoutSecondStyle, datetimeStyle, datetimeAllStyle} : new String[]{pattern};
        try {
            SimpleDateFormat parser = null;
            ParsePosition pos = new ParsePosition(0);
            for (int i = 0; i < parsePatterns.length; ++i) {
                parser = new SimpleDateFormat(parsePatterns[i]);
                parser.applyPattern(parsePatterns[i]);
                pos.setIndex(0);
                Date date = parser.parse(dateStr, pos);
                if (!(date == null || pos.getIndex() != dateStr.length() && Strings.isBlank(pattern))) {
                    return date;
                }
                if (dateStr.length() <= datetimeStyle.length()) continue;
                return date;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static Date addSecond(Date date, int amount) {
        return Datetimes.add(date, 13, amount);
    }

    public static Date addMinute(Date date, int amount) {
        return Datetimes.add(date, 12, amount);
    }

    public static Date addHour(Date date, int amount) {
        return Datetimes.add(date, 11, amount);
    }

    public static Date addDate(Date date, int amount) {
        return Datetimes.add(date, 5, amount);
    }

    public static Date addMonth(Date date, int amount) {
        return Datetimes.add(date, 2, amount);
    }

    public static Date addYear(Date date, int amount) {
        return Datetimes.add(date, 1, amount);
    }

    private static Date add(Date date, int field, int amount) {
        if (amount == 0) {
            return date;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static boolean between(Date checkupDate, Date startDate, Date endDate, boolean isIncludeBorderline) {
        if (!startDate.before(endDate)) {
            Date temp = startDate;
            startDate = endDate;
            endDate = temp;
        }
        if (checkupDate.after(startDate) && checkupDate.before(endDate)) {
            return true;
        }
        return isIncludeBorderline && (checkupDate.equals(startDate) || checkupDate.equals(endDate));
    }

    public static boolean checkOverup(Date startDate1, Date endDate1, Date startDate2, Date endDate2, boolean allowIncludeBorderline) {
        Date temp;
        if (!startDate1.before(endDate1)) {
            temp = startDate1;
            startDate1 = endDate1;
            endDate1 = temp;
        }
        if (!startDate2.before(endDate2)) {
            temp = startDate2;
            startDate2 = endDate2;
            endDate2 = temp;
        }
        if (endDate1.before(startDate2) || endDate2.before(startDate1)) {
            return false;
        }
        return !allowIncludeBorderline || !endDate1.equals(startDate2) && !endDate2.equals(startDate1);
    }

    public static Date getNextPeriodMinute(Date date, int period, boolean clearSecond) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        if (clearSecond) {
            calendar.set(13, calendar.getActualMaximum(13));
        }
        int minute = calendar.get(12);
        int newMinute = 0;
        int i = 0;
        while ((newMinute = i++ * period) <= minute) {
        }
        int amount = newMinute - minute;
        calendar.add(12, amount);
        return calendar.getTime();
    }

    public static Date conversionToServerDate(Date localDate, TimeZone localZone) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(localDate);
        int amount = TimeZone.getDefault().getRawOffset() - localZone.getRawOffset();
        calendar.add(14, amount);
        return calendar.getTime();
    }

    public static String formateToLocaleDatetime(Date date) {
        String datePattern = ResourceBundleUtil.getString("com.seeyon.v3x.common.resources.i18n.SeeyonCommonResources", "common.datetime.pattern", new Object[0]);
        return Datetimes.format(date, datePattern, Locale.getDefault());
    }

    public static String formateToLocaleDate(Date date) {
        String datePattern = ResourceBundleUtil.getString("com.seeyon.v3x.common.resources.i18n.SeeyonCommonResources", "common.date.pattern", new Object[0]);
        return Datetimes.format(date, datePattern, Locale.getDefault());
    }

    public static long minusDay(Date theDay, Date otherDay) {
        long minusDay = theDay.getTime() - otherDay.getTime();
        return minusDay / 86400000L;
    }

    public static long[] detailInterval(Date theDay, Date otherDay) {
        if (otherDay == null) {
            return null;
        }
        long seconds = (otherDay.getTime() - theDay.getTime()) / 1000L;
        long date = seconds / 86400L;
        long hour = (seconds - date * 24L * 60L * 60L) / 3600L;
        long minut = (seconds - date * 24L * 60L * 60L - hour * 60L * 60L) / 60L;
        long second = seconds - date * 24L * 60L * 60L - hour * 60L * 60L - minut * 60L;
        return new long[]{date, hour, minut, second};
    }

    public static long[] formatLongToTimeStr(long millisecond) {
        long seconds = millisecond / 1000L;
        long date = seconds / 86400L;
        long hour = (seconds - date * 24L * 60L * 60L) / 3600L;
        long minut = (seconds - date * 24L * 60L * 60L - hour * 60L * 60L) / 60L;
        long second = seconds - date * 24L * 60L * 60L - hour * 60L * 60L - minut * 60L;
        return new long[]{date, hour, minut, second};
    }

    public static String formatMins2TimeStr(Integer times) {
        if (times == null) {
            return null;
        }
        int hours = times / 60;
        int mins = times - 60 * hours;
        return ResourceBundleUtil.getString("com.seeyon.v3x.common.resources.i18n.SeeyonCommonResources", "common.date.times", hours, mins);
    }

    public static Date transDateToCustomer(Date date, String pattern) {
        return Datetimes.parseNoTimeZone(Datetimes.format(date, pattern), pattern);
    }

    public static String formatDateStr(String dateStr, String pattern) {
        return Datetimes.format(Datetimes.parseNoTimeZone(dateStr, pattern), pattern);
    }
}

