/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.google.common.collect.Lists;
import com.seeyon.ctp.common.config.PerformanceConfig;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.dao.paginate.Pagination;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlipInfo
implements Serializable {
    private List data;
    private int page = 1;
    private int size = 20;
    private boolean needTotal = true;
    private int total = 0;
    private List<SortPair> sortPairs = new ArrayList<SortPair>();
    private Map params;
    private boolean isSetPagination = false;

    public FlipInfo() {
        String str = PerformanceConfig.getInstance().getConfig(SystemProperties.CONFIG_PAGINATE_PAGE_SIZE);
        if (str != null) {
            this.size = Integer.parseInt(str);
        }
    }

    public FlipInfo(int page) {
        this.page = page;
    }

    public FlipInfo(int page, int size) {
        this.page = page;
        this.size = size;
    }

    public FlipInfo(Map flipMap) {
        if (flipMap != null) {
            int p = Integer.parseInt((String)flipMap.get("page"));
            int s = Integer.parseInt((String)flipMap.get("size"));
            String sf = (String)flipMap.get("sortField");
            String so = (String)flipMap.get("sortOrder");
            this.page = p;
            this.size = s;
            if (!Strings.isBlank(sf)) {
                SortPair sortPair = new SortPair(sf);
                sortPair.setSortOrder(this.toOrder(so));
                this.sortPairs.add(sortPair);
            }
        }
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public Integer getPages() {
        if (this.size == 0) {
            return 0;
        }
        BigDecimal sizeBD = new BigDecimal(this.size);
        BigDecimal totalBD = new BigDecimal(this.total);
        return totalBD.divide(sizeBD, 0, 2).intValue();
    }

    public Integer getStartAt() {
        Integer p = this.getPage();
        p = p != null && p - 1 >= 0 ? p - 1 : 0;
        return p * this.getSize();
    }

    public List getData() {
        if (this.data == null) {
            this.data = new ArrayList();
        }
        return this.data;
    }

    public void setData(List data) {
        if (this.data == null) {
            this.data = new ArrayList();
        }
        if (data == null) {
            this.data.clear();
        } else {
            this.data = Lists.newArrayList((Iterable)data);
        }
        if (this.isSetPagination && this.isNeedTotal()) {
            this.setTotal(Pagination.getRowCount());
        }
    }

    public Integer getDataCount() {
        if (this.data != null) {
            return this.data.size();
        }
        return 0;
    }

    public void setNeedTotal(boolean needTotal) {
        this.needTotal = needTotal;
    }

    public boolean isNeedTotal() {
        return this.needTotal;
    }

    public String getSortField() {
        return this.sortPairs.size() > 0 ? this.sortPairs.get(0).getSortField() : null;
    }

    public void setSortField(String sortField) {
        if (Strings.isBlank(sortField)) {
            return;
        }
        this.sortPairs.add(new SortPair(sortField));
    }

    public String getSortOrder() {
        if (this.sortPairs.size() == 0) {
            return "asc";
        }
        return this.sortPairs.get(0).getSortOrder().name().toLowerCase();
    }

    public void setSortOrder(String sortOrder) {
        if (this.sortPairs.size() == 0) {
            return;
        }
        this.sortPairs.get(0).setSortOrder(this.toOrder(sortOrder));
    }

    public void addSortPair(SortPair sortPair) {
        this.sortPairs.add(sortPair);
    }

    public List<SortPair> getSortPairs() {
        return this.sortPairs;
    }

    public Map getParams() {
        return this.params;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public String toJSON() throws BusinessException {
        String result = "{}";
        FlipInfo fpi = this;
        if (fpi != null) {
            HashMap<String, Object> rmap = new HashMap<String, Object>();
            rmap.put("total", fpi.getTotal());
            rmap.put("rows", fpi.getData());
            rmap.put("page", fpi.getPage());
            rmap.put("pages", fpi.getPages());
            rmap.put("size", fpi.getSize());
            result = JSONUtil.toJSONString(rmap);
        }
        return result;
    }

    public void setPagination() {
        Pagination.setNeedCount(true);
        Pagination.setFirstResult(this.getStartAt());
        Pagination.setMaxResults(this.getSize());
        this.isSetPagination = true;
    }

    private Order toOrder(String so) {
        if (Order.DESC.name().equalsIgnoreCase(so)) {
            return Order.DESC;
        }
        return Order.ASC;
    }

    public class SortPair
    implements Serializable {
        private String sortField;
        private Order sortOrder;

        public SortPair(String sortField) {
            this.sortField = sortField;
            this.sortOrder = Order.ASC;
        }

        public String getSortField() {
            return this.sortField;
        }

        public void setSortField(String sortField) {
            this.sortField = sortField;
        }

        public Order getSortOrder() {
            return this.sortOrder;
        }

        public void setSortOrder(Order sortOrder) {
            this.sortOrder = sortOrder;
        }
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

