/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.ObjectToXMLBase;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public final class ObjectToXMLUtil {
    protected static final transient Log LOG = CtpLogFactory.getLog(ObjectToXMLUtil.class);
    public static final String NEW_LINE = "";
    private static final String NODE_NAME_AJAX_BEAN = "B";
    private static final String NODE_NAME_AJAX_LIST = "L";
    private static final String NODE_NAME_PROPERTY = "P";
    private static final String NODE_NAME_VALUE = "V";
    private static final String NODE_ATTRIBUTE_NAME_NAME = "n";

    public static StringBuilder bean2XMLString(ObjectToXMLBase bean) {
        StringBuilder sb = new StringBuilder();
        Map map = null;
        try {
            map = PropertyUtils.describe((Object)bean);
        }
        catch (Exception ex) {
            LOG.error((Object)NEW_LINE, (Throwable)ex);
        }
        if (map != null) {
            sb.append((CharSequence)ObjectToXMLUtil.makeBeanNodeBegin(bean.getClass()));
            sb.append(NEW_LINE);
            Set key = map.keySet();
            for (String item : key) {
                Object o;
                if ("class".equals(item) || null == (o = map.get(item))) continue;
                sb.append("<P n=\"" + item + "\">");
                if (o instanceof ObjectToXMLBase) {
                    sb.append(((ObjectToXMLBase)o).toXML());
                } else if (o instanceof String) {
                    sb.append("<![CDATA[").append(ObjectToXMLUtil.escapeUnSupportAscall(o.toString())).append("]]>");
                } else if (o instanceof Character) {
                    if (((Character)o).charValue() != '\u0000') {
                        sb.append("<![CDATA[").append(o).append("]]>");
                    }
                } else if (o instanceof Date) {
                    sb.append(((Date)o).getTime());
                } else if (o instanceof Map) {
                    sb.append((CharSequence)ObjectToXMLUtil.mapToXMLString((Map)o));
                } else if (o instanceof Number) {
                    sb.append(o);
                } else if (o instanceof Long) {
                    sb.append(o);
                } else if (o instanceof Integer) {
                    sb.append(o);
                } else if (o instanceof Byte) {
                    sb.append(o);
                } else if (o instanceof Short) {
                    sb.append(o);
                } else if (o instanceof Boolean) {
                    sb.append(o);
                } else {
                    sb.append(o);
                }
                sb.append("</P>");
                sb.append(NEW_LINE);
            }
            sb.append((CharSequence)ObjectToXMLUtil.makeBeanNodeEnd());
            sb.append(NEW_LINE);
        }
        return sb;
    }

    private static StringBuilder mapToXMLString(Map map) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)ObjectToXMLUtil.makeBeanNodeBegin(Map.class)).append(NEW_LINE);
        Set e = map.keySet();
        for (Object key : e) {
            sb.append("<P n=\"" + key + "\">");
            sb.append(ObjectToXMLUtil.objectToXML(map.get(key)));
            sb.append("</P>").append(NEW_LINE);
        }
        sb.append((CharSequence)ObjectToXMLUtil.makeBeanNodeEnd()).append(NEW_LINE);
        return sb;
    }

    private static StringBuilder listToXMLString(Collection list) {
        StringBuilder sb = new StringBuilder();
        sb.append("<L>").append(NEW_LINE);
        for (Object object : list) {
            sb.append(ObjectToXMLUtil.objectToXML(object));
        }
        sb.append("</L>");
        return sb;
    }

    public static String objectToXML(Object object) {
        StringBuilder sb = new StringBuilder();
        if (null != object) {
            if (object instanceof String || object instanceof StringBuilder) {
                sb.append((CharSequence)ObjectToXMLUtil.stringToXML(String.valueOf(object)));
            } else if (object instanceof ObjectToXMLBase) {
                sb.append(((ObjectToXMLBase)object).toXML());
            } else if (object instanceof Collection) {
                sb.append((CharSequence)ObjectToXMLUtil.listToXMLString((Collection)object));
            } else if (object instanceof Object[]) {
                sb.append((CharSequence)ObjectToXMLUtil.listToXMLString(Arrays.asList((Object[])object)));
            } else if (object instanceof Enumeration) {
                ArrayList list = new ArrayList();
                Enumeration e = (Enumeration)object;
                while (e.hasMoreElements()) {
                    list.add(e.nextElement());
                }
                sb.append((CharSequence)ObjectToXMLUtil.listToXMLString(list));
            } else if (object instanceof Map) {
                sb.append((CharSequence)ObjectToXMLUtil.mapToXMLString((Map)object));
            } else if (object instanceof Date) {
                sb.append((CharSequence)ObjectToXMLUtil.dateToXML((Date)object));
            } else if (object instanceof Number) {
                sb.append((CharSequence)ObjectToXMLUtil.numberToXML(object));
            } else if (object instanceof Long) {
                sb.append((CharSequence)ObjectToXMLUtil.numberToXML(object));
            } else if (object instanceof Integer) {
                sb.append((CharSequence)ObjectToXMLUtil.numberToXML(object));
            } else if (object instanceof Byte) {
                sb.append((CharSequence)ObjectToXMLUtil.numberToXML(object));
            } else if (object instanceof Short) {
                sb.append((CharSequence)ObjectToXMLUtil.numberToXML(object));
            } else if (object instanceof Boolean) {
                sb.append((CharSequence)ObjectToXMLUtil.numberToXML(object));
            } else if (object instanceof Character) {
                sb.append((CharSequence)ObjectToXMLUtil.characterToXML((Character)object));
            } else {
                sb.append((CharSequence)ObjectToXMLUtil.stringToXML(String.valueOf(object)));
            }
        }
        return sb.toString();
    }

    public static Map<String, String> getParameterMap(HttpServletRequest request, HttpServletResponse response) {
        Map<String, String> map = ParamUtil.getParameterMapFromRequest(request, String.class);
        if (map == null) {
            map = new HashMap<String, String>();
        }
        SAXReader sax = new SAXReader();
        try {
            ServletInputStream in = request.getInputStream();
            Document doc = sax.read((InputStream)in);
            Element root = doc.getRootElement();
            if (!"QueryXML".equals(root.getName())) {
                return null;
            }
            List queries = root.selectNodes("Query");
            if (queries != null) {
                for (Node item : queries) {
                    String key = item.valueOf("@name");
                    String value = item.getText();
                    if (key == null) continue;
                    map.put(key, value);
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)NEW_LINE, (Throwable)ex);
        }
        return map;
    }

    private static StringBuilder stringToXML(String value) {
        StringBuilder sb = new StringBuilder();
        if (Strings.isNotEmpty(value)) {
            sb.append("<V><![CDATA[").append(ObjectToXMLUtil.escapeUnSupportAscall(value)).append("]]></V>");
        }
        return sb;
    }

    private static String escapeUnSupportAscall(String value) {
        if (Strings.isNotBlank(value)) {
            return value.replaceAll("[\\u0000-\\u0007]|\\u000B|[\\u000E-\\u001F]", NEW_LINE);
        }
        return value;
    }

    private static StringBuilder numberToXML(Object value) {
        StringBuilder sb = new StringBuilder();
        if (value != null) {
            sb.append("<V>").append(value).append("</V>");
        }
        return sb;
    }

    private static StringBuilder characterToXML(Character value) {
        if (value.charValue() == '\u0000') {
            return new StringBuilder();
        }
        return new StringBuilder("<![CDATA[").append(value).append("]]>");
    }

    private static StringBuilder dateToXML(Date value) {
        StringBuilder sb = new StringBuilder();
        if (value != null) {
            sb.append("<V>").append(value.getTime()).append("</V>");
        }
        return sb;
    }

    public static StringBuilder makeProperties(String name, Object value) {
        if (Strings.isBlank(name) || value == null) {
            return new StringBuilder();
        }
        return new StringBuilder("<P n=\"" + name + "\">").append(ObjectToXMLUtil.objectToXML(value)).append("</P>");
    }

    public static StringBuilder makeBeanNodeBegin(Class clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append("<B");
        sb.append(">");
        return sb;
    }

    public static StringBuilder makeBeanNodeEnd() {
        return new StringBuilder("</B>");
    }
}

