/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.util.Datetimes;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SDFCoder {
    private static final String SPLIT_STR = ";\n";
    private static final char ASSIGN_STR = '=';

    public static String serializeMap(Map<String, Object> map) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("{");
        for (Map.Entry<String, Object> e : map.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            if (value == null) continue;
            sBuilder.append(key);
            sBuilder.append('=');
            if (value instanceof String) {
                sBuilder.append("s");
                sBuilder.append(value.toString());
                sBuilder.append(SPLIT_STR);
                continue;
            }
            if (value instanceof Integer) {
                sBuilder.append("i");
                sBuilder.append(value.toString());
                sBuilder.append(SPLIT_STR);
                continue;
            }
            if (value instanceof Long) {
                sBuilder.append("l");
                sBuilder.append(value.toString());
                sBuilder.append(SPLIT_STR);
                continue;
            }
            if (value instanceof Boolean) {
                sBuilder.append("b");
                sBuilder.append(value.toString());
                sBuilder.append(SPLIT_STR);
                continue;
            }
            if (value instanceof Timestamp) {
                sBuilder.append("T");
                sBuilder.append(Datetimes.formatNoTimeZone((Date)value, "yyyy-MM-dd HH:mm:ss.S"));
                sBuilder.append(SPLIT_STR);
                continue;
            }
            if (value instanceof Date) {
                sBuilder.append("D");
                sBuilder.append(Datetimes.formatNoTimeZone((Date)value, "yyyy-MM-dd HH:mm:ss.S z"));
                sBuilder.append(SPLIT_STR);
                continue;
            }
            if (value instanceof Short) {
                sBuilder.append("S");
                sBuilder.append(value.toString());
                sBuilder.append(SPLIT_STR);
                continue;
            }
            if (value instanceof Float) {
                sBuilder.append("f");
                sBuilder.append(value.toString());
                sBuilder.append(SPLIT_STR);
                continue;
            }
            if (value instanceof Double) {
                sBuilder.append("d");
                sBuilder.append(value.toString());
                sBuilder.append(SPLIT_STR);
                continue;
            }
            if (!(value instanceof Byte)) continue;
            sBuilder.append("B");
            sBuilder.append(value.toString());
            sBuilder.append(SPLIT_STR);
        }
        sBuilder.append("}");
        return sBuilder.toString();
    }

    public static Map<String, Object> deSerializeMap(String extProps) {
        if (StringUtils.isBlank((CharSequence)extProps)) {
            return null;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        StringBuilder nBuilder = new StringBuilder();
        String type = null;
        StringBuilder vBuilder = new StringBuilder();
        char preChar = ' ';
        for (int i = 1; i < extProps.length(); ++i) {
            preChar = extProps.charAt(i - 1);
            char curChar = extProps.charAt(i);
            if (type == null && preChar == '=') {
                type = String.valueOf(curChar);
                continue;
            }
            if (type == null && curChar != '=') {
                nBuilder.append(curChar);
                continue;
            }
            if (type == null && curChar == '=') continue;
            if (type != null && curChar == '\n' && preChar == ';') {
                dataMap.put(nBuilder.toString(), SDFCoder.generateObject(type, vBuilder.toString()));
                type = null;
                nBuilder.setLength(0);
                vBuilder.setLength(0);
                continue;
            }
            if (type != null && curChar != '\n' && preChar == ';') {
                vBuilder.append(preChar);
                if (curChar == ';') continue;
                vBuilder.append(curChar);
                continue;
            }
            if (type != null && curChar != ';') {
                vBuilder.append(curChar);
                continue;
            }
            if (type != null && curChar != ';') continue;
        }
        return dataMap;
    }

    private static Object generateObject(String type, String value) {
        if ("s".equals(type)) {
            return value;
        }
        if ("i".equals(type)) {
            return new Integer(value);
        }
        if ("l".equals(type)) {
            return new Long(value);
        }
        if ("b".equals(type)) {
            return new Boolean(value);
        }
        if ("T".equals(type)) {
            return new Timestamp(Datetimes.parseNoTimeZone(value, "yyyy-MM-dd HH:mm:ss.S").getTime());
        }
        if ("D".equals(type)) {
            return Datetimes.parseNoTimeZone(value, "yyyy-MM-dd HH:mm:ss.S z");
        }
        if ("S".equals(type)) {
            return new Short(value);
        }
        if ("f".equals(type)) {
            return new Float(value);
        }
        if ("d".equals(type)) {
            return new Double(value);
        }
        if ("B".equals(type)) {
            return new Byte(value);
        }
        return null;
    }
}

