/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

public class SnowFlake {
    private static final long START_STMP = 1529385480076L;
    private static final long SEQUENCE_BIT = 16L;
    private static final long MACHINE_BIT = 8L;
    private static final long DATACENTER_BIT = 2L;
    private static final long MAX_DATACENTER_NUM = 3L;
    private static final long MAX_MACHINE_NUM = 255L;
    private static final long MAX_SEQUENCE = 65535L;
    private static final long MACHINE_LEFT = 16L;
    private static final long DATACENTER_LEFT = 24L;
    private static final long TIMESTMP_LEFT = 26L;
    private long datacenterId;
    private long machineId;
    private long sequence = 0L;
    private long lastStmp = -1L;

    public SnowFlake(long centerId, long machineId) {
        if (centerId > 3L || this.datacenterId < 0L) {
            throw new IllegalArgumentException("datacenterId can't be greater than 3 or less than 0");
        }
        if (machineId > 255L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than 255 or less than 0");
        }
        this.datacenterId = centerId;
        this.machineId = machineId;
    }

    public synchronized long nextId() {
        long currStmp = this.getNewstmp();
        if (currStmp < this.lastStmp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStmp == this.lastStmp) {
            this.sequence = this.sequence + 1L & 0xFFFFL;
            if (this.sequence == 0L) {
                currStmp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStmp = currStmp;
        return currStmp - 1529385480076L << 26 | this.datacenterId << 24 | this.machineId << 16 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewstmp();
        while (mill <= this.lastStmp) {
            mill = this.getNewstmp();
        }
        return mill;
    }

    private long getNewstmp() {
        return System.currentTimeMillis();
    }
}

