/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.Calendar;
import org.apache.commons.logging.Log;

public class UUIDGenerator {
    private static final byte[] ALPHABET;
    private static final Log log;
    protected static final int millisPerDay = 86400000;
    private static int hostId;
    private static byte hostCode1;
    private static byte hostCode2;
    private static final byte[] emptyIP;
    protected static final byte[] IP;
    private static short counter;
    private static long dateCount;
    private static byte[] dateBuffer;
    private static long timeInterval;
    private static String currDate;
    private static SecureRandom seeder;
    private static String midValue;
    private static UUIDGenerator key;

    public static int getHostId() {
        return hostId;
    }

    public static void setHostId(int id) {
        hostId = id;
        hostCode1 = ALPHABET[hostId >>> 4 & 0xF];
        hostCode2 = ALPHABET[hostId & 0xF];
    }

    public static long getTimeInterval() {
        return timeInterval;
    }

    public static void setTimeInterval(long t) {
        timeInterval = t;
    }

    private static synchronized void createDateBuffer(long tt) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(tt);
        int yyyy = cal.get(1);
        int y = yyyy - 2000;
        int y1 = (y & 0xF0) >>> 4;
        int y2 = y & 0xF;
        int m = cal.get(2) + 1;
        int d = cal.get(5);
        dateBuffer = new byte[4];
        UUIDGenerator.dateBuffer[0] = ALPHABET[y1];
        UUIDGenerator.dateBuffer[1] = ALPHABET[y2];
        UUIDGenerator.dateBuffer[2] = ALPHABET[m];
        UUIDGenerator.dateBuffer[3] = ALPHABET[d];
        currDate = String.valueOf(yyyy * 10000 + m * 100 + d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUUID() {
        byte[] uuid = new byte[16];
        long tt = System.currentTimeMillis() - timeInterval;
        long dd = tt / 86400000L;
        int ss = (int)(tt % 86400000L);
        if (dateCount != dd) {
            UUIDGenerator.createDateBuffer(tt);
        }
        System.arraycopy(dateBuffer, 0, uuid, 0, 4);
        int d1 = ss >>> 25;
        int d2 = ss >>> 20 & 0x1F;
        int d3 = ss >>> 15 & 0x1F;
        int d4 = ss >>> 10 & 0x1F;
        int d5 = ss >>> 5 & 0x1F;
        int d6 = ss & 0x1F;
        uuid[4] = ALPHABET[d1];
        uuid[5] = ALPHABET[d2];
        uuid[6] = ALPHABET[d3];
        uuid[7] = ALPHABET[d4];
        uuid[8] = ALPHABET[d5];
        uuid[9] = ALPHABET[d6];
        uuid[10] = hostCode1;
        uuid[11] = hostCode2;
        Class<UUIDGenerator> clazz = UUIDGenerator.class;
        synchronized (UUIDGenerator.class) {
            if (counter < 1) {
                counter = 1;
            }
            short s = counter;
            counter = (short)(s + 1);
            short c = s;
            // ** MonitorExit[var13_10] (shouldn't be in output)
            int c1 = c >> 12 & 0xF;
            int c2 = c >> 8 & 0xF;
            int c3 = c >> 4 & 0xF;
            int c4 = c & 0xF;
            uuid[12] = ALPHABET[c1];
            uuid[13] = ALPHABET[c2];
            uuid[14] = ALPHABET[c3];
            uuid[15] = ALPHABET[c4];
            return new String(uuid);
        }
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis() - timeInterval;
    }

    public static String currentDate() {
        long tt = System.currentTimeMillis() - timeInterval;
        long dd = tt / 86400000L;
        if (dateCount != dd) {
            UUIDGenerator.createDateBuffer(tt);
        }
        return currDate;
    }

    public static String currentTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis() - timeInterval);
        long val = (long)(cal.get(11) * 10000) + (long)cal.get(12) * 100L + (long)cal.get(13);
        String str = String.valueOf(val);
        if (val < 100000L) {
            return "000000".substring(str.length()) + str;
        }
        return str;
    }

    public static String currentDateTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis() - timeInterval);
        long val = (long)(cal.get(1) * 10000) + (long)(cal.get(2) + 1) * 100L + (long)cal.get(5);
        long val1 = (long)(cal.get(11) * 10000) + (long)cal.get(12) * 100L + (long)cal.get(13);
        String str = String.valueOf(val1);
        if (val1 < 100000L) {
            return val + "000000".substring(str.length()) + str;
        }
        return val + str;
    }

    public UUIDGenerator() {
        this.init();
    }

    private void init() {
        try {
            InetAddress inet = InetAddress.getLocalHost();
            byte[] bytes = inet.getAddress();
            String hexInetAddress = this.hexFormat(this.getInt(bytes), 8);
            String thisHashCode = this.hexFormat(System.identityHashCode(this), 8);
            midValue = hexInetAddress + thisHashCode;
            seeder = new SecureRandom();
            seeder.nextInt();
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return this.padHex(s, j) + s;
    }

    private String padHex(String s, int i) {
        StringBuilder stringbuffer = new StringBuilder();
        if (s.length() < i) {
            for (int j = 0; j < i - s.length(); ++j) {
                stringbuffer.append("0");
            }
        }
        return stringbuffer.toString();
    }

    private int getInt(byte[] abyte0) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = abyte0[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    public static String getUUID32() {
        String sRet = null;
        try {
            long timeNow = System.currentTimeMillis();
            int timeLow = (int)timeNow & 0xFFFFFFFF;
            int node = seeder.nextInt();
            sRet = key.hexFormat(timeLow, 8) + midValue + key.hexFormat(node, 8);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return sRet;
    }

    static {
        byte[] addr;
        ALPHABET = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
        log = CtpLogFactory.getLog(UUIDGenerator.class);
        hostId = 1;
        hostCode1 = ALPHABET[hostId >>> 4 & 0xF];
        hostCode2 = ALPHABET[hostId & 0xF];
        emptyIP = new byte[]{0, 0, 0, 0};
        try {
            addr = InetAddress.getLocalHost().getAddress();
        }
        catch (Exception e) {
            addr = emptyIP;
        }
        IP = addr;
        counter = 1;
        dateCount = 0L;
        dateBuffer = null;
        timeInterval = 0L;
        currDate = null;
        key = new UUIDGenerator();
    }
}

