/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.annotation;

import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.AnnotationFactory;
import com.seeyon.ctp.util.annotation.AnnotationUtils;
import com.seeyon.ctp.util.annotation.ClassAnnotation;
import com.seeyon.ctp.util.annotation.FieldAnnotation;
import com.seeyon.ctp.util.annotation.MethodAnnotation;
import com.seeyon.ctp.util.annotation.ParameterAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AnnotationHandler
extends AbstractSystemInitializer
implements BeanFactoryAware,
ApplicationContextAware,
AnnotationFactory {
    private static final String COM_SEEYON_CTP_UTIL_ANNOTATION = "com.seeyon.ctp.util.annotation";
    private static final Log log = CtpLogFactory.getLog(AnnotationHandler.class);
    private boolean inited = false;
    private BeanDefinitionRegistry beanFactory;
    private ApplicationContext applicationContext;
    private Set<Class<? extends Annotation>> annotationTypes = new HashSet<Class<? extends Annotation>>();
    private Map<Class<? extends Annotation>, Set<ClassAnnotation>> classAnnotations = new HashMap<Class<? extends Annotation>, Set<ClassAnnotation>>();
    private Map<Class<? extends Annotation>, Set<MethodAnnotation>> methodAnnotations = new HashMap<Class<? extends Annotation>, Set<MethodAnnotation>>();
    private Map<Class<? extends Annotation>, Set<ParameterAnnotation>> parameterAnnotations = new HashMap<Class<? extends Annotation>, Set<ParameterAnnotation>>();
    private Map<Class<? extends Annotation>, Set<FieldAnnotation>> fieldAnnotations = new HashMap<Class<? extends Annotation>, Set<FieldAnnotation>>();

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (BeanDefinitionRegistry)beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setAnnotationTypes(String[] annotationTypes) {
        for (String annotation : annotationTypes) {
            try {
                Class<?> c = Class.forName(annotation);
                this.annotationTypes.add(c);
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    public void init() {
        if (this.annotationTypes.isEmpty()) {
            return;
        }
        log.debug((Object)"\u5f00\u59cb\u626b\u63cfAnnotation");
        String[] beanDefinitionNames = this.applicationContext.getBeanDefinitionNames();
        if (beanDefinitionNames != null && beanDefinitionNames.length > 0) {
            for (String beanName : beanDefinitionNames) {
                AbstractBeanDefinition beanDefinition = (AbstractBeanDefinition)this.beanFactory.getBeanDefinition(beanName);
                if (beanDefinition.isAbstract()) continue;
                Class clazz = AopProxyUtils.ultimateTargetClass((Object)this.applicationContext.getBean(beanName));
                Annotation[] annotationsClass = AnnotationUtils.getAnnotations(clazz);
                this.handleClassAnnotation(beanName, clazz, annotationsClass);
                Field[] fields = clazz.getDeclaredFields();
                if (fields != null) {
                    for (Field field : fields) {
                        Annotation[] annotations = field.getAnnotations();
                        for (Annotation annotation : annotations) {
                            Class<? extends Annotation> annotationType = annotation.annotationType();
                            if (!this.annotationTypes.contains(annotationType)) continue;
                            Set<FieldAnnotation> c = this.fieldAnnotations.get(annotationType);
                            if (c == null) {
                                c = new HashSet<FieldAnnotation>();
                                this.fieldAnnotations.put(annotationType, c);
                            }
                            c.add(new FieldAnnotation(clazz, beanName, field, annotation));
                        }
                    }
                }
                Method[] methods = null;
                try {
                    methods = clazz.getMethods();
                }
                catch (NoClassDefFoundError e) {
                    log.warn((Object)("***** No class found:" + e.getMessage()));
                }
                if (methods == null) continue;
                for (Method method : methods) {
                    if (Strings.in(method.getName(), "wait", "toString", "getClass", "clone", "hashCode", "equals", "indexOf", "newInstance", "getTargetClass", "getTargetSource", "addAdvisor", "setTargetSource", "isProxyTargetClass", "setExposeProxy", "isExposeProxy")) continue;
                    for (Class clazz2 : this.annotationTypes) {
                        Object annotation = method.getAnnotation(clazz2);
                        annotation = annotation == null ? org.springframework.core.annotation.AnnotationUtils.findAnnotation((Method)method, (Class)clazz2) : annotation;
                        if (annotation == null) continue;
                        Set<MethodAnnotation> c = this.methodAnnotations.get(clazz2);
                        if (c == null) {
                            c = new HashSet<MethodAnnotation>();
                            this.methodAnnotations.put(clazz2, c);
                        }
                        c.add(new MethodAnnotation(clazz, beanName, method, (Annotation)annotation));
                    }
                    this.handleParameterAnnotations(clazz, beanName, method);
                }
            }
        }
        log.debug((Object)"\u7ed3\u675f\u626b\u63cfAnnotation");
        this.inited = true;
    }

    private void handleParameterAnnotations(Class<?> clazz, String beanName, Method method) {
        Annotation[][] pAnnotations = method.getParameterAnnotations();
        Class<?>[] parameterTypes = method.getParameterTypes();
        int i = 0;
        for (Annotation[] annotations : pAnnotations) {
            Class<?> parameterType = parameterTypes[i++];
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationType;
                if (annotation == null || !(annotationType = annotation.annotationType()).getName().startsWith(COM_SEEYON_CTP_UTIL_ANNOTATION)) continue;
                Set<ParameterAnnotation> c = this.parameterAnnotations.get(annotationType);
                if (c == null) {
                    c = new HashSet<ParameterAnnotation>();
                    this.parameterAnnotations.put(annotationType, c);
                }
                c.add(new ParameterAnnotation(clazz, beanName, method, null, annotation));
            }
        }
    }

    private void handleMethodAnnotation(String beanName, Class<?> clazz, Method method, Annotation[] annotations) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!this.annotationTypes.contains(annotation.annotationType())) continue;
                Set<MethodAnnotation> c = this.methodAnnotations.get(annotation.annotationType());
                if (c == null) {
                    c = new HashSet<MethodAnnotation>();
                    this.methodAnnotations.put(annotation.annotationType(), c);
                }
                c.add(new MethodAnnotation(clazz, beanName, method, annotation));
            }
        }
    }

    private void handleClassAnnotation(String beanName, Class<?> clazz, Annotation[] annotationsClass) {
        if (annotationsClass != null && annotationsClass.length > 0) {
            for (Annotation annotation : annotationsClass) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!this.annotationTypes.contains(annotationType) && !annotationType.getName().startsWith(COM_SEEYON_CTP_UTIL_ANNOTATION)) continue;
                Set<ClassAnnotation> s = this.classAnnotations.get(annotationType);
                if (s == null) {
                    s = new HashSet<ClassAnnotation>();
                    this.classAnnotations.put(annotationType, s);
                }
                s.add(new ClassAnnotation(clazz, beanName, annotation));
            }
        }
    }

    @Override
    public Set<ClassAnnotation> getAnnotationOfClass(Class<? extends Annotation> annotationType) {
        if (!this.inited) {
            return null;
        }
        return this.classAnnotations.get(annotationType);
    }

    @Override
    public Set<MethodAnnotation> getAnnotationOfMethod(Class<? extends Annotation> annotationType) {
        if (!this.inited) {
            return null;
        }
        return this.methodAnnotations.get(annotationType);
    }

    @Override
    public Set<ParameterAnnotation> getAnnotationOfParameter(Class<? extends Annotation> annotationType) {
        if (!this.inited) {
            return null;
        }
        return this.parameterAnnotations.get(annotationType);
    }

    @Override
    public Set<FieldAnnotation> getAnnotationOfField(Class<? extends Annotation> annotationType) {
        if (!this.inited) {
            return null;
        }
        return this.fieldAnnotations.get(annotationType);
    }

    @Override
    public Set<Class<? extends Annotation>> getAllAnnotationTypes() {
        return this.annotationTypes;
    }

    @Override
    public Map<Class<? extends Annotation>, Set<ClassAnnotation>> getAllAnnotationOfClass() {
        return this.classAnnotations;
    }

    @Override
    public Map<Class<? extends Annotation>, Set<MethodAnnotation>> getAllAnnotationOfMethod() {
        return this.methodAnnotations;
    }

    @Override
    public Map<Class<? extends Annotation>, Set<FieldAnnotation>> getAllAnnotationOfField() {
        return this.fieldAnnotations;
    }

    @Override
    public Map<Class<? extends Annotation>, Set<ParameterAnnotation>> getAllAnnotationOfParameter() {
        return this.parameterAnnotations;
    }

    @Override
    public int getSortOrder() {
        return -10;
    }

    @Override
    public void initialize() {
        this.init();
    }
}

