/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.array;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.apache.commons.logging.Log;

public abstract class ArrayBase<T>
implements RandomAccess,
Serializable,
Cloneable,
Iterator<T>,
Iterable<T> {
    private static final long serialVersionUID = -1654378256239103441L;
    private static final Log log = CtpLogFactory.getLog(ArrayBase.class);
    private static final int CAPACITY = 20;
    protected int size = 0;
    protected transient T[] elements = this.makeArray(20);
    protected int pos = 0;

    protected abstract T[] makeArray(int var1);

    public T[] toArray() {
        T[] result = this.makeArray(this.size);
        System.arraycopy(this.elements, 0, result, 0, this.size);
        return result;
    }

    public T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = this.makeArray(this.size);
        }
        System.arraycopy(this.elements, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public T get(int index) {
        this.rangeCheck(index);
        return this.elements[index];
    }

    public T set(int index, T element) {
        this.rangeCheck(index);
        T oldValue = this.elements[index];
        this.elements[index] = element;
        return oldValue;
    }

    public boolean add(T record) {
        this.ensureCapacity(this.size + 1);
        this.elements[this.size++] = record;
        return true;
    }

    public boolean add(T[] record) {
        int num = record.length;
        this.ensureCapacity(this.size + num);
        System.arraycopy(record, 0, this.elements, this.size, num);
        this.size += num;
        return num != 0;
    }

    public void add(int index, T record) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("\u8bb0\u5f55\u8d8a\u754c\uff0c\u8bb0\u5f55\u6570\u91cf[" + String.valueOf(this.size) + "]\uff0c\u589e\u52a0\u7684\u8bb0\u5f55\u7f16\u53f7\uff1a" + String.valueOf(index));
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = record;
        ++this.size;
    }

    public T remove(int index) {
        this.rangeCheck(index);
        T oldValue = this.elements[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, numMoved);
        }
        this.elements[--this.size] = null;
        return oldValue;
    }

    public void remove(T record) {
        if (record == null) {
            return;
        }
        for (int ii = 0; ii < this.size; ++ii) {
            if (!record.equals(this.elements[ii])) continue;
            this.remove(ii);
            break;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(T elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(T elem) {
        if (elem == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!elem.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(T elem) {
        if (elem == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!elem.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elements, toIndex, this.elements, fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.elements[--this.size] = null;
        }
    }

    public void trimToSize() {
        int oldCapacity = this.elements.length;
        if (this.size < oldCapacity) {
            T[] oldData = this.elements;
            this.elements = this.makeArray(this.size);
            System.arraycopy(oldData, 0, this.elements, 0, this.size);
        }
    }

    public Object clone() {
        try {
            ArrayBase v = (ArrayBase)super.clone();
            v.elements = this.makeArray(this.size);
            System.arraycopy(this.elements, 0, v.elements, 0, this.size);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elements[i] = null;
        }
        this.size = 0;
    }

    protected void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("\u8bb0\u5f55\u8d8a\u754c\uff0c\u8bb0\u5f55\u6570\u91cf[" + String.valueOf(this.size) + "]\uff0c\u53d6\u8bb0\u5f55\u7684\u7f16\u53f7\uff1a" + String.valueOf(index));
        }
    }

    protected void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (minCapacity > oldCapacity) {
            T[] oldData = this.elements;
            int newCapacity = oldCapacity + 20;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            try {
                this.elements = this.makeArray(newCapacity);
                System.arraycopy(oldData, 0, this.elements, 0, this.size);
            }
            catch (RuntimeException e) {
                log.error((Object)("array error:" + oldCapacity + "," + minCapacity + "," + newCapacity + "," + this.size));
                throw e;
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.elements.length);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.elements = this.makeArray(arrayLength);
        for (int i = 0; i < this.size; ++i) {
            this.elements[i] = s.readObject();
        }
    }

    public void setPosition(int pos) {
        this.pos = pos >= 0 && pos < this.size ? pos : 0;
    }

    @Override
    public T next() {
        if (this.pos >= this.size) {
            throw new NoSuchElementException("\u4e0b\u6807\u8d8a\u754c: " + this.pos + " / " + this.size);
        }
        return this.elements[this.pos++];
    }

    @Override
    public boolean hasNext() {
        if (this.pos < this.size) {
            return true;
        }
        this.pos = 0;
        return false;
    }

    @Override
    public void remove() {
        if (this.pos >= this.size) {
            throw new NoSuchElementException("\u4e0b\u6807\u8d8a\u754c: " + this.pos + " / " + this.size);
        }
        this.remove(this.pos);
    }

    @Override
    public Iterator<T> iterator() {
        this.pos = 0;
        return this;
    }
}

