/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper.helper.impl;

import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.SimpleMapperHelper;
import com.seeyon.ctp.util.json.model.JSONInteger;
import com.seeyon.ctp.util.json.model.JSONString;
import com.seeyon.ctp.util.json.model.JSONValue;
import java.math.BigInteger;

public class ByteMapper
implements SimpleMapperHelper {
    @Override
    public Class getHelpedClass() {
        return Byte.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (aValue.isString()) {
            try {
                return Byte.valueOf(((JSONString)aValue).getValue());
            }
            catch (NumberFormatException e) {
                throw new MapperException("ByteMapper cannot map value: " + ((JSONString)aValue).getValue());
            }
        }
        if (aValue.isInteger()) {
            return new Byte((byte)((JSONInteger)aValue).getValue().intValue());
        }
        throw new MapperException("ByteMapper cannot map: " + aValue.getClass().getName());
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        if (!Byte.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("ByteMapper cannot map: " + aPojo.getClass().getName());
        }
        return new JSONInteger(new BigInteger(aPojo.toString()));
    }
}

