/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper.helper.impl;

import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.SimpleMapperHelper;
import com.seeyon.ctp.util.json.model.JSONDecimal;
import com.seeyon.ctp.util.json.model.JSONString;
import com.seeyon.ctp.util.json.model.JSONValue;
import java.math.BigDecimal;

public class DoubleMapper
implements SimpleMapperHelper {
    @Override
    public Class getHelpedClass() {
        return Double.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (aValue.isString()) {
            try {
                return Double.valueOf(((JSONString)aValue).getValue());
            }
            catch (NumberFormatException e) {
                throw new MapperException("DoubleMapper cannot map value: " + ((JSONString)aValue).getValue());
            }
        }
        if (aValue.isDecimal()) {
            return new Double(((JSONDecimal)aValue).getValue().doubleValue());
        }
        throw new MapperException("DoubleMapper cannot map: " + aValue.getClass().getName());
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        if (!Double.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("DoubleMapper cannot map: " + aPojo.getClass().getName());
        }
        return new JSONDecimal(new BigDecimal(aPojo.toString()));
    }
}

