/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper.helper.impl;

import com.seeyon.ctp.util.ClassUtil;
import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.SimpleMapperHelper;
import com.seeyon.ctp.util.json.model.JSONInteger;
import com.seeyon.ctp.util.json.model.JSONString;
import com.seeyon.ctp.util.json.model.JSONValue;
import java.math.BigInteger;

public class IntegerMapper
implements SimpleMapperHelper {
    @Override
    public Class getHelpedClass() {
        return Integer.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (aValue.isString()) {
            try {
                return ClassUtil.toInteger(((JSONString)aValue).getValue());
            }
            catch (NumberFormatException e) {
                throw new MapperException("IntegerMapper cannot map value: " + ((JSONString)aValue).getValue());
            }
        }
        if (aValue.isInteger()) {
            return new Integer(((JSONInteger)aValue).getValue().intValue());
        }
        throw new MapperException("IntegerMapper cannot map: " + aValue.getClass().getName());
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        if (!Integer.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("IntegerMapper cannot map: " + aPojo.getClass().getName());
        }
        return new JSONInteger(new BigInteger(aPojo.toString()));
    }
}

