/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper.helper.impl;

import com.seeyon.ctp.util.json.mapper.JSONMapper;
import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.SimpleMapperHelper;
import com.seeyon.ctp.util.json.model.JSONObject;
import com.seeyon.ctp.util.json.model.JSONValue;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapMapper
implements SimpleMapperHelper {
    @Override
    public Class getHelpedClass() {
        return Map.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRawClass) throws MapperException {
        LinkedHashMap<String, Object> lMapObj;
        if (!aValue.isObject()) {
            throw new MapperException("MapMapper cannot map: " + aValue.getClass().getName());
        }
        if (!Map.class.isAssignableFrom(aRawClass)) {
            throw new MapperException("MapMapper cannot map: " + aValue.getClass().getName());
        }
        JSONObject aObject = (JSONObject)aValue;
        try {
            lMapObj = (LinkedHashMap<String, Object>)aRawClass.newInstance();
        }
        catch (Exception e) {
            lMapObj = new LinkedHashMap<String, Object>();
        }
        for (String lKey : aObject.getValue().keySet()) {
            JSONValue lVal = (JSONValue)aObject.getValue().get(lKey);
            lMapObj.put(lKey, JSONMapper.toJava(lVal));
        }
        return lMapObj;
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        JSONObject lObj = new JSONObject();
        if (!Map.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("MapMapper cannot map: " + aPojo.getClass().getName());
        }
        Map lMap = (Map)aPojo;
        for (Object lKey : lMap.keySet()) {
            lObj.getValue().put(lKey.toString(), JSONMapper.toJSON(lMap.get(lKey)));
        }
        return lObj;
    }
}

