/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper.helper.impl;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.json.mapper.JSONMapper;
import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.SimpleMapperHelper;
import com.seeyon.ctp.util.json.mapper.helper.impl.MapMapper;
import com.seeyon.ctp.util.json.model.JSONObject;
import com.seeyon.ctp.util.json.model.JSONValue;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;

public class ObjectMapper
implements SimpleMapperHelper {
    private static final Log LOGGER = CtpLogFactory.getLog(ObjectMapper.class);
    private static final SimpleMapperHelper lHelperSimple = new MapMapper();

    @Override
    public Class getHelpedClass() {
        return Object.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (!aValue.isObject()) {
            throw new MapperException("ObjectMapper cannot map: " + aValue.getClass().getName());
        }
        JSONObject aObject = (JSONObject)aValue;
        try {
            if (aRequestedClass == Object.class) {
                return lHelperSimple.toJava(aValue, LinkedHashMap.class);
            }
            Object lBean = aRequestedClass.newInstance();
            for (String lPropname : aObject.getValue().keySet()) {
                JSONValue lSubEl = aObject.get(lPropname);
                boolean lFoundWriter = false;
                PropertyDescriptor[] lPropDesc = Introspector.getBeanInfo(aRequestedClass, 1).getPropertyDescriptors();
                for (int i = 0; i < lPropDesc.length; ++i) {
                    PropertyDescriptor aLPropDesc = lPropDesc[i];
                    if (!aLPropDesc.getName().equals(lPropname)) continue;
                    Method lWriter = aLPropDesc.getWriteMethod();
                    if (lWriter == null) break;
                    lFoundWriter = true;
                    Type[] types = lWriter.getGenericParameterTypes();
                    Class type = aLPropDesc.getPropertyType();
                    boolean assignableFromCollection = type.isAssignableFrom(List.class);
                    if (!assignableFromCollection) {
                        assignableFromCollection = type.isAssignableFrom(Set.class);
                    }
                    if (assignableFromCollection && types.length > 0 && types[0] instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)types[0];
                        Class pc = (Class)pt.getActualTypeArguments()[0];
                        JSONMapper.setParameterizedTypeLocal(pc);
                    }
                    Object lProp = JSONMapper.toJava(lSubEl, type);
                    lWriter.invoke(lBean, lProp);
                    JSONMapper.setParameterizedTypeLocal(null);
                    break;
                }
                if (lFoundWriter || !LOGGER.isDebugEnabled()) continue;
                String lMsg = "**** Could not find a setter for prop: " + lPropname + " in class: " + aRequestedClass + ", ignored!";
                LOGGER.debug((Object)lMsg);
            }
            return lBean;
        }
        catch (IllegalAccessException e) {
            String lMsg = "IllegalAccessException while trying to instantiate bean: " + aRequestedClass;
            throw new MapperException(lMsg);
        }
        catch (InstantiationException e) {
            String lMsg = "InstantiationException while trying to instantiate bean: " + aRequestedClass;
            throw new MapperException(lMsg);
        }
        catch (IntrospectionException e) {
            String lMsg = "IntrospectionException while trying to fill bean: " + aRequestedClass;
            throw new MapperException(lMsg);
        }
        catch (InvocationTargetException e) {
            String lMsg = "InvocationTargetException while trying to fill bean: " + aRequestedClass;
            throw new MapperException(lMsg);
        }
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        JSONObject lElements = new JSONObject();
        String lastMethodName = null;
        for (Class<?> lClass = aPojo.getClass(); lClass != Object.class; lClass = lClass.getSuperclass()) {
            try {
                Method[] methods = lClass.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    String key;
                    Method m = methods[i];
                    String methodName = m.getName();
                    boolean isGet = methodName.startsWith("get");
                    if (!isGet && !methodName.startsWith("is") || m.getParameterTypes().length != 0 || m.getModifiers() != 1) continue;
                    if (isGet) {
                        key = String.valueOf(Character.toLowerCase(methodName.charAt(3)));
                        if (methodName.length() > 4) {
                            key = key + methodName.substring(4);
                        }
                    } else {
                        key = String.valueOf(Character.toLowerCase(methodName.charAt(2)));
                        if (methodName.length() > 3) {
                            key = key + methodName.substring(3);
                        }
                    }
                    lastMethodName = methodName;
                    Object valueObj = m.invoke(aPojo, new Object[0]);
                    lElements.getValue().put(key, JSONMapper.toJSON(valueObj));
                }
                continue;
            }
            catch (Exception e) {
                LOGGER.warn((Object)(aPojo.toString() + "." + lastMethodName + " " + e.getLocalizedMessage()), (Throwable)e);
                lClass = lClass.getSuperclass();
            }
        }
        return lElements;
    }
}

