/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.model;

import com.seeyon.ctp.util.json.model.JSONNumber;
import java.math.BigDecimal;

public class JSONDecimal
extends JSONNumber {
    private BigDecimal value;

    public JSONDecimal(BigDecimal value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public String toString() {
        return "JSONDecimal(" + this.getLine() + ":" + this.getCol() + ")[" + this.value.toString() + "]";
    }

    @Override
    protected String render(boolean pretty, String indent) {
        if (pretty) {
            return indent + this.value;
        }
        return "" + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONDecimal that = (JSONDecimal)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Object strip() {
        return this.value.toString();
    }
}

