/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.patterns.NamePattern;
import org.aspectj.weaver.reflect.ReflectionWorld;
import org.aspectj.weaver.tools.ContextBasedMatcher;
import org.aspectj.weaver.tools.FuzzyBoolean;
import org.aspectj.weaver.tools.MatchingContext;
import org.aspectj.weaver.tools.PointcutDesignatorHandler;
import org.aspectj.weaver.tools.PointcutExpression;
import org.aspectj.weaver.tools.PointcutParameter;
import org.aspectj.weaver.tools.PointcutParser;
import org.aspectj.weaver.tools.PointcutPrimitive;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.aspectj.BeanNameBlacklist;
import org.springframework.aop.aspectj.BeanTypeBlacklist;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CTPAspectJExpressionPointcut
extends AspectJExpressionPointcut {
    private static final long serialVersionUID = -5293395222366548336L;
    private static final Set<PointcutPrimitive> SUPPORTED_PRIMITIVES = new HashSet<PointcutPrimitive>();
    private static final Log logger;
    private Class<?> pointcutDeclarationScope;
    private String[] pointcutParameterNames = new String[0];
    private Class<?>[] pointcutParameterTypes = new Class[0];
    private BeanFactory beanFactory;
    private transient ClassLoader pointcutClassLoader;
    private transient PointcutExpression pointcutExpression;

    public CTPAspectJExpressionPointcut() {
    }

    public CTPAspectJExpressionPointcut(Class<?> declarationScope, String[] paramNames, Class<?>[] paramTypes) {
        this.pointcutDeclarationScope = declarationScope;
        if (paramNames.length != paramTypes.length) {
            throw new IllegalStateException("Number of pointcut parameter names must match number of pointcut parameter types");
        }
        this.pointcutParameterNames = paramNames;
        this.pointcutParameterTypes = paramTypes;
    }

    public void setPointcutDeclarationScope(Class<?> pointcutDeclarationScope) {
        this.pointcutDeclarationScope = pointcutDeclarationScope;
    }

    public void setParameterNames(String ... names) {
        this.pointcutParameterNames = names;
    }

    public void setParameterTypes(Class<?> ... types) {
        this.pointcutParameterTypes = types;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ClassFilter getClassFilter() {
        this.checkReadyToMatch();
        return this;
    }

    public MethodMatcher getMethodMatcher() {
        this.checkReadyToMatch();
        return this;
    }

    private void checkReadyToMatch() {
        if (this.getExpression() == null) {
            throw new IllegalStateException("Must set property 'expression' before attempting to match");
        }
        if (this.pointcutExpression == null) {
            this.pointcutClassLoader = this.beanFactory instanceof ConfigurableBeanFactory ? ((ConfigurableBeanFactory)this.beanFactory).getBeanClassLoader() : ClassUtils.getDefaultClassLoader();
            this.pointcutExpression = this.buildPointcutExpression(this.pointcutClassLoader);
        }
    }

    private PointcutExpression buildPointcutExpression(ClassLoader classLoader) {
        PointcutParser parser = this.initializePointcutParser(classLoader);
        PointcutParameter[] pointcutParameters = new PointcutParameter[this.pointcutParameterNames.length];
        for (int i = 0; i < pointcutParameters.length; ++i) {
            pointcutParameters[i] = parser.createPointcutParameter(this.pointcutParameterNames[i], this.pointcutParameterTypes[i]);
        }
        return parser.parsePointcutExpression(this.replaceBooleanOperators(this.getExpression()), this.pointcutDeclarationScope, pointcutParameters);
    }

    private PointcutParser initializePointcutParser(ClassLoader cl) {
        PointcutParser parser = PointcutParser.getPointcutParserSupportingSpecifiedPrimitivesAndUsingSpecifiedClassLoaderForResolution(SUPPORTED_PRIMITIVES, (ClassLoader)cl);
        parser.registerPointcutDesignatorHandler((PointcutDesignatorHandler)new BeanNamePointcutDesignatorHandler());
        return parser;
    }

    private String replaceBooleanOperators(String pcExpr) {
        String result = StringUtils.replace((String)pcExpr, (String)" and ", (String)" && ");
        result = StringUtils.replace((String)result, (String)" or ", (String)" || ");
        result = StringUtils.replace((String)result, (String)" not ", (String)" ! ");
        return result;
    }

    public PointcutExpression getPointcutExpression() {
        this.checkReadyToMatch();
        return this.pointcutExpression;
    }

    public boolean matches(Class<?> targetClass) {
        this.checkReadyToMatch();
        try {
            try {
                return this.pointcutExpression.couldMatchJoinPointsInType(targetClass);
            }
            catch (ReflectionWorld.ReflectionWorldException ex) {
                logger.debug((Object)"PointcutExpression matching rejected target class - trying fallback expression", (Throwable)ex);
                PointcutExpression fallbackExpression = this.getFallbackPointcutExpression(targetClass);
                if (fallbackExpression != null) {
                    return fallbackExpression.couldMatchJoinPointsInType(targetClass);
                }
            }
        }
        catch (BCException ex) {
            logger.debug((Object)"PointcutExpression matching rejected target class", (Throwable)ex);
        }
        return false;
    }

    public boolean matches(Method method, Class<?> targetClass) {
        return this.matches(method, targetClass, false);
    }

    private PointcutExpression getFallbackPointcutExpression(Class<?> targetClass) {
        try {
            ClassLoader classLoader = targetClass.getClassLoader();
            if (classLoader != null && classLoader != this.pointcutClassLoader) {
                return this.buildPointcutExpression(classLoader);
            }
        }
        catch (Throwable ex) {
            logger.debug((Object)"Failed to create fallback PointcutExpression", ex);
        }
        return null;
    }

    static {
        SUPPORTED_PRIMITIVES.add(PointcutPrimitive.EXECUTION);
        SUPPORTED_PRIMITIVES.add(PointcutPrimitive.ARGS);
        SUPPORTED_PRIMITIVES.add(PointcutPrimitive.REFERENCE);
        SUPPORTED_PRIMITIVES.add(PointcutPrimitive.THIS);
        SUPPORTED_PRIMITIVES.add(PointcutPrimitive.TARGET);
        SUPPORTED_PRIMITIVES.add(PointcutPrimitive.WITHIN);
        SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_ANNOTATION);
        SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_WITHIN);
        SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_ARGS);
        SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_TARGET);
        logger = LogFactory.getLog(CTPAspectJExpressionPointcut.class);
    }

    private class BeanNameContextMatcher
    implements ContextBasedMatcher {
        private final NamePattern expressionPattern;

        public BeanNameContextMatcher(String expression) {
            this.expressionPattern = new NamePattern(expression);
        }

        public boolean couldMatchJoinPointsInType(Class someClass) {
            return this.contextMatch(someClass) == FuzzyBoolean.YES;
        }

        public boolean couldMatchJoinPointsInType(Class someClass, MatchingContext context) {
            return this.contextMatch(someClass) == FuzzyBoolean.YES;
        }

        public boolean matchesDynamically(MatchingContext context) {
            return true;
        }

        public FuzzyBoolean matchesStatically(MatchingContext context) {
            return this.contextMatch(null);
        }

        public boolean mayNeedDynamicTest() {
            return false;
        }

        private FuzzyBoolean contextMatch(Class<?> targetType) {
            String advisedBeanName = CTPAspectJExpressionPointcut.this.getCurrentProxiedBeanName();
            if (advisedBeanName == null) {
                return FuzzyBoolean.MAYBE;
            }
            if (BeanFactoryUtils.isGeneratedBeanName((String)advisedBeanName)) {
                return FuzzyBoolean.NO;
            }
            if (targetType != null) {
                if (BeanTypeBlacklist.match(targetType)) {
                    return FuzzyBoolean.NO;
                }
                boolean isFactory = FactoryBean.class.isAssignableFrom(targetType);
                return FuzzyBoolean.fromBoolean((boolean)this.matchesBeanName(isFactory ? "&" + advisedBeanName : advisedBeanName));
            }
            return FuzzyBoolean.fromBoolean((this.matchesBeanName(advisedBeanName) || this.matchesBeanName("&" + advisedBeanName) ? 1 : 0) != 0);
        }

        private boolean matchesBeanName(String advisedBeanName) {
            if (BeanNameBlacklist.match(advisedBeanName)) {
                return false;
            }
            if (this.expressionPattern.matches(advisedBeanName)) {
                return true;
            }
            if (CTPAspectJExpressionPointcut.this.beanFactory != null) {
                String[] aliases;
                for (String alias : aliases = CTPAspectJExpressionPointcut.this.beanFactory.getAliases(advisedBeanName)) {
                    if (!this.expressionPattern.matches(alias)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class BeanNamePointcutDesignatorHandler
    implements PointcutDesignatorHandler {
        private static final String BEAN_DESIGNATOR_NAME = "bean";

        private BeanNamePointcutDesignatorHandler() {
        }

        public String getDesignatorName() {
            return BEAN_DESIGNATOR_NAME;
        }

        public ContextBasedMatcher parse(String expression) {
            return new BeanNameContextMatcher(expression);
        }
    }
}

