/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.config.MessageChannel;
import com.seeyon.ctp.common.config.PlatformConfigUtil;
import com.seeyon.ctp.common.config.PlatformDubboUtil;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.init.MclclzUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.quartz.QuartzHolder;
import com.seeyon.ctp.dubbo.DubboConfigAutoGenerator;
import com.seeyon.ctp.dubbo.DubboServiceContext;
import com.seeyon.ctp.startup.StartupTaskManager;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.IOUtility;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.ModelAndView;

public class CTPDispatcherServlet
extends DispatcherServlet {
    private static final Log LOGGER = CtpLogFactory.getLog("com.seeyon.ctp.common.spring.CTPHandlerInterceptor");
    private static final Class<?> c1 = MclclzUtil.ioiekc((String)"com.seeyon.ctp.common.init.SystemLoader");

    protected void initFrameworkServlet() throws ServletException {
        AppContext.setBeanInjectFinish();
        MclclzUtil.invoke(c1, (String)"initAfterSpring", (Class[])new Class[]{ServletContext.class, ApplicationContext.class}, null, (Object[])new Object[]{this.getServletContext(), this.getWebApplicationContext()});
        if (SystemEnvironment.isDistributedMode()) {
            DubboServiceContext.initialize();
            PlatformConfigUtil.sendMessage(MessageChannel.SYS_START_TIME, String.valueOf(System.currentTimeMillis()));
            if (PlatformConfigUtil.isOtherService(SystemEnvironment.getAppId())) {
                PlatformConfigUtil.sendMessage(MessageChannel.MPLUS_SERVICE_STARTED, String.valueOf(System.currentTimeMillis()));
            }
        }
        SystemEnvironment.setBootFinished(true);
        CacheFactory.resetAllStatistics();
        CacheFactory.enableCacheNotify();
        super.initFrameworkServlet();
        if (AppContext.hasPlugin("weixin")) {
            try {
                String jobName = "weixinUpgradeQuartzJob";
                if (QuartzHolder.hasQuartzJob(jobName)) {
                    QuartzHolder.deleteQuartzJob(jobName);
                }
                QuartzHolder.newQuartzJob(jobName, Datetimes.addMinute(new Date(), 1), "weixinUpgradeQuartzJob", new HashMap<String, String>());
            }
            catch (Exception e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
        }
    }

    public void destroy() {
        MclclzUtil.invoke(c1, (String)"destroy", (Class[])new Class[]{ServletContext.class}, null, (Object[])new Object[]{this.getServletContext()});
        NotificationManager.getInstance().stop();
        super.destroy();
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        String springCfg = (String)MclclzUtil.invoke(c1, (String)"initBeforeSpring", (Class[])new Class[]{ServletContext.class}, null, (Object[])new Object[]{this.getServletContext()});
        StartupTaskManager.getInstance().run();
        if (SystemEnvironment.isDistributedMode()) {
            DubboServiceContext.initBeforeSpring();
        }
        try {
            springCfg = this.filterDubboConfig(springCfg);
        }
        catch (Throwable e) {
            this.logger.error((Object)"\u8fc7\u6ee4Dubbo\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", e);
        }
        if (SystemEnvironment.isDistributedMode()) {
            this.logger.info((Object)"\u81ea\u52a8\u6e05\u7406\u8fc7\u671f\u7684Bubbo\u670d\u52a1\u548c\u6d88\u8d39\u8005\u6ce8\u518c\u4fe1\u606f...");
            PlatformDubboUtil.clearExpiredDubboService();
            this.logger.info((Object)"Bubbo\u670d\u52a1\u548c\u6d88\u8d39\u8005\u6ce8\u518c\u4fe1\u606f\u6e05\u7406\u5b8c\u6210\uff01");
        }
        super.setContextConfigLocation(springCfg);
    }

    private String filterDubboConfig(String springCfg) throws IOException {
        String line;
        if (SystemEnvironment.isDistributedMode()) {
            DubboConfigAutoGenerator.generatorDubboConfigFiles(SystemEnvironment.getSpringConfFolder(), SystemEnvironment.getWebLibFolder());
        }
        StringBuilder sBuilder = new StringBuilder();
        BufferedReader r = new BufferedReader(new StringReader(springCfg));
        while ((line = r.readLine()) != null) {
            if (!SystemEnvironment.isDistributedMode() ? line.contains("spring-dubbo-consumer.xml") || line.contains("spring-dubbo-provider.xml") : line.contains("spring" + File.separator + "serviceBeans.xml")) continue;
            sBuilder.append(line + "\n");
        }
        return sBuilder.toString();
    }

    protected void postProcessWebApplicationContext(ConfigurableWebApplicationContext wac) {
        AppContext.init((ApplicationContext)wac, AppContext.getCfgHome());
    }

    protected ModelAndView processHandlerException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (ex != null) {
            String eid;
            boolean isAlert = false;
            boolean isFullPage = false;
            String message = null;
            String stacktrace = null;
            Throwable tracet = null;
            if (ex instanceof BusinessException) {
                BusinessException ae = (BusinessException)ex;
                Throwable rawCause = ae.getRawCause();
                if (rawCause == null) {
                    ae = ae.getRawBusinessException();
                    message = ae.getMessage();
                    if ("invalid_resource_code".equals(ae.getCode())) {
                        LOGGER.error((Object)message);
                    }
                    isFullPage = ae.isFullPage();
                    isAlert = true;
                } else {
                    tracet = rawCause;
                }
                eid = ae.getCode();
                LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            } else {
                tracet = ex;
                String curm = String.valueOf(System.currentTimeMillis());
                eid = curm.substring(curm.length() - 10);
                LOGGER.error((Object)"JSP Exception", (Throwable)ex);
            }
            if (tracet != null) {
                message = tracet.getClass().getCanonicalName() + ":" + tracet.getMessage();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                tracet.printStackTrace(pw);
                stacktrace = sw.toString();
            }
            request.setAttribute("THROWABLE_ISFULLPAGE", (Object)String.valueOf(isFullPage));
            request.setAttribute("THROWABLE_ISALERT", (Object)String.valueOf(isAlert));
            request.setAttribute("THROWABLE_ID", (Object)eid);
            request.setAttribute("THROWABLE_MESSAGE", (Object)message);
            request.setAttribute("THROWABLE_STACKTRACE", stacktrace);
            String requestFrom = request.getHeader("request-from");
            if (Strings.equals(requestFrom, "m3")) {
                this.m3ProcessHandlerException(response, message, eid);
                return null;
            }
        }
        return super.processHandlerException(request, response, handler, ex);
    }

    private void m3ProcessHandlerException(HttpServletResponse response, String message, String code) {
        response.setStatus(500);
        try {
            ServletOutputStream sos = response.getOutputStream();
            HashMap<String, String> entity = new HashMap<String, String>();
            entity.put("message", message);
            int iCode = 500;
            try {
                iCode = Integer.valueOf(code);
            }
            catch (Exception exception) {
                // empty catch block
            }
            entity.put("code", iCode + "");
            IOUtility.copy(JSONUtil.toJSONString(entity).getBytes("UTF-8"), (OutputStream)sos);
            sos.close();
        }
        catch (Exception e) {
            this.logger.error((Object)"m3 handler exception error:", (Throwable)e);
        }
    }

    public void noHandlerFound(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String serviceName = PlatformConfigUtil.getServiceNameFromUrl(request.getRequestURI());
        if (serviceName == null) {
            super.noHandlerFound(request, response);
        } else {
            response.sendError(418);
            request.setAttribute("HINT_INFO", (Object)(serviceName + " \u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u542f\u52a8\uff1f"));
        }
    }
}

