/*==============================================================*/
/* Table: COL_SUMMARY                                           */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS COL_SUMMARY
(
   ID                   BIGINT NOT NULL,
   STATE                SMALLINT,
   SUBJECT              VARCHAR(1024),
   DEADLINE             BIGINT,
   COL_TYPE             SMALLINT,
   CAN_ARCHIVE          SMALLINT,
   CAN_MODIFY           SMALLINT,
   CAN_DUE_REMINDER     SMALLINT,
   CAN_FORWARD          SMALLINT,
   CAN_EDIT             SMALLINT,
   CAN_TRACK            SMALLINT,
   REMIND_INTERVAL      BIGINT,
   PROJECT_ID           BIGINT,
   IMPORTANT_LEVEL      SMALLINT,
   RESENT_TIME          SMALLINT,
   CREATE_DATE          DATETIME,
   START_DATE           DATETIME,
   FINISH_DATE          DATETIME,
   IS_AUDITED           SMALLINT,
   ARCHIVE_ID           BIGINT,
   START_MEMBER_ID      BIGINT,
   PROCESS_ID           VARCHAR(255),
   CASE_ID              BIGINT,
   ADVANCE_REMIND       BIGINT,
   IDENTIFIER           VARCHAR(255),
   FORWARD_MEMBER       VARCHAR(255),
   TEMPLETE_ID          BIGINT,
   WORKFLOW_RULE        LONGTEXT,
   WEBSERVICE_CODE      VARCHAR(255),
   BODY_TYPE            VARCHAR(255),
   FORM_RECORDID        BIGINT,
   FORMID               BIGINT,
   FORM_APPID           BIGINT,
   ORG_DEPARTMENT_ID    BIGINT,
   ORG_ACCOUNT_ID       BIGINT,
   SOURCE               VARCHAR(255),
   PARENTFORM_SUMMARYID BIGINT,
   NEWFLOW_TYPE         SMALLINT,
   CAN_EDIT_ATTACHMENT  SMALLINT,
   VOUCH                SMALLINT,
   OVER_WORKTIME        BIGINT,
   RUN_WORKTIME         BIGINT,
   OVER_TIME            BIGINT,
   RUN_TIME             BIGINT,
   CAN_AUTOSTOPFLOW     SMALLINT,
   IS_COVER_TIME        SMALLINT,
   DEADLINE_DATETIME    DATETIME,
   CURRENT_NODES_INFO   VARCHAR(255),
   CAN_MERGE_DEAL       SMALLINT,
   ADVANCE_PIGEONHOLE   VARCHAR(4000),
   CAN_ANY_MERGE        SMALLINT,
   PROCESS_NODES_INFO   LONGTEXT,
   PERMISSION_ACCOUNT_ID BIGINT,
   REPLY_COUNTS         SMALLINT,
   AUTO_RUN             SMALLINT,
   ATTACHMENT_ARCHIVE_ID BIGINT,
   PROCESS_TERM_TYPE    SMALLINT,
   MERGE_DEAL_TYPE      VARCHAR(255),
   SUB_STATE            SMALLINT,
   RELATION_ID			BIGINT,
   MESSAGE_RULE_ID		VARCHAR(500),
   CAN_DELETE_NODE SMALLINT,
   NODES_INFO VARCHAR(4000),
   PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: CTP_AFFAIR                                            */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS CTP_AFFAIR
(
   ID                   BIGINT NOT NULL,
   IS_COVER_TIME        SMALLINT,
   MEMBER_ID            BIGINT,
   SENDER_ID            BIGINT,
   SUBJECT              VARCHAR(1024),
   APP                  SMALLINT,
   OBJECT_ID            BIGINT,
   SUB_OBJECT_ID        BIGINT,
   STATE                SMALLINT,
   SUB_STATE            SMALLINT,
   HASTEN_TIMES         SMALLINT,
   REMIND_DATE          BIGINT,
   DEADLINE_DATE        BIGINT,
   CAN_DUE_REMIND       SMALLINT,
   CREATE_DATE          DATETIME,
   RECEIVE_TIME         DATETIME,
   COMPLETE_TIME        DATETIME,
   REMIND_INTERVAL      SMALLINT,
   IS_DELETE            SMALLINT,
   TRACK                SMALLINT,
   ARCHIVE_ID           BIGINT,
   ADDITION             VARCHAR(2000),
   EXT_PROPS            VARCHAR(2000),
   UPDATE_DATE          DATETIME,
   IS_FINISH            SMALLINT,
   BODY_TYPE            VARCHAR(255),
   IMPORTANT_LEVEL      SMALLINT,
   RESENT_TIME          SMALLINT,
   FORWARD_MEMBER       VARCHAR(255),
   IDENTIFIER           VARCHAR(255),
   TRANSACTOR_ID        BIGINT,
   NODE_POLICY          VARCHAR(255),
   ACTIVITY_ID          BIGINT,
   FORM_APP_ID          BIGINT,
   FORM_ID              BIGINT,
   FORM_OPERATION_ID    BIGINT,
   TEMPLETE_ID          BIGINT,
   FROM_ID              BIGINT,
   OVER_WORKTIME        BIGINT,
   RUN_WORKTIME         BIGINT,
   OVER_TIME            BIGINT,
   RUN_TIME             BIGINT,
   DEAL_TERM_TYPE       SMALLINT,
   DEAL_TERM_USERID     BIGINT,
   SUB_APP              SMALLINT,
   EXPECTED_PROCESS_TIME DATETIME,
   ORG_ACCOUNT_ID       BIGINT,
   PROCESS_ID           VARCHAR(255),
   IS_PROCESS_OVER_TIME SMALLINT,
   FORM_MULTI_OPERATION_ID VARCHAR(4000),
   BACK_FROM_ID         BIGINT,
   FORM_RELATIVE_STATIC_IDS VARCHAR(255),
   FORM_RELATIVE_QUERY_IDS VARCHAR(255),
   HAS_FAVORITE         SMALLINT,
   FROM_TYPE            SMALLINT,
   FORM_RECORDID        BIGINT,
   CASE_ID              BIGINT,
   RELATION_DATA_ID     BIGINT,
   FIRSTVIEW_PERIOD     BIGINT,
   FIRSTVIEW_DATE       DATETIME,
   FIRSTRESPONSE_PERIOD BIGINT,
   SIGNLEVIEW_PERIOD    BIGINT,
   PRE_APPROVER         BIGINT,
   AUTO_RUN             SMALLINT,
   SUMMARY_STATE        SMALLINT,
   TOP_TIME             DATETIME,
   SORT_WEIGHT          SMALLINT,
   AI_PROCESSING        SMALLINT,
   PROCESS_DEADLINE_TIME DATETIME,
   PROXY_MEMBER_ID		BIGINT,
   MATCH_DEPARTMENT_ID	BIGINT,
   MATCH_POST_ID   		BIGINT,
   NODE_NAME			VARCHAR(500),
   MATCH_ACCOUNT_ID     BIGINT,
   PRINT_NM				SMALLINT,
   MESSAGE_RULE_ID		VARCHAR(1000),
   MATCH_ROLE_ID BIGINT,
   PRIMARY KEY (ID)
);


/*==============================================================*/
/* Table: CTP_COMMENT_ALL                                       */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS CTP_COMMENT_ALL
(
   ID                   BIGINT NOT NULL,
   CREATE_ID            BIGINT,
   CREATE_DATE          DATETIME,
   MODIFY_DATE          DATETIME,
   MODULE_TYPE          SMALLINT DEFAULT 0,
   MODULE_ID            BIGINT,
   CTYPE                SMALLINT DEFAULT 0,
   CONTENT              LONGTEXT,
   TITLE                VARCHAR(1024),
   IS_HIDDEN            SMALLINT DEFAULT 0,
   SHOW_TO_ID           LONGTEXT,
   PATH                 VARCHAR(500),
   CLEVEL               SMALLINT DEFAULT 0,
   PID                  BIGINT,
   RELATE_INFO          LONGTEXT,
   EXT_ATT1             VARCHAR(100),
   EXT_ATT2             VARCHAR(100),
   EXT_ATT3             VARCHAR(100),
   AFFAIR_ID            BIGINT,
   FORWARD_COUNT        SMALLINT,
   PRAISE_TO_SUMMARY    SMALLINT,
   PRAISE_NUMBER        INT,
   PRAISE_MEMBER_IDS    LONGTEXT,
   RICH_CONTENT         LONGTEXT,
   DEPARTMENT_ID		BIGINT,
   POST_ID				BIGINT,
   ACCOUNT_ID           BIGINT,
   EXT_ATT4 VARCHAR(50),
   MATCH_ROLE_ID BIGINT,
   ACCOUNT_NAME VARCHAR(255),
   DEPARTMENT_NAME VARCHAR(255),
   POST_NAME VARCHAR(255),
   ROLE_NAME VARCHAR(255),
   HAS_WF_OPERATION SMALLINT,
   DEAL_LOCALE VARCHAR(50),
   SUB_TYPE SMALLINT,
   CREATE_NAME VARCHAR(255),
   PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: CTP_CONTENT_ALL                                       */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS CTP_CONTENT_ALL
(
   ID                   BIGINT NOT NULL,
   CREATE_ID            BIGINT,
   CREATE_DATE          DATETIME,
   MODIFY_ID            BIGINT,
   MODIFY_DATE          DATETIME,
   MODULE_TYPE          SMALLINT DEFAULT 0,
   MODULE_ID            BIGINT,
   MODULE_TEMPLATE_ID   BIGINT,
   CONTENT_TYPE         SMALLINT DEFAULT 0,
   CONTENT              LONGTEXT,
   CONTENT_DATA_ID      BIGINT,
   CONTENT_TEMPLATE_ID  BIGINT,
   TITLE                VARCHAR(1024),
   SORT                 SMALLINT DEFAULT 0,
   PRIMARY KEY (ID)
);


/*==============================================================*/
/* Table: CTP_PROCESS_HISTORY_LOG                               */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS CTP_PROCESS_HISTORY_LOG
(
   ID                   BIGINT NOT NULL,
   PROCESS_ID           BIGINT NOT NULL,
   ACTIVITY_ID          BIGINT NOT NULL,
   ACTION_ID            INT NOT NULL,
   ACTION_USER_ID       BIGINT NOT NULL,
   PARAM0                VARCHAR(1024),
   PARAM1                VARCHAR(1024),
   PARAM2                VARCHAR(1024),
   PARAM3                VARCHAR(1024),
   PARAM4                VARCHAR(1024),
   PARAM5                VARCHAR(4000),
   ACTION_TIME          DATETIME,
   ACTION_DESC          VARCHAR(1024),
   COMMENT_ID           BIGINT,
   DETAIL_STATUS        SMALLINT,
   PRIMARY KEY (ID)
);


/*==============================================================*/
/* Table: CTP_PROCESS_LOG                                       */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS CTP_PROCESS_LOG
(
   ID                   BIGINT NOT NULL,
   PROCESS_ID           BIGINT NOT NULL,
   ACTIVITY_ID          BIGINT NOT NULL,
   ACTION_ID            INT NOT NULL,
   ACTION_USER_ID       BIGINT NOT NULL,
   PARAM0                VARCHAR(1024),
   PARAM1                VARCHAR(1024),
   PARAM2                VARCHAR(1024),
   PARAM3                VARCHAR(1024),
   PARAM4                VARCHAR(1024),
   PARAM5                VARCHAR(4000),
   ACTION_TIME          DATETIME,
   ACTION_DESC          VARCHAR(1024),
   COMMENT_ID           BIGINT,
   DETAIL_STATUS        SMALLINT,
   PRIMARY KEY (ID)
);


/*==============================================================*/
/* Table: WF_CASE_HISTORY                                       */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS WF_CASE_HISTORY
(
   ID                   BIGINT NOT NULL,
   CASENAME             VARCHAR(100),
   STARTUSER            VARCHAR(36) NOT NULL,
   LASTPERFORMER        VARCHAR(36),
   STATE                INT NOT NULL,
   SUBPROCESS           INT,
   STARTSUBPROCESSNUM   INT,
   PROCESSINDEX         VARCHAR(110) NOT NULL,
   PROCESSNAME          VARCHAR(100) NOT NULL,
   PROCESSID            VARCHAR(100) NOT NULL,
   STARTDATE            BIGINT NOT NULL,
   UPDATEDATE           BIGINT NOT NULL,
   CASEOBJECT           LONGBLOB,
   CASE_CONTENT         LONGTEXT,
   PRIMARY KEY (ID)
);


/*==============================================================*/
/* Table: WF_CASE_RUN                                           */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS WF_CASE_RUN
(
   ID                   BIGINT NOT NULL,
   CASENAME             VARCHAR(100),
   STARTUSER            VARCHAR(36) NOT NULL,
   LASTPERFORMER        VARCHAR(36),
   STATE                INT NOT NULL,
   SUBPROCESS           INT,
   STARTSUBPROCESSNUM   INT,
   PROCESSINDEX         VARCHAR(110) NOT NULL,
   PROCESSNAME          VARCHAR(100) NOT NULL,
   PROCESSID            VARCHAR(100) NOT NULL,
   STARTDATE            BIGINT NOT NULL,
   UPDATEDATE           BIGINT NOT NULL,
   CASEOBJECT           LONGBLOB,
   CASE_CONTENT         LONGTEXT,
   PRIMARY KEY (ID)
);


/*==============================================================*/
/* Table: WF_PROCESS_RUNNING                                    */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS WF_PROCESS_RUNNING
(
   ID                   VARCHAR(110) NOT NULL,
   TEMPLETE_ID          BIGINT,
   PROCESSOBJECT        LONGBLOB,
   CREATEDATE           BIGINT,
   STATE                SMALLINT DEFAULT 0,
   PROCESS_XML          LONGTEXT,
   PRIMARY KEY (ID)
);


/*==============================================================*/
/* Table: WF_SUBPROCESS_RUNNING                                 */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS WF_SUBPROCESS_RUNNING
(
   ID                   BIGINT NOT NULL,
   SUBJECT              VARCHAR(255),
   NEW_ID               BIGINT,
   MAIN_TEMPLETE_ID     BIGINT,
   MAIN_NODE_ID         VARCHAR(255),
   MAIN_CASE_ID         BIGINT,
   MAIN_PROCESS_ID      VARCHAR(255),
   TRIGGER_CONDITION    LONGTEXT,
   CONDITION_TITLE      LONGTEXT,
   CONDITION_BASE       VARCHAR(255),
   IS_FORCE             SMALLINT,
   FLOW_RELATE_TYPE     SMALLINT,
   CAN_VIEW_BY_MAIN     SMALLINT,
   CAN_VIEW_MAIN        SMALLINT,
   SENDER               VARCHAR(255),
   SENDER_ID            BIGINT,
   TEMPLETE_ID          BIGINT,
   CASE_ID              BIGINT,
   PROCESS_ID           VARCHAR(255),
   CREATE_TIME          DATETIME,
   UPDATE_TIME          DATETIME,
   BUSSINESS_TYPE       VARCHAR(255),
   BUSSINESS_ID         VARCHAR(255),
   IS_FINISHED          SMALLINT,
   IS_ACTIVATE          SMALLINT DEFAULT 0,
   IS_DELETE            SMALLINT DEFAULT 0,
   PRIMARY KEY (ID)
);


/*==============================================================*/
/* Table: WF_WORKITEM_HISTORY                                   */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS WF_WORKITEM_HISTORY
(
   ID                   BIGINT NOT NULL,
   CASEID               BIGINT NOT NULL,
   BATCH                BIGINT NOT NULL,
   ITEMNUM              INT NOT NULL,
   WF_DOMAIN            VARCHAR(100) NOT NULL,
   NAME                 VARCHAR(255) DEFAULT '-',
   CASENAME             VARCHAR(100),
   PROCESSID            VARCHAR(100) NOT NULL,
   PROCESSINDEX         VARCHAR(100) NOT NULL,
   PROCESSNAME          VARCHAR(100),
   ACTIVITYID           VARCHAR(36) NOT NULL,
   ACTIVITYNAME         VARCHAR(255),
   PERFORMER            VARCHAR(255),
   FINISHER             VARCHAR(64),
   OWNER                VARCHAR(64),
   ENTRUSTER            VARCHAR(64),
   DELEGATER            VARCHAR(64),
   LEVELNUM             INT NOT NULL,
   CANREASSIGN          INT NOT NULL,
   CANRETURN            INT NOT NULL,
   CANDELEGATE          INT NOT NULL,
   CANENTRUST           INT NOT NULL,
   CANREVIEW            INT NOT NULL,
   NEXTSTATUS           VARCHAR(36),
   NEXTLINKID           VARCHAR(36),
   DATAMAP              LONGBLOB,
   OLDSTATE             INT,
   STATE                INT NOT NULL,
   CREATEDATE           BIGINT NOT NULL,
   UPDATEDATE           BIGINT NOT NULL,
   DEADLINE             BIGINT,
   ACTIONSTATE          VARCHAR(500),
   SORT                 INT NOT NULL DEFAULT 0,
   PRIMARY KEY (ID)
);


/*==============================================================*/
/* Table: WF_WORKITEM_RUN                                       */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS WF_WORKITEM_RUN
(
   ID                   BIGINT NOT NULL,
   CASEID               BIGINT,
   BATCH                BIGINT,
   ITEMNUM              INT,
   WF_DOMAIN            VARCHAR(100),
   NAME                 VARCHAR(255),
   CASENAME             VARCHAR(100),
   PROCESSID            VARCHAR(100),
   PROCESSINDEX         VARCHAR(100),
   PROCESSNAME          VARCHAR(100),
   ACTIVITYID           VARCHAR(36),
   ACTIVITYNAME         VARCHAR(255),
   PERFORMER            VARCHAR(255),
   FINISHER             VARCHAR(64),
   OWNER                VARCHAR(64),
   ENTRUSTER            VARCHAR(64),
   DELEGATER            VARCHAR(64),
   LEVELNUM             INT,
   CANREASSIGN          INT,
   CANRETURN            INT,
   CANDELEGATE          INT,
   CANENTRUST           INT,
   CANREVIEW            INT,
   NEXTSTATUS           VARCHAR(36),
   NEXTLINKID           VARCHAR(36),
   DATAMAP              LONGBLOB,
   OLDSTATE             INT,
   STATE                INT,
   CREATEDATE           BIGINT,
   UPDATEDATE           BIGINT,
   DEADLINE             BIGINT,
   ACTIONSTATE          VARCHAR(500),
   SORT                 INT DEFAULT 0,
   PRIMARY KEY (ID)
);
CREATE TABLE IF NOT EXISTS CTP_CONFIG
(
   ID                   BIGINT NOT NULL,
   CONFIG_CATEGORY       VARCHAR(100),
   CONFIG_CATEGORY_NAME  VARCHAR(100),
   CONFIG_ITEM           VARCHAR(100),
   CONFIG_VALUE          VARCHAR(1000),
   CONFIG_DESCRIPTION    VARCHAR(255),
   CREATE_DATE          DATETIME,
   MODIFY_DATE          DATETIME,
   CONFIG_TYPE           VARCHAR(100),
   EXT_CONFIG_VALUE      LONGTEXT,
   ORG_ACCOUNT_ID       BIGINT,
   SORT                 INT,
   PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_BODY                                             */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS EDOC_BODY
(
   ID                   BIGINT NOT NULL,
   CONTENT_TYPE         VARCHAR(20) NOT NULL,
   CONTENT              LONGTEXT,
   EDOC_ID              BIGINT,
   CREATE_TIME          DATETIME NOT NULL,
   LAST_UPDATE          DATETIME NOT NULL,
   CONTENT_NAME         VARCHAR(32),
   CONTENT_STATUS       SMALLINT,
   CONTENT_NO           BIGINT DEFAULT 0,
   PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_EXCHANGE_RECIEVE                                 */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS EDOC_EXCHANGE_RECIEVE
(
   ID                   BIGINT NOT NULL,
   SUBJECT              VARCHAR(1024) NOT NULL,
   DOC_TYPE             VARCHAR(255),
   DOC_MARK             VARCHAR(255),
   SECRET_LEVEL         VARCHAR(50),
   URGENT_LEVEL         VARCHAR(50),
   KEEP_PERIOD          VARCHAR(255),
   SEND_UNIT            VARCHAR(255) NOT NULL,
   SENDER               VARCHAR(255),
   ISSUER               VARCHAR(255),
   ISSUE_DATE           DATETIME,
   SEND_TO              LONGTEXT,
   COPY_TO              LONGTEXT,
   REPORT_TO            LONGTEXT,
   EDOC_ID              BIGINT,
   FILE_ID              BIGINT,
   FROM_INTERNAL        NUMERIC(3,0) NOT NULL,
   REPLY_ID             VARCHAR(255),
   REC_NO               VARCHAR(255),
   REC_USER_ID          BIGINT,
   REC_TIME             DATETIME,
   REMARK               VARCHAR(255),
   REGISTER_USER_ID     NUMERIC(19,0),
   REGISTER_TIME        DATETIME,
   EXCHANGE_ORG_ID      NUMERIC(19,0) NOT NULL,
   EXCHANGE_TYPE        NUMERIC(3,0) NOT NULL,
   CREATE_TIME          DATETIME NOT NULL,
   STATUS               NUMERIC(3,0) NOT NULL,
   CONTENT_NO           SMALLINT DEFAULT 0,
   STEPBACKINFO         VARCHAR(4000),
   IS_RETREAT           NUMERIC(3,0),
   SEND_UNIT_TYPE       NUMERIC(3,0),
   RECIVE_EDOC_ID       NUMERIC(19,0),
   IS_TURN_REC          SMALLINT DEFAULT 0,
   EXCHANGE_MODE        SMALLINT DEFAULT 0,
   PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_EXCHANGE_SEND                                    */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS EDOC_EXCHANGE_SEND
(
   ID                   BIGINT NOT NULL,
   SUBJECT              VARCHAR(1024) NOT NULL,
   DOC_TYPE             VARCHAR(255),
   DOC_MARK             VARCHAR(255),
   SECRET_LEVEL         VARCHAR(50),
   URGENT_LEVEL         VARCHAR(50),
   SEND_UNIT            VARCHAR(255) NOT NULL,
   ISSUER               VARCHAR(255),
   ISSUE_DATE           DATETIME,
   COPIES               BIGINT,
   EDOC_ID              BIGINT NOT NULL,
   EXCHANGE_ORG_ID      BIGINT NOT NULL,
   EXCHANGE_TYPE        NUMERIC(3,0) NOT NULL,
   SEND_USER_ID         BIGINT,
   SEND_TIME            DATETIME,
   CREATE_TIME          DATETIME NOT NULL,
   STATUS               NUMERIC(3,0) NOT NULL,
   CONTENT_NO           SMALLINT DEFAULT 0,
   SENDED_TYPEIDS       LONGTEXT,
   STEPBACK_INFO        VARCHAR(1024),
   ASSIGN_TYPE          SMALLINT DEFAULT 0,
   IS_BASE              SMALLINT DEFAULT 0,
   IS_TURN_REC          SMALLINT DEFAULT 0,
   SENDED_NAMES         LONGTEXT,
   EXCHANGE_MODE        SMALLINT DEFAULT 0,
   EXCHANGE_ACCOUNT_ID  BIGINT,
   PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_EXCHANGE_SEND_DETAIL                             */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS EDOC_EXCHANGE_SEND_DETAIL
(
   ID                   BIGINT NOT NULL,
   SEND_EDOC_ID         BIGINT,
   REC_ORG_ID           VARCHAR(255) NOT NULL,
   REC_ORG_TYPE         NUMERIC(3,0) NOT NULL,
   REC_ORG_NAME         VARCHAR(255),
   SEND_TYPE            NUMERIC(3,0) NOT NULL,
   CONTENT              VARCHAR(255),
   REC_NO               VARCHAR(255),
   REC_USER_NAME        VARCHAR(255),
   REC_TIME             DATETIME,
   STATUS               NUMERIC(3,0) NOT NULL,
   CUIBAN_NUM           SMALLINT DEFAULT 0,
   PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_OPINION                                          */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS EDOC_OPINION
(
   ID                   BIGINT NOT NULL,
   EDOC_ID              BIGINT,
   AFFAIR_ID            BIGINT NOT NULL,
   ATTRIBUTE            INT NOT NULL,
   OPINION_TYPE         INT,
   CONTENT              LONGTEXT,
   IS_HIDDEN            NUMERIC(3,0) NOT NULL,
   CREATE_USER_ID       NUMERIC(19,0) NOT NULL,
   CREATE_TIME          DATETIME NOT NULL,
   POLICY               VARCHAR(255),
   PROXY_NAME           VARCHAR(255),
   NODE_ID              NUMERIC(19,0) DEFAULT -1,
   STATE                SMALLINT DEFAULT 0,
   SUB_EDOC_ID          BIGINT,
   UPDATE_TIME          DATETIME,
   SUB_OPINION_ID       BIGINT,
   DEPARTMENT_NAME      VARCHAR(500),
   ACCOUNT_NAME         VARCHAR(500),
   DEPARTMENT_SORT_ID   INT,
   SOURCE_SUMMARY_ID    BIGINT,
   PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_REGISTER                                         */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS EDOC_REGISTER
(
   ID                   BIGINT NOT NULL,
   IDENTIFIER           VARCHAR(100) NOT NULL,
   RECIEVE_ID           BIGINT NOT NULL,
   EDOC_ID              BIGINT NOT NULL,
   EDOC_TYPE            NUMERIC(3,0),
   REGISTER_TYPE        NUMERIC(3,0),
   CREATE_USER_ID       BIGINT,
   CREATE_USER_NAME     VARCHAR(255),
   CREATE_TIME          DATETIME,
   UPDATE_TIME          DATETIME,
   SEND_UNIT            LONGTEXT,
   SEND_UNIT_ID         BIGINT,
   SEND_UNIT_TYPE       NUMERIC(3,0),
   EDOC_UNIT            LONGTEXT,
   EDOC_UNIT_ID         LONGTEXT,
   EDOC_DATE            DATETIME,
   REGISTER_USER_ID     BIGINT,
   REGISTER_USER_NAME   VARCHAR(255),
   REGISTER_DATE        DATETIME,
   ISSUER_ID            BIGINT,
   ISSUER               VARCHAR(255),
   ISSUE_DATE           DATETIME,
   SIGNER               VARCHAR(255),
   DISTRIBUTER_ID       BIGINT,
   DISTRIBUTER          VARCHAR(255),
   DISTRIBUTE_DATE      DATETIME,
   DISTRIBUTE_STATE     NUMERIC(3,0),
   DISTRIBUTE_EDOC_ID   BIGINT,
   SUBJECT              VARCHAR(1024),
   DOC_TYPE             VARCHAR(255),
   SEND_TYPE            VARCHAR(255),
   DOC_MARK             VARCHAR(255),
   SERIAL_NO            VARCHAR(255),
   SECRET_LEVEL         VARCHAR(255),
   URGENT_LEVEL         VARCHAR(255),
   KEEP_PERIOD          VARCHAR(255),
   SEND_TO              LONGTEXT,
   SEND_TO_ID           LONGTEXT,
   COPY_TO              LONGTEXT,
   COPY_TO_ID           LONGTEXT,
   KEYWORDS             VARCHAR(255),
   COPIES               NUMERIC(10,2),
   NOTE_APPEND          VARCHAR(1024),
   ATT_NOTE             VARCHAR(1024),
   STATE                NUMERIC(3,0),
   ORG_ACCOUNT_ID       BIGINT,
   REC_TIME             DATETIME,
   IS_RETREAT           NUMERIC(3,0),
   AUTO_REGISTER        SMALLINT DEFAULT 0,
   RECIEVE_USER_ID      BIGINT,
   RECIEVE_USER_NAME    VARCHAR(100),
   EXCHANGE_MODE        SMALLINT DEFAULT 0,
   UNIT_LEVEL           VARCHAR(255),
   EXCHANGE_SEND_TIME   DATETIME,
   PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_STAT                                             */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS EDOC_STAT
(
   ID                   BIGINT NOT NULL,
   EDOC_ID              BIGINT NOT NULL,
   EDOC_TYPE            NUMERIC(3,0) NOT NULL,
   SUBJECT              VARCHAR(1024) NOT NULL,
   DOC_TYPE             VARCHAR(50),
   DOC_MARK             VARCHAR(255),
   DEPT_ID              BIGINT NOT NULL,
   CREATE_DATE          DATETIME,
   IS_SENT              NUMERIC(3,0),
   YEAR                 VARCHAR(4),
   MONTH                VARCHAR(2),
   IS_ARCHIVED          NUMERIC(3,0) NOT NULL,
   FLOW_STATE           NUMERIC(3,0) NOT NULL,
   DOMAIN_ID            NUMERIC(19,0) NOT NULL,
   REMARK               VARCHAR(1024),
   SEND_TO              LONGTEXT,
   COPY_TO              LONGTEXT,
   ISSUER               VARCHAR(255),
   COPIES               INT,
   CONTENT_NO           BIGINT DEFAULT 0,
   SERIAL_NO            VARCHAR(255),
   ARCHIVED_TIME        DATETIME,
   CREATE_USER_ID       BIGINT,
   ACCOUNT_ID           BIGINT,
   STAT_DAY             VARCHAR(2),
   STAT_QUARTER         VARCHAR(1),
   UNIT_LEVEL           VARCHAR(255),
   SEND_TYPE            VARCHAR(255),
   TEMPLETE_ID          BIGINT,
   ORG_DEPARTMENT_ID    BIGINT,
   PROCESS_TYPE         SMALLINT,
   PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_SUMMARY                                          */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS EDOC_SUMMARY
(
   ID                   BIGINT NOT NULL,
   IDENTIFIER           VARCHAR(100),
   HAS_ARCHIVE          SMALLINT DEFAULT 0,
   EDOC_TYPE            SMALLINT NOT NULL,
   DEADLINE             BIGINT,
   CAN_TRACK            SMALLINT NOT NULL,
   COMMENTS             VARCHAR(1024),
   PROCESS_ID           VARCHAR(100),
   CASE_ID              BIGINT,
   FORM_ID              BIGINT,
   CREATE_TIME          DATETIME NOT NULL,
   START_USER_ID        BIGINT,
   START_TIME           DATETIME,
   CREATE_PERSON        VARCHAR(255),
   COMPLETE_TIME        DATETIME,
   STATE                DECIMAL(3,0) NOT NULL,
   SUBJECT              VARCHAR(1024) NOT NULL,
   DOC_TYPE             VARCHAR(50),
   SEND_TYPE            VARCHAR(50),
   DOC_MARK             VARCHAR(255),
   SERIAL_NO            VARCHAR(255),
   SECRET_LEVEL         VARCHAR(50),
   URGENT_LEVEL         VARCHAR(50),
   SEND_UNIT            LONGTEXT,
   SEND_UNIT_ID         LONGTEXT,
   ISSUER               VARCHAR(255),
   SIGNING_DATE         DATETIME,
   SEND_TO              LONGTEXT,
   SEND_TO_ID           LONGTEXT,
   COPY_TO              LONGTEXT,
   COPY_TO_ID           LONGTEXT,
   REPORT_TO            LONGTEXT,
   REPORT_TO_ID         LONGTEXT,
   KEYWORDS             VARCHAR(255),
   PRINT_UNIT           VARCHAR(255),
   COPIES               INT,
   PRINTER              VARCHAR(255),
   ADVANCE_REMIND       BIGINT,
   TEMPLETE_ID          BIGINT,
   WORKFLOW_RULE        LONGTEXT,
   PACK_DATE            DATETIME,
   ISUNIT               SMALLINT DEFAULT 0,
   DOC_MARK2            VARCHAR(255),
   SEND_UNIT2           LONGTEXT,
   SEND_UNIT_ID2        LONGTEXT,
   SEND_TO2             LONGTEXT,
   SEND_TO_ID2          LONGTEXT,
   COPY_TO2             LONGTEXT,
   COPY_TO_ID2          LONGTEXT,
   REPORT_TO2           LONGTEXT,
   REPORT_TO_ID2        LONGTEXT,
   COPIES2              INT DEFAULT 0,
   ORG_DEPARTMENT_ID    BIGINT,
   ORG_ACCOUNT_ID       BIGINT,
   UPDATE_TIME          DATETIME,
   ARCHIVE_ID           BIGINT,
   SUB_EDOC_TYPE        BIGINT,
   FILESM               LONGTEXT,
   FILEFZ               VARCHAR(255),
   PARTY                VARCHAR(255),
   ADMINISTRATIVE       VARCHAR(255),
   SEND_DEPARTMENT      VARCHAR(255),
   SEND_DEPARTMENT2     VARCHAR(255),
   SEND_DEPARTMENT_ID   VARCHAR(255),
   SEND_DEPARTMENT_ID2  VARCHAR(255),
   ATTACHMENTS          LONGTEXT,
   OVER_WORKTIME        BIGINT,
   RUN_WORKTIME         BIGINT,
   OVER_TIME            BIGINT,
   RUN_TIME             BIGINT,
   KEEP_PERIOD          INT,
   IS_COVER_TIME        SMALLINT,
   RECEIPT_DATE         DATETIME,
   REGISTRATION_DATE    DATETIME,
   AUDITOR              VARCHAR(255),
   REVIEW               VARCHAR(255),
   UNDERTAKER           VARCHAR(1024),
   PHONE                VARCHAR(255),
   DEADLINE_DATETIME    DATETIME,
   IS_QUICK_SEND        SMALLINT DEFAULT 0,
   CURRENT_NODES_INFO   LONGTEXT,
   UNDERTAKENOFFICE     LONGTEXT,
   UNDERTAKENOFFICE_ID  LONGTEXT,
   UNIT_LEVEL           VARCHAR(255),
   TRANSFER_STATUS      DECIMAL(3,0),
   GOVDOC_TYPE          INT,
   SIGN_PERSON          VARCHAR(255),
   SIGN_ACCOUNT_ID      VARCHAR(255),
   EDOC_SECRET_LEVEL    TINYINT,
   JIANBAN_TYPE         INT,
   GOVCODE              VARCHAR(255),
   TO_EDOC_LIB_FLAG     TINYINT,
   TO_EDOC_LIB_TYPE     VARCHAR(255),
   SEND_DATE            DATETIME,
   PRINT_UNIT_ID        VARCHAR(255),
   RECEIVE_UNIT         VARCHAR(255),
   RECEIVE_UNIT_ID      VARCHAR(255),
   CHECK_PERSON         VARCHAR(255),
   PROXY_DATE           DATE,
   PISHI_NO             INT,
   PISHI_NAME           VARCHAR(255),
   PISHI_YEAR           VARCHAR(20),
   PISHI_LEADER_NAME    VARCHAR(255),
   PUBLIC_INFO          VARCHAR(255),
   FORM_APP_ID          BIGINT,
   NEWFLOW_TYPE         INT,
   ATTACHMENT_ARCHIVE_ID BIGINT,
   CAN_MODIFY           SMALLINT,
   FORM_RECORDID        BIGINT,
   IS_AUDITED           SMALLINT,
   VOUCH                SMALLINT,
   BODY_TYPE            VARCHAR(50),
   EXCHANGE_TYPE        TINYINT,
   CAN_ARCHIVE          SMALLINT,
   EXCHANGE_SEND_AFFAIRID BIGINT,
   CAN_EDIT_ATTACHMENT  SMALLINT,
   CAN_MERGE_DEAL       SMALLINT,
   CAN_ANY_MERGE        SMALLINT,
   CAN_EDIT             SMALLINT,
   PROCESS_TYPE         SMALLINT,
   SECRET_RELATED_LEVEL SMALLINT,
   FROM_TYPE            SMALLINT,
   PROCESS_TERM_TYPE    SMALLINT,
   REMIND_INTERVAL      BIGINT,
   DEAL_SUGGESTION		LONGTEXT,
   MERGE_DEAL_TYPE		VARCHAR(255),
   AUTO_RUN SMALLINT,
   CAN_DELETE_NODE SMALLINT,
   PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_SUMMARY_EXTEND                                   */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS EDOC_SUMMARY_EXTEND
(
   ID                   BIGINT NOT NULL,
   SUMMARY_ID           BIGINT NOT NULL,
   APP_TYPE             INT DEFAULT 4,
   AVARCHAR1            VARCHAR(255),
   AVARCHAR2            VARCHAR(255),
   AVARCHAR3            VARCHAR(255),
   AVARCHAR4            VARCHAR(255),
   AVARCHAR5            VARCHAR(255),
   AVARCHAR6            VARCHAR(255),
   AVARCHAR7            VARCHAR(255),
   AVARCHAR8            VARCHAR(255),
   AVARCHAR9            VARCHAR(255),
   AVARCHAR10           VARCHAR(255),
   AVARCHAR11           VARCHAR(255),
   AVARCHAR12           VARCHAR(255),
   AVARCHAR13           VARCHAR(255),
   AVARCHAR14           VARCHAR(255),
   AVARCHAR15           VARCHAR(255),
   AVARCHAR16           VARCHAR(255),
   AVARCHAR17           VARCHAR(255),
   AVARCHAR18           VARCHAR(255),
   AVARCHAR19           VARCHAR(255),
   AVARCHAR20           VARCHAR(255),
   AVARCHAR21           VARCHAR(255),
   AVARCHAR22           VARCHAR(255),
   AVARCHAR23           VARCHAR(255),
   AVARCHAR24           VARCHAR(255),
   AVARCHAR25           VARCHAR(255),
   AVARCHAR26           VARCHAR(255),
   AVARCHAR27           VARCHAR(255),
   AVARCHAR28           VARCHAR(255),
   AVARCHAR29           VARCHAR(255),
   AVARCHAR30           VARCHAR(255),
   TEXT1                LONGTEXT,
   TEXT2                LONGTEXT,
   TEXT3                LONGTEXT,
   TEXT4                LONGTEXT,
   TEXT5                LONGTEXT,
   TEXT6                LONGTEXT,
   TEXT7                LONGTEXT,
   TEXT8                LONGTEXT,
   TEXT9                LONGTEXT,
   TEXT10               LONGTEXT,
   TEXT11               LONGTEXT,
   TEXT12               LONGTEXT,
   TEXT13               LONGTEXT,
   TEXT14               LONGTEXT,
   TEXT15               LONGTEXT,
   INTEGER1             BIGINT,
   INTEGER2             BIGINT,
   INTEGER3             BIGINT,
   INTEGER4             BIGINT,
   INTEGER5             BIGINT,
   INTEGER6             BIGINT,
   INTEGER7             BIGINT,
   INTEGER8             BIGINT,
   INTEGER9             BIGINT,
   INTEGER10            BIGINT,
   INTEGER11            BIGINT,
   INTEGER12            BIGINT,
   INTEGER13            BIGINT,
   INTEGER14            BIGINT,
   INTEGER15            BIGINT,
   INTEGER16            BIGINT,
   INTEGER17            BIGINT,
   INTEGER18            BIGINT,
   INTEGER19            BIGINT,
   INTEGER20            BIGINT,
   DECIMAL1             NUMERIC(16,4),
   DECIMAL2             NUMERIC(16,4),
   DECIMAL3             NUMERIC(16,4),
   DECIMAL4             NUMERIC(16,4),
   DECIMAL5             NUMERIC(16,4),
   DECIMAL6             NUMERIC(16,4),
   DECIMAL7             NUMERIC(16,4),
   DECIMAL8             NUMERIC(16,4),
   DECIMAL9             NUMERIC(16,4),
   DECIMAL10            NUMERIC(16,4),
   DECIMAL11            NUMERIC(16,4),
   DECIMAL12            NUMERIC(16,4),
   DECIMAL13            NUMERIC(16,4),
   DECIMAL14            NUMERIC(16,4),
   DECIMAL15            NUMERIC(16,4),
   DECIMAL16            NUMERIC(16,4),
   DECIMAL17            NUMERIC(16,4),
   DECIMAL18            NUMERIC(16,4),
   DECIMAL19            NUMERIC(16,4),
   DECIMAL20            NUMERIC(16,4),
   DATE1                DATETIME,
   DATE2                DATETIME,
   DATE3                DATETIME,
   DATE4                DATETIME,
   DATE5                DATETIME,
   DATE6                DATETIME,
   DATE7                DATETIME,
   DATE8                DATETIME,
   DATE9                DATETIME,
   DATE10               DATETIME,
   DATE11               DATETIME,
   DATE12               DATETIME,
   DATE13               DATETIME,
   DATE14               DATETIME,
   DATE15               DATETIME,
   DATE16               DATETIME,
   DATE17               DATETIME,
   DATE18               DATETIME,
   DATE19               DATETIME,
   DATE20               DATETIME,
   LIST1                VARCHAR(255),
   LIST2                VARCHAR(255),
   LIST3                VARCHAR(255),
   LIST4                VARCHAR(255),
   LIST5                VARCHAR(255),
   LIST6                VARCHAR(255),
   LIST7                VARCHAR(255),
   LIST8                VARCHAR(255),
   LIST9                VARCHAR(255),
   LIST10               VARCHAR(255),
   LIST11               VARCHAR(255),
   LIST12               VARCHAR(255),
   LIST13               VARCHAR(255),
   LIST14               VARCHAR(255),
   LIST15               VARCHAR(255),
   LIST16               VARCHAR(255),
   LIST17               VARCHAR(255),
   LIST18               VARCHAR(255),
   LIST19               VARCHAR(255),
   LIST20               VARCHAR(255),
   PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: CTP_SUPERVISOR                                        */
/*==============================================================*/
CREATE TABLE IF NOT EXISTS CTP_SUPERVISOR
(
   ID                   BIGINT NOT NULL,
   SUPERVISE_ID         BIGINT,
   PERMISSION           SMALLINT,
   SUPERVISOR_ID        BIGINT,
   ENTITY_ID            BIGINT,
   PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: CTP_SUPERVISE_DETAIL                                  */
/*==============================================================*/
CREATE TABLE CTP_SUPERVISE_DETAIL
(
   ID                   BIGINT NOT NULL,
   TITLE                VARCHAR(1024),
   ENTITY_TYPE          SMALLINT,
   ENTITY_ID            BIGINT,
   SENDER_ID            BIGINT,
   STATUS               SMALLINT,
   SUPERVISORS          VARCHAR(1024),
   DESCRIPTION          VARCHAR(1024),
   COUNT                INT,
   AWAKE_DATE           DATETIME,
   REMIND_MODE          SMALLINT,
   SCHEDULE_PROP        VARCHAR(255),
   CREATE_DATE          DATETIME,
   TEMPLATE_DATE_TERMINAL BIGINT,
   SUPERVISE_DATE_TYPE  VARCHAR(255),
   SUBJECT              VARCHAR(1024),
   ENTITY_CREATE_DATE   DATETIME,
   ENTITY_SENDER_ID     BIGINT,
   IMPORTANT_LEVEL      SMALLINT,
   FORWARD_MEMBER       VARCHAR(255),
   BODY_TYPE            VARCHAR(255),
   IDENTIFIER           VARCHAR(255),
   AFFAIR_ID            BIGINT,
   EXT_PROPS            VARCHAR(2000),
   IS_COVER_TIME        SMALLINT,
   TEMPLETE_ID          BIGINT,
   RESENT_TIME          SMALLINT,
   APP                  SMALLINT,
   PROCESS_DEADLINE_DATE DATETIME,
   PRIMARY KEY (ID)
);