/*==============================================================*/
/* Table: COL_SUMMARY                                           */
/*==============================================================*/
CREATE TABLE COL_SUMMARY
(
   ID                   INTEGER              NOT NULL,
   STATE                NUMBER(4),
   SUBJECT              VARCHAR2(1024),
   DEADLINE             INTEGER,
   COL_TYPE             NUMBER(4),
   CAN_ARCHIVE          NUMBER(4),
   CAN_MODIFY           NUMBER(4),
   CAN_DUE_REMINDER     NUMBER(4),
   CAN_FORWARD          NUMBER(4),
   CAN_EDIT             NUMBER(4),
   CAN_TRACK            NUMBER(4),
   REMIND_INTERVAL      INTEGER,
   PROJECT_ID           INTEGER,
   IMPORTANT_LEVEL      NUMBER(4),
   RESENT_TIME          NUMBER(4),
   CREATE_DATE          DATE,
   START_DATE           DATE,
   FINISH_DATE          DATE,
   IS_AUDITED           NUMBER(4),
   ARCHIVE_ID           INTEGER,
   START_MEMBER_ID      INTEGER,
   PROCESS_ID           VARCHAR2(255),
   CASE_ID              INTEGER,
   ADVANCE_REMIND       INTEGER,
   IDENTIFIER           VARCHAR2(255),
   FORWARD_MEMBER       VARCHAR2(255),
   TEMPLETE_ID          INTEGER,
   WORKFLOW_RULE        CLOB,
   WEBSERVICE_CODE      VARCHAR2(255),
   BODY_TYPE            VARCHAR2(255),
   FORM_RECORDID        INTEGER,
   FORMID               INTEGER,
   FORM_APPID           INTEGER,
   ORG_DEPARTMENT_ID    INTEGER,
   ORG_ACCOUNT_ID       INTEGER,
   SOURCE               VARCHAR2(255),
   PARENTFORM_SUMMARYID INTEGER,
   NEWFLOW_TYPE         NUMBER(4),
   CAN_EDIT_ATTACHMENT  NUMBER(4),
   VOUCH                NUMBER(4),
   OVER_WORKTIME        INTEGER,
   RUN_WORKTIME         INTEGER,
   OVER_TIME            INTEGER,
   RUN_TIME             INTEGER,
   CAN_AUTOSTOPFLOW     NUMBER(4),
   IS_COVER_TIME        NUMBER(4),
   DEADLINE_DATETIME    DATE,
   CURRENT_NODES_INFO   VARCHAR2(255),
   CAN_MERGE_DEAL       NUMBER(4),
   ADVANCE_PIGEONHOLE   VARCHAR2(4000),
   CAN_ANY_MERGE        NUMBER(4),
   PROCESS_NODES_INFO   CLOB,
   PERMISSION_ACCOUNT_ID INTEGER,
   REPLY_COUNTS         NUMBER(4),
   AUTO_RUN             NUMBER(4),
   ATTACHMENT_ARCHIVE_ID INTEGER,
   PROCESS_TERM_TYPE    NUMBER(4),
   MERGE_DEAL_TYPE      VARCHAR2(255),
   SUB_STATE            NUMBER(4),
   RELATION_ID			INTEGER,
   MESSAGE_RULE_ID		VARCHAR2(500),
   CAN_DELETE_NODE NUMBER(4),
   NODES_INFO VARCHAR2(4000),
   CONSTRAINT PK_COL_SUMMARY PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: CTP_AFFAIR                                            */
/*==============================================================*/
CREATE TABLE CTP_AFFAIR
(
   ID                   INTEGER              NOT NULL,
   IS_COVER_TIME        NUMBER(4),
   MEMBER_ID            INTEGER,
   SENDER_ID            INTEGER,
   SUBJECT              VARCHAR2(1024),
   APP                  NUMBER(4),
   OBJECT_ID            INTEGER,
   SUB_OBJECT_ID        INTEGER,
   STATE                NUMBER(4),
   SUB_STATE            NUMBER(4),
   HASTEN_TIMES         NUMBER(4),
   REMIND_DATE          INTEGER,
   DEADLINE_DATE        INTEGER,
   CAN_DUE_REMIND       NUMBER(4),
   CREATE_DATE          DATE,
   RECEIVE_TIME         DATE,
   COMPLETE_TIME        DATE,
   REMIND_INTERVAL      NUMBER(4),
   IS_DELETE            NUMBER(4),
   TRACK                NUMBER(4),
   ARCHIVE_ID           INTEGER,
   ADDITION             VARCHAR2(2000),
   EXT_PROPS            VARCHAR2(2000),
   UPDATE_DATE          DATE,
   IS_FINISH            NUMBER(4),
   BODY_TYPE            VARCHAR2(255),
   IMPORTANT_LEVEL      NUMBER(4),
   RESENT_TIME          NUMBER(4),
   FORWARD_MEMBER       VARCHAR2(255),
   IDENTIFIER           VARCHAR2(255),
   TRANSACTOR_ID        INTEGER,
   NODE_POLICY          VARCHAR2(255),
   ACTIVITY_ID          INTEGER,
   FORM_APP_ID          INTEGER,
   FORM_ID              INTEGER,
   FORM_OPERATION_ID    INTEGER,
   TEMPLETE_ID          INTEGER,
   FROM_ID              INTEGER,
   OVER_WORKTIME        INTEGER,
   RUN_WORKTIME         INTEGER,
   OVER_TIME            INTEGER,
   RUN_TIME             INTEGER,
   DEAL_TERM_TYPE       NUMBER(4),
   DEAL_TERM_USERID     INTEGER,
   SUB_APP              NUMBER(4),
   EXPECTED_PROCESS_TIME DATE,
   ORG_ACCOUNT_ID       INTEGER,
   PROCESS_ID           VARCHAR2(255),
   IS_PROCESS_OVER_TIME NUMBER(4),
   FORM_MULTI_OPERATION_ID VARCHAR2(4000),
   BACK_FROM_ID         INTEGER,
   FORM_RELATIVE_STATIC_IDS VARCHAR2(255),
   FORM_RELATIVE_QUERY_IDS VARCHAR2(255),
   HAS_FAVORITE         NUMBER(4),
   FROM_TYPE            NUMBER(4),
   FORM_RECORDID        INTEGER,
   CASE_ID              INTEGER,
   RELATION_DATA_ID     INTEGER,
   FIRSTVIEW_PERIOD     INTEGER,
   FIRSTVIEW_DATE       DATE,
   FIRSTRESPONSE_PERIOD INTEGER,
   SIGNLEVIEW_PERIOD    INTEGER,
   PRE_APPROVER         INTEGER,
   AUTO_RUN             NUMBER(4),
   SUMMARY_STATE        NUMBER(4),
   TOP_TIME             DATE,
   SORT_WEIGHT          NUMBER(4),
   AI_PROCESSING        NUMBER(4),
   PROCESS_DEADLINE_TIME DATE,
   PROXY_MEMBER_ID		INTEGER,
   MATCH_DEPARTMENT_ID	INTEGER,
   MATCH_POST_ID   		INTEGER,
   NODE_NAME			VARCHAR2(500),
   MATCH_ACCOUNT_ID     INTEGER,
   PRINT_NM				NUMBER(4),
   MESSAGE_RULE_ID		VARCHAR2(1000),
   MATCH_ROLE_ID INTEGER,
   CONSTRAINT PK_CTP_AFFAIR PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: CTP_COMMENT_ALL                                       */
/*==============================================================*/
CREATE TABLE CTP_COMMENT_ALL
(
   ID                   INTEGER              NOT NULL,
   CREATE_ID            INTEGER,
   CREATE_DATE          DATE,
   MODIFY_DATE          DATE,
   MODULE_TYPE          NUMBER(4)             DEFAULT 0,
   MODULE_ID            INTEGER,
   CTYPE                NUMBER(4)             DEFAULT 0,
   CONTENT              CLOB,
   TITLE                VARCHAR2(1024),
   IS_HIDDEN            NUMBER(4)             DEFAULT 0,
   SHOW_TO_ID           CLOB,
   PATH                 VARCHAR2(500),
   CLEVEL               NUMBER(4)             DEFAULT 0,
   PID                  INTEGER,
   RELATE_INFO          CLOB,
   EXT_ATT1             VARCHAR2(100),
   EXT_ATT2             VARCHAR2(100),
   EXT_ATT3             VARCHAR2(100),
   AFFAIR_ID            INTEGER,
   FORWARD_COUNT        NUMBER(4),
   PRAISE_TO_SUMMARY    NUMBER(4),
   PRAISE_NUMBER        INTEGER,
   PRAISE_MEMBER_IDS    CLOB,
   RICH_CONTENT         CLOB,
   DEPARTMENT_ID		INTEGER,
   POST_ID				INTEGER,
   ACCOUNT_ID           INTEGER,
   EXT_ATT4 VARCHAR2(50),
   MATCH_ROLE_ID INTEGER,
   ACCOUNT_NAME VARCHAR2(255),
   DEPARTMENT_NAME VARCHAR2(255),
   POST_NAME VARCHAR2(255),
   ROLE_NAME VARCHAR2(255),
   HAS_WF_OPERATION NUMBER(4),
   DEAL_LOCALE VARCHAR2(50),
   SUB_TYPE NUMBER(4),
   CREATE_NAME VARCHAR2(255),
   CONSTRAINT PK_CTP_COMMENT_ALL PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: CTP_CONTENT_ALL                                       */
/*==============================================================*/
CREATE TABLE CTP_CONTENT_ALL
(
   ID                   INTEGER              NOT NULL,
   CREATE_ID            INTEGER,
   CREATE_DATE          DATE,
   MODIFY_ID            INTEGER,
   MODIFY_DATE          DATE,
   MODULE_TYPE          NUMBER(4)             DEFAULT 0,
   MODULE_ID            INTEGER,
   MODULE_TEMPLATE_ID   INTEGER,
   CONTENT_TYPE         NUMBER(4)             DEFAULT 0,
   CONTENT              CLOB,
   CONTENT_DATA_ID      INTEGER,
   CONTENT_TEMPLATE_ID  INTEGER,
   TITLE                VARCHAR2(1024),
   SORT                 NUMBER(4)             DEFAULT 0,
   CONSTRAINT PK_CTP_CONTENT_ALL PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: CTP_PROCESS_HISTORY_LOG                               */
/*==============================================================*/
CREATE TABLE CTP_PROCESS_HISTORY_LOG
(
   ID                   INTEGER              NOT NULL,
   PROCESS_ID           INTEGER              NOT NULL,
   ACTIVITY_ID          INTEGER              NOT NULL,
   ACTION_ID            INTEGER              NOT NULL,
   ACTION_USER_ID       INTEGER              NOT NULL,
   PARAM0               VARCHAR2(1024),
   PARAM1               VARCHAR2(1024),
   PARAM2               VARCHAR2(1024),
   PARAM3               VARCHAR2(1024),
   PARAM4               VARCHAR2(1024),
   PARAM5               VARCHAR2(4000),
   ACTION_TIME          DATE,
   ACTION_DESC          VARCHAR2(1024),
   COMMENT_ID           INTEGER,
   DETAIL_STATUS        NUMBER(4),
   CONSTRAINT PK_CTP_PROCESS_HISTORY_LOG PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: CTP_PROCESS_LOG                                       */
/*==============================================================*/
CREATE TABLE CTP_PROCESS_LOG
(
   ID                   INTEGER              NOT NULL,
   PROCESS_ID           INTEGER              NOT NULL,
   ACTIVITY_ID          INTEGER              NOT NULL,
   ACTION_ID            INTEGER              NOT NULL,
   ACTION_USER_ID       INTEGER              NOT NULL,
   PARAM0               VARCHAR2(1024),
   PARAM1               VARCHAR2(1024),
   PARAM2               VARCHAR2(1024),
   PARAM3               VARCHAR2(1024),
   PARAM4               VARCHAR2(1024),
   PARAM5               VARCHAR2(4000),
   ACTION_TIME          DATE,
   ACTION_DESC          VARCHAR2(1024),
   COMMENT_ID           INTEGER,
   DETAIL_STATUS        NUMBER(4),
   CONSTRAINT PK_CTP_PROCESS_LOG PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: WF_CASE_HISTORY                                       */
/*==============================================================*/
CREATE TABLE WF_CASE_HISTORY
(
   ID                   INTEGER              NOT NULL,
   CASENAME             VARCHAR2(100),
   STARTUSER            VARCHAR2(36)         NOT NULL,
   LASTPERFORMER        VARCHAR2(36),
   STATE                INTEGER              NOT NULL,
   SUBPROCESS           INTEGER,
   STARTSUBPROCESSNUM   INTEGER,
   PROCESSINDEX         VARCHAR2(110)        NOT NULL,
   PROCESSNAME          VARCHAR2(100)        NOT NULL,
   PROCESSID            VARCHAR2(100)        NOT NULL,
   STARTDATE            INTEGER              NOT NULL,
   UPDATEDATE           INTEGER              NOT NULL,
   CASEOBJECT           BLOB,
   CASE_CONTENT         CLOB,
   CONSTRAINT PK_WF_CASE_HISTORY PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: WF_CASE_RUN                                           */
/*==============================================================*/
CREATE TABLE WF_CASE_RUN
(
   ID                   INTEGER              NOT NULL,
   CASENAME             VARCHAR2(100),
   STARTUSER            VARCHAR2(36)         NOT NULL,
   LASTPERFORMER        VARCHAR2(36),
   STATE                INTEGER              NOT NULL,
   SUBPROCESS           INTEGER,
   STARTSUBPROCESSNUM   INTEGER,
   PROCESSINDEX         VARCHAR2(110)        NOT NULL,
   PROCESSNAME          VARCHAR2(100)        NOT NULL,
   PROCESSID            VARCHAR2(100)        NOT NULL,
   STARTDATE            INTEGER              NOT NULL,
   UPDATEDATE           INTEGER              NOT NULL,
   CASEOBJECT           BLOB,
   CASE_CONTENT         CLOB,
   CONSTRAINT PK_WF_CASE_RUN PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: WF_PROCESS_RUNNING                                    */
/*==============================================================*/
CREATE TABLE WF_PROCESS_RUNNING
(
   ID                   VARCHAR2(110)        NOT NULL,
   TEMPLETE_ID          INTEGER,
   PROCESSOBJECT        BLOB,
   CREATEDATE           INTEGER,
   STATE                NUMBER(4)             DEFAULT 0,
   PROCESS_XML          CLOB,
   CONSTRAINT PK_WF_PROCESS_RUNNING PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: WF_SUBPROCESS_RUNNING                                 */
/*==============================================================*/
CREATE TABLE WF_SUBPROCESS_RUNNING
(
   ID                   INTEGER              NOT NULL,
   SUBJECT              VARCHAR2(255),
   NEW_ID               INTEGER,
   MAIN_TEMPLETE_ID     INTEGER,
   MAIN_NODE_ID         VARCHAR2(255),
   MAIN_CASE_ID         INTEGER,
   MAIN_PROCESS_ID      VARCHAR2(255),
   TRIGGER_CONDITION    CLOB,
   CONDITION_TITLE      CLOB,
   CONDITION_BASE       VARCHAR2(255),
   IS_FORCE             NUMBER(4),
   FLOW_RELATE_TYPE     NUMBER(4),
   CAN_VIEW_BY_MAIN     NUMBER(4),
   CAN_VIEW_MAIN        NUMBER(4),
   SENDER               VARCHAR2(255),
   SENDER_ID            INTEGER,
   TEMPLETE_ID          INTEGER,
   CASE_ID              INTEGER,
   PROCESS_ID           VARCHAR2(255),
   CREATE_TIME          DATE,
   UPDATE_TIME          DATE,
   BUSSINESS_TYPE       VARCHAR2(255),
   BUSSINESS_ID         VARCHAR2(255),
   IS_FINISHED          NUMBER(4),
   IS_ACTIVATE          NUMBER(4)             DEFAULT 0,
   IS_DELETE            NUMBER(4)             DEFAULT 0,
   CONSTRAINT PK_WF_SUBPROCESS_RUNNING PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: WF_WORKITEM_HISTORY                                   */
/*==============================================================*/
CREATE TABLE WF_WORKITEM_HISTORY
(
   ID                   INTEGER              NOT NULL,
   CASEID               INTEGER              NOT NULL,
   BATCH                INTEGER              NOT NULL,
   ITEMNUM              INTEGER              NOT NULL,
   WF_DOMAIN            VARCHAR2(100)        NOT NULL,
   NAME                 VARCHAR2(255)        DEFAULT '-',
   CASENAME             VARCHAR2(100),
   PROCESSID            VARCHAR2(100)        NOT NULL,
   PROCESSINDEX         VARCHAR2(100)        NOT NULL,
   PROCESSNAME          VARCHAR2(100),
   ACTIVITYID           VARCHAR2(36)         NOT NULL,
   ACTIVITYNAME         VARCHAR2(255),
   PERFORMER            VARCHAR2(255),
   FINISHER             VARCHAR2(64),
   OWNER                VARCHAR2(64),
   ENTRUSTER            VARCHAR2(64),
   DELEGATER            VARCHAR2(64),
   LEVELNUM             INTEGER              NOT NULL,
   CANREASSIGN          INTEGER              NOT NULL,
   CANRETURN            INTEGER              NOT NULL,
   CANDELEGATE          INTEGER              NOT NULL,
   CANENTRUST           INTEGER              NOT NULL,
   CANREVIEW            INTEGER              NOT NULL,
   NEXTSTATUS           VARCHAR2(36),
   NEXTLINKID           VARCHAR2(36),
   DATAMAP              BLOB,
   OLDSTATE             INTEGER,
   STATE                INTEGER              NOT NULL,
   CREATEDATE           INTEGER              NOT NULL,
   UPDATEDATE           INTEGER              NOT NULL,
   DEADLINE             INTEGER,
   ACTIONSTATE          VARCHAR2(500),
   SORT                 INTEGER              DEFAULT 0 NOT NULL,
   CONSTRAINT PK_WF_WORKITEM_HISTORY PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: WF_WORKITEM_RUN                                       */
/*==============================================================*/
CREATE TABLE WF_WORKITEM_RUN
(
   ID                   INTEGER              NOT NULL,
   CASEID               INTEGER,
   BATCH                INTEGER,
   ITEMNUM              INTEGER,
   WF_DOMAIN            VARCHAR2(100),
   NAME                 VARCHAR2(255),
   CASENAME             VARCHAR2(100),
   PROCESSID            VARCHAR2(100),
   PROCESSINDEX         VARCHAR2(100),
   PROCESSNAME          VARCHAR2(100),
   ACTIVITYID           VARCHAR2(36),
   ACTIVITYNAME         VARCHAR2(255),
   PERFORMER            VARCHAR2(255),
   FINISHER             VARCHAR2(64),
   OWNER                VARCHAR2(64),
   ENTRUSTER            VARCHAR2(64),
   DELEGATER            VARCHAR2(64),
   LEVELNUM             INTEGER,
   CANREASSIGN          INTEGER,
   CANRETURN            INTEGER,
   CANDELEGATE          INTEGER,
   CANENTRUST           INTEGER,
   CANREVIEW            INTEGER,
   NEXTSTATUS           VARCHAR2(36),
   NEXTLINKID           VARCHAR2(36),
   DATAMAP              BLOB,
   OLDSTATE             INTEGER,
   STATE                INTEGER,
   CREATEDATE           INTEGER,
   UPDATEDATE           INTEGER,
   DEADLINE             INTEGER,
   ACTIONSTATE          VARCHAR2(500),
   SORT                 INTEGER              DEFAULT 0,
   CONSTRAINT PK_WF_WORKITEM_RUN PRIMARY KEY (ID)
);
CREATE TABLE CTP_CONFIG
(
   ID                   INTEGER              NOT NULL,
   CONFIG_CATEGORY      VARCHAR2(100),
   CONFIG_CATEGORY_NAME VARCHAR2(100),
   CONFIG_ITEM          VARCHAR2(100),
   CONFIG_VALUE         VARCHAR2(1000),
   CONFIG_DESCRIPTION   VARCHAR2(255),
   CREATE_DATE          DATE,
   MODIFY_DATE          DATE,
   CONFIG_TYPE          VARCHAR2(100),
   EXT_CONFIG_VALUE     CLOB,
   ORG_ACCOUNT_ID       INTEGER,
   SORT                 INTEGER,
   CONSTRAINT PK_CTP_CONFIG PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_BODY                                             */
/*==============================================================*/
CREATE TABLE EDOC_BODY 
(
   ID                   INTEGER              NOT NULL,
   CONTENT_TYPE         VARCHAR2(20)         NOT NULL,
   CONTENT              CLOB,
   EDOC_ID              INTEGER,
   CREATE_TIME          DATE                 NOT NULL,
   LAST_UPDATE          DATE                 NOT NULL,
   CONTENT_NAME         VARCHAR2(32),
   CONTENT_STATUS       NUMBER(4),
   CONTENT_NO           INTEGER              DEFAULT 0,
   CONSTRAINT PK_EDOC_BODY PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_EXCHANGE_RECIEVE                                 */
/*==============================================================*/
CREATE TABLE EDOC_EXCHANGE_RECIEVE 
(
   ID                   INTEGER              NOT NULL,
   SUBJECT              VARCHAR2(1024)       NOT NULL,
   DOC_TYPE             VARCHAR2(255),
   DOC_MARK             VARCHAR2(255),
   SECRET_LEVEL         VARCHAR2(50),
   URGENT_LEVEL         VARCHAR2(50),
   KEEP_PERIOD          VARCHAR2(255),
   SEND_UNIT            VARCHAR2(255)        NOT NULL,
   SENDER               VARCHAR2(255),
   ISSUER               VARCHAR2(255),
   ISSUE_DATE           DATE,
   SEND_TO              CLOB,
   COPY_TO              CLOB,
   REPORT_TO            CLOB,
   EDOC_ID              INTEGER,
   FILE_ID              INTEGER,
   FROM_INTERNAL        NUMBER(3)            NOT NULL,
   REPLY_ID             VARCHAR2(255),
   REC_NO               VARCHAR2(255),
   REC_USER_ID          INTEGER,
   REC_TIME             DATE,
   REMARK               VARCHAR2(255),
   REGISTER_USER_ID     NUMBER(19),
   REGISTER_TIME        DATE,
   EXCHANGE_ORG_ID      NUMBER(19)           NOT NULL,
   EXCHANGE_TYPE        NUMBER(3)            NOT NULL,
   CREATE_TIME          DATE                 NOT NULL,
   STATUS               NUMBER(3)            NOT NULL,
   CONTENT_NO           NUMBER(4)             DEFAULT 0,
   STEPBACKINFO         VARCHAR2(4000),
   IS_RETREAT           NUMBER(3),
   SEND_UNIT_TYPE       NUMBER(3),
   RECIVE_EDOC_ID       NUMBER(19),
   IS_TURN_REC          NUMBER(4)             DEFAULT 0,
   EXCHANGE_MODE        NUMBER(4)             DEFAULT 0,
   CONSTRAINT PK_EDOC_EXCHANGE_RECIEVE PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_EXCHANGE_SEND                                    */
/*==============================================================*/
CREATE TABLE EDOC_EXCHANGE_SEND 
(
   ID                   INTEGER              NOT NULL,
   SUBJECT              VARCHAR2(1024)       NOT NULL,
   DOC_TYPE             VARCHAR2(255),
   DOC_MARK             VARCHAR2(255),
   SECRET_LEVEL         VARCHAR2(50),
   URGENT_LEVEL         VARCHAR2(50),
   SEND_UNIT            VARCHAR2(255)        NOT NULL,
   ISSUER               VARCHAR2(255),
   ISSUE_DATE           DATE,
   COPIES               INTEGER,
   EDOC_ID              INTEGER              NOT NULL,
   EXCHANGE_ORG_ID      INTEGER              NOT NULL,
   EXCHANGE_TYPE        NUMBER(3)            NOT NULL,
   SEND_USER_ID         INTEGER,
   SEND_TIME            DATE,
   CREATE_TIME          DATE                 NOT NULL,
   STATUS               NUMBER(3)            NOT NULL,
   CONTENT_NO           NUMBER(4)             DEFAULT 0,
   SENDED_TYPEIDS       CLOB,
   STEPBACK_INFO        VARCHAR2(1024),
   ASSIGN_TYPE          NUMBER(4)             DEFAULT 0,
   IS_BASE              NUMBER(4)             DEFAULT 0,
   IS_TURN_REC          NUMBER(4)             DEFAULT 0,
   SENDED_NAMES         CLOB,
   EXCHANGE_MODE        NUMBER(4)             DEFAULT 0,
   EXCHANGE_ACCOUNT_ID  INTEGER,
   CONSTRAINT PK_EDOC_EXCHANGE_SEND PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_EXCHANGE_SEND_DETAIL                             */
/*==============================================================*/
CREATE TABLE EDOC_EXCHANGE_SEND_DETAIL 
(
   ID                   INTEGER              NOT NULL,
   SEND_EDOC_ID         INTEGER,
   REC_ORG_ID           VARCHAR2(255)        NOT NULL,
   REC_ORG_TYPE         NUMBER(3)            NOT NULL,
   REC_ORG_NAME         VARCHAR2(255),
   SEND_TYPE            NUMBER(3)            NOT NULL,
   CONTENT              VARCHAR2(255),
   REC_NO               VARCHAR2(255),
   REC_USER_NAME        VARCHAR2(255),
   REC_TIME             DATE,
   STATUS               NUMBER(3)            NOT NULL,
   CUIBAN_NUM           NUMBER(4)             DEFAULT 0,
   CONSTRAINT PK_EDOC_EXCHANGE_SEND_DETAIL PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_OPINION                                          */
/*==============================================================*/
CREATE TABLE EDOC_OPINION 
(
   ID                   INTEGER              NOT NULL,
   EDOC_ID              INTEGER,
   AFFAIR_ID            INTEGER              NOT NULL,
   ATTRIBUTE            INTEGER              NOT NULL,
   OPINION_TYPE         INTEGER,
   CONTENT              CLOB,
   IS_HIDDEN            NUMBER(3)            NOT NULL,
   CREATE_USER_ID       NUMBER(19)           NOT NULL,
   CREATE_TIME          DATE                 NOT NULL,
   POLICY               VARCHAR2(255),
   PROXY_NAME           VARCHAR2(255),
   NODE_ID              NUMBER(19)           DEFAULT -1,
   STATE                NUMBER(4)             DEFAULT 0,
   SUB_EDOC_ID          INTEGER,
   UPDATE_TIME          DATE,
   SUB_OPINION_ID       INTEGER,
   DEPARTMENT_NAME      VARCHAR2(500),
   ACCOUNT_NAME         VARCHAR2(500),
   DEPARTMENT_SORT_ID   INTEGER,
   SOURCE_SUMMARY_ID    INTEGER,
   CONSTRAINT PK_EDOC_OPINION PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_REGISTER                                         */
/*==============================================================*/
CREATE TABLE EDOC_REGISTER 
(
   ID                   INTEGER              NOT NULL,
   IDENTIFIER           VARCHAR2(100)        NOT NULL,
   RECIEVE_ID           INTEGER              NOT NULL,
   EDOC_ID              INTEGER              NOT NULL,
   EDOC_TYPE            NUMBER(3),
   REGISTER_TYPE        NUMBER(3),
   CREATE_USER_ID       INTEGER,
   CREATE_USER_NAME     VARCHAR2(255),
   CREATE_TIME          DATE,
   UPDATE_TIME          DATE,
   SEND_UNIT            CLOB,
   SEND_UNIT_ID         INTEGER,
   SEND_UNIT_TYPE       NUMBER(3),
   EDOC_UNIT            CLOB,
   EDOC_UNIT_ID         CLOB,
   EDOC_DATE            DATE,
   REGISTER_USER_ID     INTEGER,
   REGISTER_USER_NAME   VARCHAR2(255),
   REGISTER_DATE        DATE,
   ISSUER_ID            INTEGER,
   ISSUER               VARCHAR2(255),
   ISSUE_DATE           DATE,
   SIGNER               VARCHAR2(255),
   DISTRIBUTER_ID       INTEGER,
   DISTRIBUTER          VARCHAR2(255),
   DISTRIBUTE_DATE      DATE,
   DISTRIBUTE_STATE     NUMBER(3),
   DISTRIBUTE_EDOC_ID   INTEGER,
   SUBJECT              VARCHAR2(1024),
   DOC_TYPE             VARCHAR2(255),
   SEND_TYPE            VARCHAR2(255),
   DOC_MARK             VARCHAR2(255),
   SERIAL_NO            VARCHAR2(255),
   SECRET_LEVEL         VARCHAR2(255),
   URGENT_LEVEL         VARCHAR2(255),
   KEEP_PERIOD          VARCHAR2(255),
   SEND_TO              CLOB,
   SEND_TO_ID           CLOB,
   COPY_TO              CLOB,
   COPY_TO_ID           CLOB,
   KEYWORDS             VARCHAR2(255),
   COPIES               NUMBER(10,2),
   NOTE_APPEND          VARCHAR2(1024),
   ATT_NOTE             VARCHAR2(1024),
   STATE                NUMBER(3),
   ORG_ACCOUNT_ID       INTEGER,
   REC_TIME             DATE,
   IS_RETREAT           NUMBER(3),
   AUTO_REGISTER        NUMBER(4)             DEFAULT 0,
   RECIEVE_USER_ID      INTEGER,
   RECIEVE_USER_NAME    VARCHAR2(100),
   EXCHANGE_MODE        NUMBER(4)             DEFAULT 0,
   UNIT_LEVEL           VARCHAR2(255),
   EXCHANGE_SEND_TIME   DATE,
   CONSTRAINT PK_EDOC_REGISTER PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_STAT                                             */
/*==============================================================*/
CREATE TABLE EDOC_STAT 
(
   ID                   INTEGER              NOT NULL,
   EDOC_ID              INTEGER              NOT NULL,
   EDOC_TYPE            NUMBER(3)            NOT NULL,
   SUBJECT              VARCHAR2(1024)       NOT NULL,
   DOC_TYPE             VARCHAR2(50),
   DOC_MARK             VARCHAR2(255),
   DEPT_ID              INTEGER              NOT NULL,
   CREATE_DATE          DATE,
   IS_SENT              NUMBER(3),
   YEAR                 VARCHAR2(4),
   MONTH                VARCHAR2(2),
   IS_ARCHIVED          NUMBER(3)            NOT NULL,
   FLOW_STATE           NUMBER(3)            NOT NULL,
   DOMAIN_ID            NUMBER(19)           NOT NULL,
   REMARK               VARCHAR2(1024),
   SEND_TO              CLOB,
   COPY_TO              CLOB,
   ISSUER               VARCHAR2(255),
   COPIES               INTEGER,
   CONTENT_NO           INTEGER              DEFAULT 0,
   SERIAL_NO            VARCHAR2(255),
   ARCHIVED_TIME        DATE,
   CREATE_USER_ID       INTEGER,
   ACCOUNT_ID           INTEGER,
   STAT_DAY             VARCHAR2(2),
   STAT_QUARTER         VARCHAR2(1),
   UNIT_LEVEL           VARCHAR2(255),
   SEND_TYPE            VARCHAR2(255),
   TEMPLETE_ID          INTEGER,
   ORG_DEPARTMENT_ID    INTEGER,
   PROCESS_TYPE         NUMBER(4),
   CONSTRAINT PK_EDOC_STAT PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_SUMMARY                                          */
/*==============================================================*/
CREATE TABLE EDOC_SUMMARY 
(
   ID                   INTEGER              NOT NULL,
   IDENTIFIER           VARCHAR2(100),
   HAS_ARCHIVE          NUMBER(4)             DEFAULT 0,
   EDOC_TYPE            NUMBER(4)             NOT NULL,
   DEADLINE             INTEGER,
   CAN_TRACK            NUMBER(4)             NOT NULL,
   COMMENTS             VARCHAR2(1024),
   PROCESS_ID           VARCHAR2(100),
   CASE_ID              INTEGER,
   FORM_ID              INTEGER,
   CREATE_TIME          DATE                 NOT NULL,
   START_USER_ID        INTEGER,
   START_TIME           DATE,
   CREATE_PERSON        VARCHAR2(255),
   COMPLETE_TIME        DATE,
   STATE                NUMBER(3,0)          NOT NULL,
   SUBJECT              VARCHAR2(1024)       NOT NULL,
   DOC_TYPE             VARCHAR2(50),
   SEND_TYPE            VARCHAR2(50),
   DOC_MARK             VARCHAR2(255),
   SERIAL_NO            VARCHAR2(255),
   SECRET_LEVEL         VARCHAR2(50),
   URGENT_LEVEL         VARCHAR2(50),
   SEND_UNIT            CLOB,
   SEND_UNIT_ID         CLOB,
   ISSUER               VARCHAR2(255),
   SIGNING_DATE         DATE,
   SEND_TO              CLOB,
   SEND_TO_ID           CLOB,
   COPY_TO              CLOB,
   COPY_TO_ID           CLOB,
   REPORT_TO            CLOB,
   REPORT_TO_ID         CLOB,
   KEYWORDS             VARCHAR2(255),
   PRINT_UNIT           VARCHAR2(255),
   COPIES               INTEGER,
   PRINTER              VARCHAR2(255),
   ADVANCE_REMIND       INTEGER,
   TEMPLETE_ID          INTEGER,
   WORKFLOW_RULE        CLOB,
   PACK_DATE            DATE,
   ISUNIT               NUMBER(4)             DEFAULT 0,
   DOC_MARK2            VARCHAR2(255),
   SEND_UNIT2           CLOB,
   SEND_UNIT_ID2        CLOB,
   SEND_TO2             CLOB,
   SEND_TO_ID2          CLOB,
   COPY_TO2             CLOB,
   COPY_TO_ID2          CLOB,
   REPORT_TO2           CLOB,
   REPORT_TO_ID2        CLOB,
   COPIES2              INTEGER              DEFAULT 0,
   ORG_DEPARTMENT_ID    INTEGER,
   ORG_ACCOUNT_ID       INTEGER,
   UPDATE_TIME          DATE,
   ARCHIVE_ID           INTEGER,
   SUB_EDOC_TYPE        INTEGER,
   FILESM               CLOB,
   FILEFZ               VARCHAR2(255),
   PARTY                VARCHAR2(255),
   ADMINISTRATIVE       VARCHAR2(255),
   SEND_DEPARTMENT      VARCHAR2(255),
   SEND_DEPARTMENT2     VARCHAR2(255),
   SEND_DEPARTMENT_ID   VARCHAR2(255),
   SEND_DEPARTMENT_ID2  VARCHAR2(255),
   ATTACHMENTS          CLOB,
   OVER_WORKTIME        INTEGER,
   RUN_WORKTIME         INTEGER,
   OVER_TIME            INTEGER,
   RUN_TIME             INTEGER,
   KEEP_PERIOD          INTEGER,
   IS_COVER_TIME        NUMBER(4),
   RECEIPT_DATE         DATE,
   REGISTRATION_DATE    DATE,
   AUDITOR              VARCHAR2(255),
   REVIEW               VARCHAR2(255),
   UNDERTAKER           VARCHAR2(1024),
   PHONE                VARCHAR2(255),
   DEADLINE_DATETIME    DATE,
   IS_QUICK_SEND        NUMBER(4)             DEFAULT 0,
   CURRENT_NODES_INFO   CLOB,
   UNDERTAKENOFFICE     CLOB,
   UNDERTAKENOFFICE_ID  CLOB,
   UNIT_LEVEL           VARCHAR2(255),
   TRANSFER_STATUS      NUMBER(3,0),
   GOVDOC_TYPE          INTEGER,
   SIGN_PERSON          VARCHAR2(255),
   SIGN_ACCOUNT_ID      VARCHAR2(255),
   EDOC_SECRET_LEVEL    NUMBER(4),
   JIANBAN_TYPE         INTEGER,
   GOVCODE              VARCHAR2(255),
   TO_EDOC_LIB_FLAG     NUMBER(4),
   TO_EDOC_LIB_TYPE     VARCHAR2(255),
   SEND_DATE            DATE,
   PRINT_UNIT_ID        VARCHAR2(255),
   RECEIVE_UNIT         VARCHAR2(255),
   RECEIVE_UNIT_ID      VARCHAR2(255),
   CHECK_PERSON         VARCHAR2(255),
   PROXY_DATE           DATE,
   PISHI_NO             INTEGER,
   PISHI_NAME           VARCHAR2(255),
   PISHI_YEAR           VARCHAR2(20),
   PISHI_LEADER_NAME    VARCHAR2(255),
   PUBLIC_INFO          VARCHAR2(255),
   FORM_APP_ID          INTEGER,
   NEWFLOW_TYPE         INTEGER,
   ATTACHMENT_ARCHIVE_ID INTEGER,
   CAN_MODIFY           NUMBER(4),
   FORM_RECORDID        INTEGER,
   IS_AUDITED           NUMBER(4),
   VOUCH                NUMBER(4),
   BODY_TYPE            VARCHAR2(50),
   EXCHANGE_TYPE        NUMBER(4),
   CAN_ARCHIVE          NUMBER(4),
   EXCHANGE_SEND_AFFAIRID INTEGER,
   CAN_EDIT_ATTACHMENT  NUMBER(4),
   CAN_MERGE_DEAL       NUMBER(4),
   CAN_ANY_MERGE        NUMBER(4),
   CAN_EDIT             NUMBER(4),
   PROCESS_TYPE         NUMBER(4),
   SECRET_RELATED_LEVEL NUMBER(4),
   FROM_TYPE            NUMBER(4),
   PROCESS_TERM_TYPE    NUMBER(4),
   REMIND_INTERVAL      INTEGER,
   DEAL_SUGGESTION		CLOB,
   MERGE_DEAL_TYPE		VARCHAR2(255),
   AUTO_RUN NUMBER(4),
   CAN_DELETE_NODE NUMBER(4),
   CONSTRAINT PK_EDOC_SUMMARY PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: EDOC_SUMMARY_EXTEND                                   */
/*==============================================================*/
CREATE TABLE EDOC_SUMMARY_EXTEND 
(
   ID                   INTEGER              NOT NULL,
   SUMMARY_ID           INTEGER              NOT NULL,
   APP_TYPE             INTEGER              DEFAULT 4,
   AVARCHAR1            VARCHAR2(255),
   AVARCHAR2            VARCHAR2(255),
   AVARCHAR3            VARCHAR2(255),
   AVARCHAR4            VARCHAR2(255),
   AVARCHAR5            VARCHAR2(255),
   AVARCHAR6            VARCHAR2(255),
   AVARCHAR7            VARCHAR2(255),
   AVARCHAR8            VARCHAR2(255),
   AVARCHAR9            VARCHAR2(255),
   AVARCHAR10           VARCHAR2(255),
   AVARCHAR11           VARCHAR2(255),
   AVARCHAR12           VARCHAR2(255),
   AVARCHAR13           VARCHAR2(255),
   AVARCHAR14           VARCHAR2(255),
   AVARCHAR15           VARCHAR2(255),
   AVARCHAR16           VARCHAR2(255),
   AVARCHAR17           VARCHAR2(255),
   AVARCHAR18           VARCHAR2(255),
   AVARCHAR19           VARCHAR2(255),
   AVARCHAR20           VARCHAR2(255),
   AVARCHAR21           VARCHAR2(255),
   AVARCHAR22           VARCHAR2(255),
   AVARCHAR23           VARCHAR2(255),
   AVARCHAR24           VARCHAR2(255),
   AVARCHAR25           VARCHAR2(255),
   AVARCHAR26           VARCHAR2(255),
   AVARCHAR27           VARCHAR2(255),
   AVARCHAR28           VARCHAR2(255),
   AVARCHAR29           VARCHAR2(255),
   AVARCHAR30           VARCHAR2(255),
   TEXT1                CLOB,
   TEXT2                CLOB,
   TEXT3                CLOB,
   TEXT4                CLOB,
   TEXT5                CLOB,
   TEXT6                CLOB,
   TEXT7                CLOB,
   TEXT8                CLOB,
   TEXT9                CLOB,
   TEXT10               CLOB,
   TEXT11               CLOB,
   TEXT12               CLOB,
   TEXT13               CLOB,
   TEXT14               CLOB,
   TEXT15               CLOB,
   INTEGER1             INTEGER,
   INTEGER2             INTEGER,
   INTEGER3             INTEGER,
   INTEGER4             INTEGER,
   INTEGER5             INTEGER,
   INTEGER6             INTEGER,
   INTEGER7             INTEGER,
   INTEGER8             INTEGER,
   INTEGER9             INTEGER,
   INTEGER10            INTEGER,
   INTEGER11            INTEGER,
   INTEGER12            INTEGER,
   INTEGER13            INTEGER,
   INTEGER14            INTEGER,
   INTEGER15            INTEGER,
   INTEGER16            INTEGER,
   INTEGER17            INTEGER,
   INTEGER18            INTEGER,
   INTEGER19            INTEGER,
   INTEGER20            INTEGER,
   DECIMAL1             NUMBER(16,4),
   DECIMAL2             NUMBER(16,4),
   DECIMAL3             NUMBER(16,4),
   DECIMAL4             NUMBER(16,4),
   DECIMAL5             NUMBER(16,4),
   DECIMAL6             NUMBER(16,4),
   DECIMAL7             NUMBER(16,4),
   DECIMAL8             NUMBER(16,4),
   DECIMAL9             NUMBER(16,4),
   DECIMAL10            NUMBER(16,4),
   DECIMAL11            NUMBER(16,4),
   DECIMAL12            NUMBER(16,4),
   DECIMAL13            NUMBER(16,4),
   DECIMAL14            NUMBER(16,4),
   DECIMAL15            NUMBER(16,4),
   DECIMAL16            NUMBER(16,4),
   DECIMAL17            NUMBER(16,4),
   DECIMAL18            NUMBER(16,4),
   DECIMAL19            NUMBER(16,4),
   DECIMAL20            NUMBER(16,4),
   DATE1                DATE,
   DATE2                DATE,
   DATE3                DATE,
   DATE4                DATE,
   DATE5                DATE,
   DATE6                DATE,
   DATE7                DATE,
   DATE8                DATE,
   DATE9                DATE,
   DATE10               DATE,
   DATE11               DATE,
   DATE12               DATE,
   DATE13               DATE,
   DATE14               DATE,
   DATE15               DATE,
   DATE16               DATE,
   DATE17               DATE,
   DATE18               DATE,
   DATE19               DATE,
   DATE20               DATE,
   LIST1                VARCHAR2(255),
   LIST2                VARCHAR2(255),
   LIST3                VARCHAR2(255),
   LIST4                VARCHAR2(255),
   LIST5                VARCHAR2(255),
   LIST6                VARCHAR2(255),
   LIST7                VARCHAR2(255),
   LIST8                VARCHAR2(255),
   LIST9                VARCHAR2(255),
   LIST10               VARCHAR2(255),
   LIST11               VARCHAR2(255),
   LIST12               VARCHAR2(255),
   LIST13               VARCHAR2(255),
   LIST14               VARCHAR2(255),
   LIST15               VARCHAR2(255),
   LIST16               VARCHAR2(255),
   LIST17               VARCHAR2(255),
   LIST18               VARCHAR2(255),
   LIST19               VARCHAR2(255),
   LIST20               VARCHAR2(255),
   CONSTRAINT PK_EDOC_SUMMARY_EXTEND PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: CTP_SUPERVISOR                                        */
/*==============================================================*/
CREATE TABLE CTP_SUPERVISOR 
(
   ID                   INTEGER              NOT NULL,
   SUPERVISE_ID         INTEGER,
   PERMISSION           NUMBER(4),
   SUPERVISOR_ID        INTEGER,
   ENTITY_ID            INTEGER,
   CONSTRAINT PK_CTP_SUPERVISOR PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: CTP_SUPERVISE_DETAIL                                  */
/*==============================================================*/
CREATE TABLE CTP_SUPERVISE_DETAIL 
(
   ID                   INTEGER              NOT NULL,
   TITLE                VARCHAR2(1024),
   ENTITY_TYPE          NUMBER(4),
   ENTITY_ID            INTEGER,
   SENDER_ID            INTEGER,
   STATUS               NUMBER(4),
   SUPERVISORS          VARCHAR2(1024),
   DESCRIPTION          VARCHAR2(1024),
   COUNT                INTEGER,
   AWAKE_DATE           DATE,
   REMIND_MODE          NUMBER(4),
   SCHEDULE_PROP        VARCHAR2(255),
   CREATE_DATE          DATE,
   TEMPLATE_DATE_TERMINAL INTEGER,
   SUPERVISE_DATE_TYPE  VARCHAR2(255),
   SUBJECT              VARCHAR2(1024),
   ENTITY_CREATE_DATE   DATE,
   ENTITY_SENDER_ID     INTEGER,
   IMPORTANT_LEVEL      NUMBER(4),
   FORWARD_MEMBER       VARCHAR2(255),
   BODY_TYPE            VARCHAR2(255),
   IDENTIFIER           VARCHAR2(255),
   AFFAIR_ID            INTEGER,
   EXT_PROPS            VARCHAR2(2000),
   IS_COVER_TIME        NUMBER(4),
   TEMPLETE_ID          INTEGER,
   RESENT_TIME          NUMBER(4),
   APP                  NUMBER(4),
   PROCESS_DEADLINE_DATE DATE,
   CONSTRAINT PK_CTP_SUPERVISE_DETAIL PRIMARY KEY (ID)
);