/*==============================================================*/
/* Table: COL_SUMMARY                                           */
/*==============================================================*/
CREATE TABLE COL_SUMMARY (
   ID                   BIGINT               NOT NULL,
   STATE                SMALLINT             NULL,
   SUBJECT              NVARCHAR(1024)        NULL,
   DEADLINE             BIGINT               NULL,
   COL_TYPE             SMALLINT             NULL,
   CAN_ARCHIVE          SMALLINT             NULL,
   CAN_MODIFY           SMALLINT             NULL,
   CAN_DUE_REMINDER     SMALLINT             NULL,
   CAN_FORWARD          SMALLINT             NULL,
   CAN_EDIT             SMALLINT             NULL,
   CAN_TRACK            SMALLINT             NULL,
   REMIND_INTERVAL      BIGINT               NULL,
   PROJECT_ID           BIGINT               NULL,
   IMPORTANT_LEVEL      SMALLINT             NULL,
   RESENT_TIME          SMALLINT             NULL,
   CREATE_DATE          DATETIME             NULL,
   START_DATE           DATETIME             NULL,
   FINISH_DATE          DATETIME             NULL,
   IS_AUDITED           SMALLINT             NULL,
   ARCHIVE_ID           BIGINT               NULL,
   START_MEMBER_ID      BIGINT               NULL,
   PROCESS_ID           NVARCHAR(255)         NULL,
   CASE_ID              BIGINT               NULL,
   ADVANCE_REMIND       BIGINT               NULL,
   IDENTIFIER           NVARCHAR(255)         NULL,
   FORWARD_MEMBER       NVARCHAR(255)         NULL,
   TEMPLETE_ID          BIGINT               NULL,
   WORKFLOW_RULE        NTEXT                 NULL,
   WEBSERVICE_CODE      NVARCHAR(255)         NULL,
   BODY_TYPE            NVARCHAR(255)         NULL,
   FORM_RECORDID        BIGINT               NULL,
   FORMID               BIGINT               NULL,
   FORM_APPID           BIGINT               NULL,
   ORG_DEPARTMENT_ID    BIGINT               NULL,
   ORG_ACCOUNT_ID       BIGINT               NULL,
   SOURCE               NVARCHAR(255)         NULL,
   PARENTFORM_SUMMARYID BIGINT               NULL,
   NEWFLOW_TYPE         SMALLINT             NULL,
   CAN_EDIT_ATTACHMENT  SMALLINT             NULL,
   VOUCH                SMALLINT             NULL,
   OVER_WORKTIME        BIGINT               NULL,
   RUN_WORKTIME         BIGINT               NULL,
   OVER_TIME            BIGINT               NULL,
   RUN_TIME             BIGINT               NULL,
   CAN_AUTOSTOPFLOW     SMALLINT             NULL,
   IS_COVER_TIME        SMALLINT             NULL,
   DEADLINE_DATETIME    DATETIME             NULL,
   CURRENT_NODES_INFO   NVARCHAR(255)         NULL,
   CAN_MERGE_DEAL       SMALLINT             NULL,
   ADVANCE_PIGEONHOLE   NVARCHAR(4000)        NULL,
   CAN_ANY_MERGE        SMALLINT             NULL,
   PROCESS_NODES_INFO   NTEXT                 NULL,
   PERMISSION_ACCOUNT_ID BIGINT               NULL,
   REPLY_COUNTS         SMALLINT             NULL,
   AUTO_RUN             SMALLINT             NULL,
   ATTACHMENT_ARCHIVE_ID BIGINT               NULL,
   PROCESS_TERM_TYPE    SMALLINT             NULL,
   MERGE_DEAL_TYPE      NVARCHAR(255)         NULL,
   SUB_STATE            SMALLINT             NULL,
   RELATION_ID			BIGINT,
   MESSAGE_RULE_ID		NVARCHAR(500),
   CAN_DELETE_NODE SMALLINT,
   NODES_INFO NVARCHAR(4000),
   CONSTRAINT PK_COL_SUMMARY PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: CTP_AFFAIR                                            */
/*==============================================================*/
CREATE TABLE CTP_AFFAIR (
   ID                   BIGINT               NOT NULL,
   IS_COVER_TIME        SMALLINT             NULL,
   MEMBER_ID            BIGINT               NULL,
   SENDER_ID            BIGINT               NULL,
   SUBJECT              NVARCHAR(1024)        NULL,
   APP                  SMALLINT             NULL,
   OBJECT_ID            BIGINT               NULL,
   SUB_OBJECT_ID        BIGINT               NULL,
   STATE                SMALLINT             NULL,
   SUB_STATE            SMALLINT             NULL,
   HASTEN_TIMES         SMALLINT             NULL,
   REMIND_DATE          BIGINT               NULL,
   DEADLINE_DATE        BIGINT               NULL,
   CAN_DUE_REMIND       SMALLINT             NULL,
   CREATE_DATE          DATETIME             NULL,
   RECEIVE_TIME         DATETIME             NULL,
   COMPLETE_TIME        DATETIME             NULL,
   REMIND_INTERVAL      SMALLINT             NULL,
   IS_DELETE            SMALLINT             NULL,
   TRACK                SMALLINT             NULL,
   ARCHIVE_ID           BIGINT               NULL,
   ADDITION             NVARCHAR(2000)        NULL,
   EXT_PROPS            NVARCHAR(2000)        NULL,
   UPDATE_DATE          DATETIME             NULL,
   IS_FINISH            SMALLINT             NULL,
   BODY_TYPE            NVARCHAR(255)         NULL,
   IMPORTANT_LEVEL      SMALLINT             NULL,
   RESENT_TIME          SMALLINT             NULL,
   FORWARD_MEMBER       NVARCHAR(255)         NULL,
   IDENTIFIER           NVARCHAR(255)         NULL,
   TRANSACTOR_ID        BIGINT               NULL,
   NODE_POLICY          NVARCHAR(255)         NULL,
   ACTIVITY_ID          BIGINT               NULL,
   FORM_APP_ID          BIGINT               NULL,
   FORM_ID              BIGINT               NULL,
   FORM_OPERATION_ID    BIGINT               NULL,
   TEMPLETE_ID          BIGINT               NULL,
   FROM_ID              BIGINT               NULL,
   OVER_WORKTIME        BIGINT               NULL,
   RUN_WORKTIME         BIGINT               NULL,
   OVER_TIME            BIGINT               NULL,
   RUN_TIME             BIGINT               NULL,
   DEAL_TERM_TYPE       SMALLINT             NULL,
   DEAL_TERM_USERID     BIGINT               NULL,
   SUB_APP              SMALLINT             NULL,
   EXPECTED_PROCESS_TIME DATETIME             NULL,
   ORG_ACCOUNT_ID       BIGINT               NULL,
   PROCESS_ID           NVARCHAR(255)         NULL,
   IS_PROCESS_OVER_TIME SMALLINT             NULL,
   FORM_MULTI_OPERATION_ID NVARCHAR(4000)        NULL,
   BACK_FROM_ID         BIGINT               NULL,
   FORM_RELATIVE_STATIC_IDS NVARCHAR(255)         NULL,
   FORM_RELATIVE_QUERY_IDS NVARCHAR(255)         NULL,
   HAS_FAVORITE         SMALLINT             NULL,
   FROM_TYPE            SMALLINT             NULL,
   FORM_RECORDID        BIGINT               NULL,
   CASE_ID              BIGINT               NULL,
   RELATION_DATA_ID     BIGINT               NULL,
   FIRSTVIEW_PERIOD     BIGINT               NULL,
   FIRSTVIEW_DATE       DATETIME             NULL,
   FIRSTRESPONSE_PERIOD BIGINT               NULL,
   SIGNLEVIEW_PERIOD    BIGINT               NULL,
   PRE_APPROVER         BIGINT               NULL,
   AUTO_RUN             SMALLINT             NULL,
   SUMMARY_STATE        SMALLINT             NULL,
   TOP_TIME             DATETIME             NULL,
   SORT_WEIGHT          SMALLINT             NULL,
   AI_PROCESSING        SMALLINT             NULL,
   PROCESS_DEADLINE_TIME DATETIME,
   PROXY_MEMBER_ID		BIGINT,
   MATCH_DEPARTMENT_ID	BIGINT,
   MATCH_POST_ID   		BIGINT,
   NODE_NAME			NVARCHAR(500),
   MATCH_ACCOUNT_ID     BIGINT,
   PRINT_NM				SMALLINT,
   MESSAGE_RULE_ID		NVARCHAR(1000),
   MATCH_ROLE_ID BIGINT,
   CONSTRAINT PK_CTP_AFFAIR PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: CTP_COMMENT_ALL                                       */
/*==============================================================*/
CREATE TABLE CTP_COMMENT_ALL (
   ID                   BIGINT               NOT NULL,
   CREATE_ID            BIGINT               NULL,
   CREATE_DATE          DATETIME             NULL,
   MODIFY_DATE          DATETIME             NULL,
   MODULE_TYPE          SMALLINT             NULL DEFAULT 0,
   MODULE_ID            BIGINT               NULL,
   CTYPE                SMALLINT             NULL DEFAULT 0,
   CONTENT              NTEXT                 NULL,
   TITLE                NVARCHAR(1024)        NULL,
   IS_HIDDEN            SMALLINT             NULL DEFAULT 0,
   SHOW_TO_ID           NTEXT                 NULL,
   PATH                 NVARCHAR(500)         NULL,
   CLEVEL               SMALLINT             NULL DEFAULT 0,
   PID                  BIGINT               NULL,
   RELATE_INFO          NTEXT                 NULL,
   EXT_ATT1             NVARCHAR(100)         NULL,
   EXT_ATT2             NVARCHAR(100)         NULL,
   EXT_ATT3             NVARCHAR(100)         NULL,
   AFFAIR_ID            BIGINT               NULL,
   FORWARD_COUNT        SMALLINT             NULL,
   PRAISE_TO_SUMMARY    SMALLINT             NULL,
   PRAISE_NUMBER        INT                  NULL,
   PRAISE_MEMBER_IDS    NTEXT                 NULL,
   RICH_CONTENT         NTEXT                 NULL,
   DEPARTMENT_ID		BIGINT,
   POST_ID				BIGINT,
   ACCOUNT_ID           BIGINT,
   EXT_ATT4 NVARCHAR(50),
   MATCH_ROLE_ID BIGINT,
   ACCOUNT_NAME NVARCHAR(255),
   DEPARTMENT_NAME NVARCHAR(255),
   POST_NAME NVARCHAR(255),
   ROLE_NAME NVARCHAR(255),
   HAS_WF_OPERATION SMALLINT,
   DEAL_LOCALE NVARCHAR(50),
   SUB_TYPE SMALLINT,
   CREATE_NAME NVARCHAR(255),
   CONSTRAINT PK_CTP_COMMENT_ALL PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: CTP_CONTENT_ALL                                       */
/*==============================================================*/
CREATE TABLE CTP_CONTENT_ALL (
   ID                   BIGINT               NOT NULL,
   CREATE_ID            BIGINT               NULL,
   CREATE_DATE          DATETIME             NULL,
   MODIFY_ID            BIGINT               NULL,
   MODIFY_DATE          DATETIME             NULL,
   MODULE_TYPE          SMALLINT             NULL DEFAULT 0,
   MODULE_ID            BIGINT               NULL,
   MODULE_TEMPLATE_ID   BIGINT               NULL,
   CONTENT_TYPE         SMALLINT             NULL DEFAULT 0,
   CONTENT              NTEXT                 NULL,
   CONTENT_DATA_ID      BIGINT               NULL,
   CONTENT_TEMPLATE_ID  BIGINT               NULL,
   TITLE                NVARCHAR(1024)        NULL,
   SORT                 SMALLINT             NULL DEFAULT 0,
   CONSTRAINT PK_CTP_CONTENT_ALL PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: CTP_PROCESS_HISTORY_LOG                               */
/*==============================================================*/
CREATE TABLE CTP_PROCESS_HISTORY_LOG (
   ID                   BIGINT               NOT NULL,
   PROCESS_ID           BIGINT               NOT NULL,
   ACTIVITY_ID          BIGINT               NOT NULL,
   ACTION_ID            INT                  NOT NULL,
   ACTION_USER_ID       BIGINT               NOT NULL,
   PARAM0               NVARCHAR(1024)        NULL,
   PARAM1               NVARCHAR(1024)        NULL,
   PARAM2               NVARCHAR(1024)        NULL,
   PARAM3               NVARCHAR(1024)        NULL,
   PARAM4               NVARCHAR(1024)        NULL,
   PARAM5               NVARCHAR(4000)        NULL,
   ACTION_TIME          DATETIME             NULL,
   ACTION_DESC          NVARCHAR(1024)        NULL,
   COMMENT_ID           BIGINT               NULL,
   DETAIL_STATUS        SMALLINT             NULL,
   CONSTRAINT PK_CTP_PROCESS_HISTORY_LOG PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: CTP_PROCESS_LOG                                       */
/*==============================================================*/
CREATE TABLE CTP_PROCESS_LOG (
   ID                   BIGINT               NOT NULL,
   PROCESS_ID           BIGINT               NOT NULL,
   ACTIVITY_ID          BIGINT               NOT NULL,
   ACTION_ID            INT                  NOT NULL,
   ACTION_USER_ID       BIGINT               NOT NULL,
   PARAM0               NVARCHAR(1024)        NULL,
   PARAM1               NVARCHAR(1024)        NULL,
   PARAM2               NVARCHAR(1024)        NULL,
   PARAM3               NVARCHAR(1024)        NULL,
   PARAM4               NVARCHAR(1024)        NULL,
   PARAM5               NVARCHAR(4000)        NULL,
   ACTION_TIME          DATETIME             NULL,
   ACTION_DESC          NVARCHAR(1024)        NULL,
   COMMENT_ID           BIGINT               NULL,
   DETAIL_STATUS        SMALLINT             NULL,
   CONSTRAINT PK_CTP_PROCESS_LOG PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: WF_CASE_HISTORY                                       */
/*==============================================================*/
CREATE TABLE WF_CASE_HISTORY (
   ID                   BIGINT               NOT NULL,
   CASENAME             NVARCHAR(100)         NULL,
   STARTUSER            NVARCHAR(36)          NOT NULL,
   LASTPERFORMER        NVARCHAR(36)          NULL,
   STATE                INT                  NOT NULL,
   SUBPROCESS           INT                  NULL,
   STARTSUBPROCESSNUM   INT                  NULL,
   PROCESSINDEX         NVARCHAR(110)         NOT NULL,
   PROCESSNAME          NVARCHAR(100)         NOT NULL,
   PROCESSID            NVARCHAR(100)         NOT NULL,
   STARTDATE            BIGINT               NOT NULL,
   UPDATEDATE           BIGINT               NOT NULL,
   CASEOBJECT           IMAGE            NULL,
   CASE_CONTENT         NTEXT,
   CONSTRAINT PK_WF_CASE_HISTORY PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: WF_CASE_RUN                                           */
/*==============================================================*/
CREATE TABLE WF_CASE_RUN (
   ID                   BIGINT               NOT NULL,
   CASENAME             NVARCHAR(100)         NULL,
   STARTUSER            NVARCHAR(36)          NOT NULL,
   LASTPERFORMER        NVARCHAR(36)          NULL,
   STATE                INT                  NOT NULL,
   SUBPROCESS           INT                  NULL,
   STARTSUBPROCESSNUM   INT                  NULL,
   PROCESSINDEX         NVARCHAR(110)         NOT NULL,
   PROCESSNAME          NVARCHAR(100)         NOT NULL,
   PROCESSID            NVARCHAR(100)         NOT NULL,
   STARTDATE            BIGINT               NOT NULL,
   UPDATEDATE           BIGINT               NOT NULL,
   CASEOBJECT           IMAGE            NULL,
   CASE_CONTENT         NTEXT,
   CONSTRAINT PK_WF_CASE_RUN PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: WF_PROCESS_RUNNING                                    */
/*==============================================================*/
CREATE TABLE WF_PROCESS_RUNNING (
   ID                   NVARCHAR(110)         NOT NULL,
   TEMPLETE_ID          BIGINT               NULL,
   PROCESSOBJECT        IMAGE            NULL,
   CREATEDATE           BIGINT               NULL,
   STATE                SMALLINT             NULL DEFAULT 0,
   PROCESS_XML          NTEXT,
   CONSTRAINT PK_WF_PROCESS_RUNNING PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: WF_SUBPROCESS_RUNNING                                 */
/*==============================================================*/
CREATE TABLE WF_SUBPROCESS_RUNNING (
   ID                   BIGINT               NOT NULL,
   SUBJECT              NVARCHAR(255)         NULL,
   NEW_ID               BIGINT               NULL,
   MAIN_TEMPLETE_ID     BIGINT               NULL,
   MAIN_NODE_ID         NVARCHAR(255)         NULL,
   MAIN_CASE_ID         BIGINT               NULL,
   MAIN_PROCESS_ID      NVARCHAR(255)         NULL,
   TRIGGER_CONDITION    NTEXT                 NULL,
   CONDITION_TITLE      NTEXT                 NULL,
   CONDITION_BASE       NVARCHAR(255)         NULL,
   IS_FORCE             SMALLINT             NULL,
   FLOW_RELATE_TYPE     SMALLINT             NULL,
   CAN_VIEW_BY_MAIN     SMALLINT             NULL,
   CAN_VIEW_MAIN        SMALLINT             NULL,
   SENDER               NVARCHAR(255)         NULL,
   SENDER_ID            BIGINT               NULL,
   TEMPLETE_ID          BIGINT               NULL,
   CASE_ID              BIGINT               NULL,
   PROCESS_ID           NVARCHAR(255)         NULL,
   CREATE_TIME          DATETIME             NULL,
   UPDATE_TIME          DATETIME             NULL,
   BUSSINESS_TYPE       NVARCHAR(255)         NULL,
   BUSSINESS_ID         NVARCHAR(255)         NULL,
   IS_FINISHED          SMALLINT             NULL,
   IS_ACTIVATE          SMALLINT             NULL DEFAULT 0,
   IS_DELETE            SMALLINT             NULL DEFAULT 0,
   CONSTRAINT PK_WF_SUBPROCESS_RUNNING PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: WF_WORKITEM_HISTORY                                   */
/*==============================================================*/
CREATE TABLE WF_WORKITEM_HISTORY (
   ID                   BIGINT               NOT NULL,
   CASEID               BIGINT               NOT NULL,
   BATCH                BIGINT               NOT NULL,
   ITEMNUM              INT                  NOT NULL,
   WF_DOMAIN            NVARCHAR(100)         NOT NULL,
   NAME                 NVARCHAR(255)         NULL DEFAULT '-',
   CASENAME             NVARCHAR(100)         NULL,
   PROCESSID            NVARCHAR(100)         NOT NULL,
   PROCESSINDEX         NVARCHAR(100)         NOT NULL,
   PROCESSNAME          NVARCHAR(100)         NULL,
   ACTIVITYID           NVARCHAR(36)          NOT NULL,
   ACTIVITYNAME         NVARCHAR(255)         NULL,
   PERFORMER            NVARCHAR(255)         NULL,
   FINISHER             NVARCHAR(64)          NULL,
   OWNER                NVARCHAR(64)          NULL,
   ENTRUSTER            NVARCHAR(64)          NULL,
   DELEGATER            NVARCHAR(64)          NULL,
   LEVELNUM             INT                  NOT NULL,
   CANREASSIGN          INT                  NOT NULL,
   CANRETURN            INT                  NOT NULL,
   CANDELEGATE          INT                  NOT NULL,
   CANENTRUST           INT                  NOT NULL,
   CANREVIEW            INT                  NOT NULL,
   NEXTSTATUS           NVARCHAR(36)          NULL,
   NEXTLINKID           NVARCHAR(36)          NULL,
   DATAMAP              IMAGE            NULL,
   OLDSTATE             INT                  NULL,
   STATE                INT                  NOT NULL,
   CREATEDATE           BIGINT               NOT NULL,
   UPDATEDATE           BIGINT               NOT NULL,
   DEADLINE             BIGINT               NULL,
   ACTIONSTATE          NVARCHAR(500)         NULL,
   SORT                 INT                  NOT NULL DEFAULT 0,
   CONSTRAINT PK_WF_WORKITEM_HISTORY PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: WF_WORKITEM_RUN                                       */
/*==============================================================*/
CREATE TABLE WF_WORKITEM_RUN (
   ID                   BIGINT               NOT NULL,
   CASEID               BIGINT               NULL,
   BATCH                BIGINT               NULL,
   ITEMNUM              INT                  NULL,
   WF_DOMAIN            NVARCHAR(100)         NULL,
   NAME                 NVARCHAR(255)         NULL,
   CASENAME             NVARCHAR(100)         NULL,
   PROCESSID            NVARCHAR(100)         NULL,
   PROCESSINDEX         NVARCHAR(100)         NULL,
   PROCESSNAME          NVARCHAR(100)         NULL,
   ACTIVITYID           NVARCHAR(36)          NULL,
   ACTIVITYNAME         NVARCHAR(255)         NULL,
   PERFORMER            NVARCHAR(255)         NULL,
   FINISHER             NVARCHAR(64)          NULL,
   OWNER                NVARCHAR(64)          NULL,
   ENTRUSTER            NVARCHAR(64)          NULL,
   DELEGATER            NVARCHAR(64)          NULL,
   LEVELNUM             INT                  NULL,
   CANREASSIGN          INT                  NULL,
   CANRETURN            INT                  NULL,
   CANDELEGATE          INT                  NULL,
   CANENTRUST           INT                  NULL,
   CANREVIEW            INT                  NULL,
   NEXTSTATUS           NVARCHAR(36)          NULL,
   NEXTLINKID           NVARCHAR(36)          NULL,
   DATAMAP              IMAGE            NULL,
   OLDSTATE             INT                  NULL,
   STATE                INT                  NULL,
   CREATEDATE           BIGINT               NULL,
   UPDATEDATE           BIGINT               NULL,
   DEADLINE             BIGINT               NULL,
   ACTIONSTATE          NVARCHAR(500)         NULL,
   SORT                 INT                  NULL DEFAULT 0,
   CONSTRAINT PK_WF_WORKITEM_RUN PRIMARY KEY NONCLUSTERED (ID)
);
CREATE TABLE CTP_CONFIG (
   ID                   BIGINT               NOT NULL,
   CONFIG_CATEGORY      NVARCHAR(100)         NULL,
   CONFIG_CATEGORY_NAME NVARCHAR(100)         NULL,
   CONFIG_ITEM          NVARCHAR(100)         NULL,
   CONFIG_VALUE         NVARCHAR(1000)        NULL,
   CONFIG_DESCRIPTION   NVARCHAR(255)         NULL,
   CREATE_DATE          DATETIME             NULL,
   MODIFY_DATE          DATETIME             NULL,
   CONFIG_TYPE          NVARCHAR(100)         NULL,
   EXT_CONFIG_VALUE     NTEXT                 NULL,
   ORG_ACCOUNT_ID       BIGINT               NULL,
   SORT                 INT                  NULL,
   CONSTRAINT PK_CTP_CONFIG PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: EDOC_BODY                                             */
/*==============================================================*/
CREATE TABLE EDOC_BODY (
   ID                   BIGINT               NOT NULL,
   CONTENT_TYPE         NVARCHAR(20)          NOT NULL,
   CONTENT              NTEXT                 NULL,
   EDOC_ID              BIGINT               NULL,
   CREATE_TIME          DATETIME             NOT NULL,
   LAST_UPDATE          DATETIME             NOT NULL,
   CONTENT_NAME         NVARCHAR(32)          NULL,
   CONTENT_STATUS       SMALLINT             NULL,
   CONTENT_NO           BIGINT               NULL DEFAULT 0,
   CONSTRAINT PK_EDOC_BODY PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: EDOC_EXCHANGE_RECIEVE                                 */
/*==============================================================*/
CREATE TABLE EDOC_EXCHANGE_RECIEVE (
   ID                   BIGINT               NOT NULL,
   SUBJECT              NVARCHAR(1024)        NOT NULL,
   DOC_TYPE             NVARCHAR(255)         NULL,
   DOC_MARK             NVARCHAR(255)         NULL,
   SECRET_LEVEL         NVARCHAR(50)         NULL,
   URGENT_LEVEL         NVARCHAR(50)         NULL,
   KEEP_PERIOD          NVARCHAR(255)         NULL,
   SEND_UNIT            NVARCHAR(255)         NOT NULL,
   SENDER               NVARCHAR(255)         NULL,
   ISSUER               NVARCHAR(255)         NULL,
   ISSUE_DATE           DATETIME             NULL,
   SEND_TO              NTEXT                 NULL,
   COPY_TO              NTEXT                 NULL,
   REPORT_TO            NTEXT                 NULL,
   EDOC_ID              BIGINT               NULL,
   FILE_ID              BIGINT               NULL,
   FROM_INTERNAL        NUMERIC(3)           NOT NULL,
   REPLY_ID             NVARCHAR(255)         NULL,
   REC_NO               NVARCHAR(255)         NULL,
   REC_USER_ID          BIGINT               NULL,
   REC_TIME             DATETIME             NULL,
   REMARK               NVARCHAR(255)         NULL,
   REGISTER_USER_ID     NUMERIC(19)          NULL,
   REGISTER_TIME        DATETIME             NULL,
   EXCHANGE_ORG_ID      NUMERIC(19)          NOT NULL,
   EXCHANGE_TYPE        NUMERIC(3)           NOT NULL,
   CREATE_TIME          DATETIME             NOT NULL,
   STATUS               NUMERIC(3)           NOT NULL,
   CONTENT_NO           SMALLINT             NULL DEFAULT 0,
   STEPBACKINFO         NVARCHAR(4000)        NULL,
   IS_RETREAT           NUMERIC(3)           NULL,
   SEND_UNIT_TYPE       NUMERIC(3)           NULL,
   RECIVE_EDOC_ID       NUMERIC(19)          NULL,
   IS_TURN_REC          SMALLINT             NULL DEFAULT 0,
   EXCHANGE_MODE        SMALLINT             NULL DEFAULT 0,
   CONSTRAINT PK_EDOC_EXCHANGE_RECIEVE PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: EDOC_EXCHANGE_SEND                                    */
/*==============================================================*/
CREATE TABLE EDOC_EXCHANGE_SEND (
   ID                   BIGINT               NOT NULL,
   SUBJECT              NVARCHAR(1024)        NOT NULL,
   DOC_TYPE             NVARCHAR(255)         NULL,
   DOC_MARK             NVARCHAR(255)         NULL,
   SECRET_LEVEL         NVARCHAR(50)         NULL,
   URGENT_LEVEL         NVARCHAR(50)         NULL,
   SEND_UNIT            NVARCHAR(255)         NOT NULL,
   ISSUER               NVARCHAR(255)         NULL,
   ISSUE_DATE           DATETIME             NULL,
   COPIES               BIGINT               NULL,
   EDOC_ID              BIGINT               NOT NULL,
   EXCHANGE_ORG_ID      BIGINT               NOT NULL,
   EXCHANGE_TYPE        NUMERIC(3)           NOT NULL,
   SEND_USER_ID         BIGINT               NULL,
   SEND_TIME            DATETIME             NULL,
   CREATE_TIME          DATETIME             NOT NULL,
   STATUS               NUMERIC(3)           NOT NULL,
   CONTENT_NO           SMALLINT             NULL DEFAULT 0,
   SENDED_TYPEIDS       NTEXT                 NULL,
   STEPBACK_INFO        NVARCHAR(1024)        NULL,
   ASSIGN_TYPE          SMALLINT             NULL DEFAULT 0,
   IS_BASE              SMALLINT             NULL DEFAULT 0,
   IS_TURN_REC          SMALLINT             NULL DEFAULT 0,
   SENDED_NAMES         NTEXT                 NULL,
   EXCHANGE_MODE        SMALLINT             NULL DEFAULT 0,
   EXCHANGE_ACCOUNT_ID  BIGINT               NULL,
   CONSTRAINT PK_EDOC_EXCHANGE_SEND PRIMARY KEY NONCLUSTERED (ID)
);


/*==============================================================*/
/* Table: EDOC_EXCHANGE_SEND_DETAIL                             */
/*==============================================================*/
CREATE TABLE EDOC_EXCHANGE_SEND_DETAIL (
   ID                   BIGINT               NOT NULL,
   SEND_EDOC_ID         BIGINT               NULL,
   REC_ORG_ID           NVARCHAR(255)         NOT NULL,
   REC_ORG_TYPE         NUMERIC(3)           NOT NULL,
   REC_ORG_NAME         NVARCHAR(255)         NULL,
   SEND_TYPE            NUMERIC(3)           NOT NULL,
   CONTENT              NVARCHAR(255)         NULL,
   REC_NO               NVARCHAR(255)         NULL,
   REC_USER_NAME        NVARCHAR(255)         NULL,
   REC_TIME             DATETIME             NULL,
   STATUS               NUMERIC(3)           NOT NULL,
   CUIBAN_NUM           SMALLINT             NULL DEFAULT 0,
   CONSTRAINT PK_EDOC_EXCHANGE_SEND_DETAIL PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: EDOC_OPINION                                          */
/*==============================================================*/
CREATE TABLE EDOC_OPINION (
   ID                   BIGINT               NOT NULL,
   EDOC_ID              BIGINT               NULL,
   AFFAIR_ID            BIGINT               NOT NULL,
   ATTRIBUTE            INT                  NOT NULL,
   OPINION_TYPE         INT                  NULL,
   CONTENT              NTEXT                 NULL,
   IS_HIDDEN            NUMERIC(3)           NOT NULL,
   CREATE_USER_ID       NUMERIC(19)          NOT NULL,
   CREATE_TIME          DATETIME             NOT NULL,
   POLICY               NVARCHAR(255)         NULL,
   PROXY_NAME           NVARCHAR(255)         NULL,
   NODE_ID              NUMERIC(19)          NULL DEFAULT -1,
   STATE                SMALLINT             NULL DEFAULT 0,
   SUB_EDOC_ID          BIGINT               NULL,
   UPDATE_TIME          DATETIME             NULL,
   SUB_OPINION_ID       BIGINT               NULL,
   DEPARTMENT_NAME      NVARCHAR(500)         NULL,
   ACCOUNT_NAME         NVARCHAR(500)         NULL,
   DEPARTMENT_SORT_ID   INT                  NULL,
   SOURCE_SUMMARY_ID    BIGINT               NULL,
   CONSTRAINT PK_EDOC_OPINION PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: EDOC_REGISTER                                         */
/*==============================================================*/
CREATE TABLE EDOC_REGISTER (
   ID                   BIGINT               NOT NULL,
   IDENTIFIER           NVARCHAR(100)         NOT NULL,
   RECIEVE_ID           BIGINT               NOT NULL,
   EDOC_ID              BIGINT               NOT NULL,
   EDOC_TYPE            NUMERIC(3)           NULL,
   REGISTER_TYPE        NUMERIC(3)           NULL,
   CREATE_USER_ID       BIGINT               NULL,
   CREATE_USER_NAME     NVARCHAR(255)         NULL,
   CREATE_TIME          DATETIME             NULL,
   UPDATE_TIME          DATETIME             NULL,
   SEND_UNIT            NTEXT                 NULL,
   SEND_UNIT_ID         BIGINT               NULL,
   SEND_UNIT_TYPE       NUMERIC(3)           NULL,
   EDOC_UNIT            NTEXT                 NULL,
   EDOC_UNIT_ID         NTEXT                 NULL,
   EDOC_DATE            DATETIME             NULL,
   REGISTER_USER_ID     BIGINT               NULL,
   REGISTER_USER_NAME   NVARCHAR(255)         NULL,
   REGISTER_DATE        DATETIME             NULL,
   ISSUER_ID            BIGINT               NULL,
   ISSUER               NVARCHAR(255)         NULL,
   ISSUE_DATE           DATETIME             NULL,
   SIGNER               NVARCHAR(255)         NULL,
   DISTRIBUTER_ID       BIGINT               NULL,
   DISTRIBUTER          NVARCHAR(255)         NULL,
   DISTRIBUTE_DATE      DATETIME             NULL,
   DISTRIBUTE_STATE     NUMERIC(3)           NULL,
   DISTRIBUTE_EDOC_ID   BIGINT               NULL,
   SUBJECT              NVARCHAR(1024)        NULL,
   DOC_TYPE             NVARCHAR(255)         NULL,
   SEND_TYPE            NVARCHAR(255)         NULL,
   DOC_MARK             NVARCHAR(255)         NULL,
   SERIAL_NO            NVARCHAR(255)         NULL,
   SECRET_LEVEL         NVARCHAR(255)         NULL,
   URGENT_LEVEL         NVARCHAR(255)         NULL,
   KEEP_PERIOD          NVARCHAR(255)         NULL,
   SEND_TO              NTEXT                 NULL,
   SEND_TO_ID           NTEXT                 NULL,
   COPY_TO              NTEXT                 NULL,
   COPY_TO_ID           NTEXT                 NULL,
   KEYWORDS             NVARCHAR(255)         NULL,
   COPIES               NUMERIC(10,2)        NULL,
   NOTE_APPEND          NVARCHAR(1024)        NULL,
   ATT_NOTE             NVARCHAR(1024)        NULL,
   STATE                NUMERIC(3)           NULL,
   ORG_ACCOUNT_ID       BIGINT               NULL,
   REC_TIME             DATETIME             NULL,
   IS_RETREAT           NUMERIC(3)           NULL,
   AUTO_REGISTER        SMALLINT             NULL DEFAULT 0,
   RECIEVE_USER_ID      BIGINT               NULL,
   RECIEVE_USER_NAME    NVARCHAR(100)         NULL,
   EXCHANGE_MODE        SMALLINT             NULL DEFAULT 0,
   UNIT_LEVEL           NVARCHAR(255)         NULL,
   EXCHANGE_SEND_TIME   DATETIME             NULL,
   CONSTRAINT PK_EDOC_REGISTER PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: EDOC_STAT                                             */
/*==============================================================*/
CREATE TABLE EDOC_STAT (
   ID                   BIGINT               NOT NULL,
   EDOC_ID              BIGINT               NOT NULL,
   EDOC_TYPE            NUMERIC(3)           NOT NULL,
   SUBJECT              NVARCHAR(1024)        NOT NULL,
   DOC_TYPE             NVARCHAR(50)         NULL,
   DOC_MARK             NVARCHAR(255)         NULL,
   DEPT_ID              BIGINT               NOT NULL,
   CREATE_DATE          DATETIME             NULL,
   IS_SENT              NUMERIC(3)           NULL,
   YEAR                 NVARCHAR(4)           NULL,
   MONTH                NVARCHAR(2)           NULL,
   IS_ARCHIVED          NUMERIC(3)           NOT NULL,
   FLOW_STATE           NUMERIC(3)           NOT NULL,
   DOMAIN_ID            NUMERIC(19)          NOT NULL,
   REMARK               NVARCHAR(1024)        NULL,
   SEND_TO              NTEXT                 NULL,
   COPY_TO              NTEXT                 NULL,
   ISSUER               NVARCHAR(255)         NULL,
   COPIES               INT                  NULL,
   CONTENT_NO           BIGINT               NULL DEFAULT 0,
   SERIAL_NO            NVARCHAR(255)         NULL,
   ARCHIVED_TIME        DATETIME             NULL,
   CREATE_USER_ID       BIGINT               NULL,
   ACCOUNT_ID           BIGINT               NULL,
   STAT_DAY             NVARCHAR(2)           NULL,
   STAT_QUARTER         NVARCHAR(1)           NULL,
   UNIT_LEVEL           NVARCHAR(255)         NULL,
   SEND_TYPE            NVARCHAR(255)         NULL,
   TEMPLETE_ID          BIGINT               NULL,
   ORG_DEPARTMENT_ID    BIGINT               NULL,
   PROCESS_TYPE         SMALLINT             NULL,
   CONSTRAINT PK_EDOC_STAT PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: EDOC_SUMMARY                                          */
/*==============================================================*/
CREATE TABLE EDOC_SUMMARY (
   ID                   BIGINT               NOT NULL,
   IDENTIFIER           NVARCHAR(100)         NULL,
   HAS_ARCHIVE          SMALLINT             NULL DEFAULT 0,
   EDOC_TYPE            SMALLINT             NOT NULL,
   DEADLINE             BIGINT               NULL,
   CAN_TRACK            SMALLINT             NOT NULL,
   COMMENTS             NVARCHAR(1024)        NULL,
   PROCESS_ID           NVARCHAR(100)         NULL,
   CASE_ID              BIGINT               NULL,
   FORM_ID              BIGINT               NULL,
   CREATE_TIME          DATETIME             NOT NULL,
   START_USER_ID        BIGINT               NULL,
   START_TIME           DATETIME             NULL,
   CREATE_PERSON        NVARCHAR(255)         NULL,
   COMPLETE_TIME        DATETIME             NULL,
   STATE                DECIMAL(3,0)         NOT NULL,
   SUBJECT              NVARCHAR(1024)        NOT NULL,
   DOC_TYPE             NVARCHAR(50)         NULL,
   SEND_TYPE            NVARCHAR(50)         NULL,
   DOC_MARK             NVARCHAR(255)         NULL,
   SERIAL_NO            NVARCHAR(255)         NULL,
   SECRET_LEVEL         NVARCHAR(50)         NULL,
   URGENT_LEVEL         NVARCHAR(50)         NULL,
   SEND_UNIT            NTEXT                 NULL,
   SEND_UNIT_ID         NTEXT                 NULL,
   ISSUER               NVARCHAR(255)         NULL,
   SIGNING_DATE         DATETIME             NULL,
   SEND_TO              NTEXT                 NULL,
   SEND_TO_ID           NTEXT                 NULL,
   COPY_TO              NTEXT                 NULL,
   COPY_TO_ID           NTEXT                 NULL,
   REPORT_TO            NTEXT                 NULL,
   REPORT_TO_ID         NTEXT                 NULL,
   KEYWORDS             NVARCHAR(255)         NULL,
   PRINT_UNIT           NVARCHAR(255)         NULL,
   COPIES               INT                  NULL,
   PRINTER              NVARCHAR(255)         NULL,
   ADVANCE_REMIND       BIGINT               NULL,
   TEMPLETE_ID          BIGINT               NULL,
   WORKFLOW_RULE        NTEXT                 NULL,
   PACK_DATE            DATETIME             NULL,
   ISUNIT               SMALLINT             NULL DEFAULT 0,
   DOC_MARK2            NVARCHAR(255)         NULL,
   SEND_UNIT2           NTEXT                 NULL,
   SEND_UNIT_ID2        NTEXT                 NULL,
   SEND_TO2             NTEXT                 NULL,
   SEND_TO_ID2          NTEXT                 NULL,
   COPY_TO2             NTEXT                 NULL,
   COPY_TO_ID2          NTEXT                 NULL,
   REPORT_TO2           NTEXT                 NULL,
   REPORT_TO_ID2        NTEXT                 NULL,
   COPIES2              INT                  NULL DEFAULT 0,
   ORG_DEPARTMENT_ID    BIGINT               NULL,
   ORG_ACCOUNT_ID       BIGINT               NULL,
   UPDATE_TIME          DATETIME             NULL,
   ARCHIVE_ID           BIGINT               NULL,
   SUB_EDOC_TYPE        BIGINT               NULL,
   FILESM               NTEXT                 NULL,
   FILEFZ               NVARCHAR(255)         NULL,
   PARTY                NVARCHAR(255)         NULL,
   ADMINISTRATIVE       NVARCHAR(255)         NULL,
   SEND_DEPARTMENT      NVARCHAR(255)         NULL,
   SEND_DEPARTMENT2     NVARCHAR(255)         NULL,
   SEND_DEPARTMENT_ID   NVARCHAR(255)         NULL,
   SEND_DEPARTMENT_ID2  NVARCHAR(255)         NULL,
   ATTACHMENTS          NTEXT                 NULL,
   OVER_WORKTIME        BIGINT               NULL,
   RUN_WORKTIME         BIGINT               NULL,
   OVER_TIME            BIGINT               NULL,
   RUN_TIME             BIGINT               NULL,
   KEEP_PERIOD          INT                  NULL,
   IS_COVER_TIME        SMALLINT             NULL,
   RECEIPT_DATE         DATETIME             NULL,
   REGISTRATION_DATE    DATETIME             NULL,
   AUDITOR              NVARCHAR(255)         NULL,
   REVIEW               NVARCHAR(255)         NULL,
   UNDERTAKER           NVARCHAR(1024)        NULL,
   PHONE                NVARCHAR(255)         NULL,
   DEADLINE_DATETIME    DATETIME             NULL,
   IS_QUICK_SEND        SMALLINT             NULL DEFAULT 0,
   CURRENT_NODES_INFO   NTEXT                 NULL,
   UNDERTAKENOFFICE     NTEXT                 NULL,
   UNDERTAKENOFFICE_ID  NTEXT                 NULL,
   UNIT_LEVEL           NVARCHAR(255)         NULL,
   TRANSFER_STATUS      DECIMAL(3,0)         NULL,
   GOVDOC_TYPE          INT                  NULL,
   SIGN_PERSON          NVARCHAR(255)         NULL,
   SIGN_ACCOUNT_ID      NVARCHAR(255)         NULL,
   EDOC_SECRET_LEVEL    TINYINT              NULL,
   JIANBAN_TYPE         INT                  NULL,
   GOVCODE              NVARCHAR(255)         NULL,
   TO_EDOC_LIB_FLAG     TINYINT              NULL,
   TO_EDOC_LIB_TYPE     NVARCHAR(255)         NULL,
   SEND_DATE            DATETIME             NULL,
   PRINT_UNIT_ID        NVARCHAR(255)         NULL,
   RECEIVE_UNIT         NVARCHAR(255)         NULL,
   RECEIVE_UNIT_ID      NVARCHAR(255)         NULL,
   CHECK_PERSON         NVARCHAR(255)         NULL,
   PROXY_DATE           DATETIME             NULL,
   PISHI_NO             INT                  NULL,
   PISHI_NAME           NVARCHAR(255)         NULL,
   PISHI_YEAR           NVARCHAR(20)          NULL,
   PISHI_LEADER_NAME    NVARCHAR(255)         NULL,
   PUBLIC_INFO          NVARCHAR(255)         NULL,
   FORM_APP_ID          BIGINT               NULL,
   NEWFLOW_TYPE         INT                  NULL,
   ATTACHMENT_ARCHIVE_ID BIGINT               NULL,
   CAN_MODIFY           SMALLINT             NULL,
   FORM_RECORDID        BIGINT               NULL,
   IS_AUDITED           SMALLINT             NULL,
   VOUCH                SMALLINT             NULL,
   BODY_TYPE            NVARCHAR(50)         NULL,
   EXCHANGE_TYPE        TINYINT              NULL,
   CAN_ARCHIVE          SMALLINT             NULL,
   EXCHANGE_SEND_AFFAIRID BIGINT               NULL,
   CAN_EDIT_ATTACHMENT  SMALLINT             NULL,
   CAN_MERGE_DEAL       SMALLINT             NULL,
   CAN_ANY_MERGE        SMALLINT             NULL,
   CAN_EDIT             SMALLINT             NULL,
   PROCESS_TYPE         SMALLINT             NULL,
   SECRET_RELATED_LEVEL SMALLINT             NULL,
   FROM_TYPE            SMALLINT             NULL,
   PROCESS_TERM_TYPE    SMALLINT,
   REMIND_INTERVAL      BIGINT,
   DEAL_SUGGESTION		NTEXT,
   MERGE_DEAL_TYPE		NVARCHAR(255),
   AUTO_RUN SMALLINT,
   CAN_DELETE_NODE SMALLINT,
   CONSTRAINT PK_EDOC_SUMMARY PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: EDOC_SUMMARY_EXTEND                                   */
/*==============================================================*/
CREATE TABLE EDOC_SUMMARY_EXTEND (
   ID                   BIGINT               NOT NULL,
   SUMMARY_ID           BIGINT               NOT NULL,
   APP_TYPE             INT                  NULL DEFAULT 4,
   AVARCHAR1            NVARCHAR(255)         NULL,
   AVARCHAR2            NVARCHAR(255)         NULL,
   AVARCHAR3            NVARCHAR(255)         NULL,
   AVARCHAR4            NVARCHAR(255)         NULL,
   AVARCHAR5            NVARCHAR(255)         NULL,
   AVARCHAR6            NVARCHAR(255)         NULL,
   AVARCHAR7            NVARCHAR(255)         NULL,
   AVARCHAR8            NVARCHAR(255)         NULL,
   AVARCHAR9            NVARCHAR(255)         NULL,
   AVARCHAR10           NVARCHAR(255)         NULL,
   AVARCHAR11           NVARCHAR(255)         NULL,
   AVARCHAR12           NVARCHAR(255)         NULL,
   AVARCHAR13           NVARCHAR(255)         NULL,
   AVARCHAR14           NVARCHAR(255)         NULL,
   AVARCHAR15           NVARCHAR(255)         NULL,
   AVARCHAR16           NVARCHAR(255)         NULL,
   AVARCHAR17           NVARCHAR(255)         NULL,
   AVARCHAR18           NVARCHAR(255)         NULL,
   AVARCHAR19           NVARCHAR(255)         NULL,
   AVARCHAR20           NVARCHAR(255)         NULL,
   AVARCHAR21           NVARCHAR(255)         NULL,
   AVARCHAR22           NVARCHAR(255)         NULL,
   AVARCHAR23           NVARCHAR(255)         NULL,
   AVARCHAR24           NVARCHAR(255)         NULL,
   AVARCHAR25           NVARCHAR(255)         NULL,
   AVARCHAR26           NVARCHAR(255)         NULL,
   AVARCHAR27           NVARCHAR(255)         NULL,
   AVARCHAR28           NVARCHAR(255)         NULL,
   AVARCHAR29           NVARCHAR(255)         NULL,
   AVARCHAR30           NVARCHAR(255)         NULL,
   TEXT1                NTEXT                 NULL,
   TEXT2                NTEXT                 NULL,
   TEXT3                NTEXT                 NULL,
   TEXT4                NTEXT                 NULL,
   TEXT5                NTEXT                 NULL,
   TEXT6                NTEXT                 NULL,
   TEXT7                NTEXT                 NULL,
   TEXT8                NTEXT                 NULL,
   TEXT9                NTEXT                 NULL,
   TEXT10               NTEXT                 NULL,
   TEXT11               NTEXT                 NULL,
   TEXT12               NTEXT                 NULL,
   TEXT13               NTEXT                 NULL,
   TEXT14               NTEXT                 NULL,
   TEXT15               NTEXT                 NULL,
   INTEGER1             BIGINT               NULL,
   INTEGER2             BIGINT               NULL,
   INTEGER3             BIGINT               NULL,
   INTEGER4             BIGINT               NULL,
   INTEGER5             BIGINT               NULL,
   INTEGER6             BIGINT               NULL,
   INTEGER7             BIGINT               NULL,
   INTEGER8             BIGINT               NULL,
   INTEGER9             BIGINT               NULL,
   INTEGER10            BIGINT               NULL,
   INTEGER11            BIGINT               NULL,
   INTEGER12            BIGINT               NULL,
   INTEGER13            BIGINT               NULL,
   INTEGER14            BIGINT               NULL,
   INTEGER15            BIGINT               NULL,
   INTEGER16            BIGINT               NULL,
   INTEGER17            BIGINT               NULL,
   INTEGER18            BIGINT               NULL,
   INTEGER19            BIGINT               NULL,
   INTEGER20            BIGINT               NULL,
   DECIMAL1             NUMERIC(16,4)        NULL,
   DECIMAL2             NUMERIC(16,4)        NULL,
   DECIMAL3             NUMERIC(16,4)        NULL,
   DECIMAL4             NUMERIC(16,4)        NULL,
   DECIMAL5             NUMERIC(16,4)        NULL,
   DECIMAL6             NUMERIC(16,4)        NULL,
   DECIMAL7             NUMERIC(16,4)        NULL,
   DECIMAL8             NUMERIC(16,4)        NULL,
   DECIMAL9             NUMERIC(16,4)        NULL,
   DECIMAL10            NUMERIC(16,4)        NULL,
   DECIMAL11            NUMERIC(16,4)        NULL,
   DECIMAL12            NUMERIC(16,4)        NULL,
   DECIMAL13            NUMERIC(16,4)        NULL,
   DECIMAL14            NUMERIC(16,4)        NULL,
   DECIMAL15            NUMERIC(16,4)        NULL,
   DECIMAL16            NUMERIC(16,4)        NULL,
   DECIMAL17            NUMERIC(16,4)        NULL,
   DECIMAL18            NUMERIC(16,4)        NULL,
   DECIMAL19            NUMERIC(16,4)        NULL,
   DECIMAL20            NUMERIC(16,4)        NULL,
   DATE1                DATETIME             NULL,
   DATE2                DATETIME             NULL,
   DATE3                DATETIME             NULL,
   DATE4                DATETIME             NULL,
   DATE5                DATETIME             NULL,
   DATE6                DATETIME             NULL,
   DATE7                DATETIME             NULL,
   DATE8                DATETIME             NULL,
   DATE9                DATETIME             NULL,
   DATE10               DATETIME             NULL,
   DATE11               DATETIME             NULL,
   DATE12               DATETIME             NULL,
   DATE13               DATETIME             NULL,
   DATE14               DATETIME             NULL,
   DATE15               DATETIME             NULL,
   DATE16               DATETIME             NULL,
   DATE17               DATETIME             NULL,
   DATE18               DATETIME             NULL,
   DATE19               DATETIME             NULL,
   DATE20               DATETIME             NULL,
   LIST1                NVARCHAR(255)         NULL,
   LIST2                NVARCHAR(255)         NULL,
   LIST3                NVARCHAR(255)         NULL,
   LIST4                NVARCHAR(255)         NULL,
   LIST5                NVARCHAR(255)         NULL,
   LIST6                NVARCHAR(255)         NULL,
   LIST7                NVARCHAR(255)         NULL,
   LIST8                NVARCHAR(255)         NULL,
   LIST9                NVARCHAR(255)         NULL,
   LIST10               NVARCHAR(255)         NULL,
   LIST11               NVARCHAR(255)         NULL,
   LIST12               NVARCHAR(255)         NULL,
   LIST13               NVARCHAR(255)         NULL,
   LIST14               NVARCHAR(255)         NULL,
   LIST15               NVARCHAR(255)         NULL,
   LIST16               NVARCHAR(255)         NULL,
   LIST17               NVARCHAR(255)         NULL,
   LIST18               NVARCHAR(255)         NULL,
   LIST19               NVARCHAR(255)         NULL,
   LIST20               NVARCHAR(255)         NULL,
   CONSTRAINT PK_EDOC_SUMMARY_EXTEND PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: CTP_SUPERVISOR                                        */
/*==============================================================*/
CREATE TABLE CTP_SUPERVISOR (
   ID                   BIGINT               NOT NULL,
   SUPERVISE_ID         BIGINT               NULL,
   PERMISSION           SMALLINT             NULL,
   SUPERVISOR_ID        BIGINT               NULL,
   ENTITY_ID            BIGINT,
   CONSTRAINT PK_CTP_SUPERVISOR PRIMARY KEY NONCLUSTERED (ID)
);

/*==============================================================*/
/* Table: CTP_SUPERVISE_DETAIL                                  */
/*==============================================================*/
CREATE TABLE CTP_SUPERVISE_DETAIL (
   ID                   BIGINT               NOT NULL,
   TITLE                NVARCHAR(1024)        NULL,
   ENTITY_TYPE          SMALLINT             NULL,
   ENTITY_ID            BIGINT               NULL,
   SENDER_ID            BIGINT               NULL,
   STATUS               SMALLINT             NULL,
   SUPERVISORS          NVARCHAR(1024)        NULL,
   DESCRIPTION          NVARCHAR(1024)        NULL,
   COUNT                INT                  NULL,
   AWAKE_DATE           DATETIME             NULL,
   REMIND_MODE          SMALLINT             NULL,
   SCHEDULE_PROP        NVARCHAR(255)         NULL,
   CREATE_DATE          DATETIME             NULL,
   TEMPLATE_DATE_TERMINAL BIGINT               NULL,
   SUPERVISE_DATE_TYPE  NVARCHAR(255)         NULL,
   SUBJECT              NVARCHAR(1024)        NULL,
   ENTITY_CREATE_DATE   DATETIME             NULL,
   ENTITY_SENDER_ID     BIGINT               NULL,
   IMPORTANT_LEVEL      SMALLINT             NULL,
   FORWARD_MEMBER       NVARCHAR(255)         NULL,
   BODY_TYPE            NVARCHAR(255)         NULL,
   IDENTIFIER           NVARCHAR(255)         NULL,
   AFFAIR_ID            BIGINT               NULL,
   EXT_PROPS            NVARCHAR(2000)        NULL,
   IS_COVER_TIME        SMALLINT             NULL,
   TEMPLETE_ID          BIGINT               NULL,
   RESENT_TIME          SMALLINT             NULL,
   APP                  SMALLINT             NULL,
   PROCESS_DEADLINE_DATE DATETIME,
   CONSTRAINT PK_CTP_SUPERVISE_DETAIL PRIMARY KEY NONCLUSTERED (ID)
);