/*
 * Decompiled with CFR 0.152.
 */
package org.nico.ourbatis.autoconfigure;

import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.session.SqlSessionFactory;
import org.nico.noson.util.string.StringUtils;
import org.nico.ourbatis.Ourbatis;
import org.nico.ourbatis.autoconfigure.OurbatisProperties;
import org.nico.ourbatis.configure.OurbatisConfigure;
import org.nico.ourbatis.configure.OurbatisDefaultConfigue;
import org.nico.ourbatis.loader.OurbatisLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnBean(value={SqlSessionFactory.class})
@EnableConfigurationProperties(value={OurbatisProperties.class})
public class OurbatisAutoConfiguration {
    @Autowired
    private List<SqlSessionFactory> sqlSessionFactories;
    @Autowired(required=false)
    private OurbatisConfigure configure;
    @Autowired
    private OurbatisProperties properties;

    @PostConstruct
    public void ourbatisLoader() {
        if (StringUtils.isNotBlank((String)this.properties.getEnable()) && this.properties.getEnable().equalsIgnoreCase("false")) {
            return;
        }
        if (this.configure == null) {
            this.configure = new OurbatisDefaultConfigue();
        }
        if (StringUtils.isNotBlank((String)this.properties.getTemplateLocations())) {
            Ourbatis.templateLocation = this.properties.getTemplateLocations();
        }
        if (StringUtils.isNotBlank((String)this.properties.getPrefix())) {
            Ourbatis.prefix = this.properties.getPrefix();
        }
        if (StringUtils.isNotBlank((String)this.properties.getSuffix())) {
            Ourbatis.suffix = this.properties.getSuffix();
        }
        if (StringUtils.isNotBlank((String)this.properties.getPrint())) {
            Ourbatis.print = this.properties.getPrint();
        }
        this.configure.configAdapter(Ourbatis.ASSIST_ADAPTERS);
        this.configure.configWrapper(Ourbatis.JDBC_NAME_WRAPPERS, Ourbatis.TABLE_NAME_WRAPPERS, Ourbatis.MAPPER_NAME_WRAPPERS, Ourbatis.JAVA_TYPE_WRAPPERS);
        if (!CollectionUtils.isEmpty(this.sqlSessionFactories)) {
            this.sqlSessionFactories.forEach(sqlSessionFactory -> {
                MapperRegistry mapperRegistry = sqlSessionFactory.getConfiguration().getMapperRegistry();
                if (!CollectionUtils.isEmpty((Collection)mapperRegistry.getMappers())) {
                    String domainClassArrayStr;
                    String mapperLocations = ((Class)mapperRegistry.getMappers().iterator().next()).getPackage().getName();
                    OurbatisLoader loader = new OurbatisLoader(sqlSessionFactory, Ourbatis.templateLocation, mapperLocations);
                    String[] domainLocationArray = this.properties.getDomainLocations().split(";");
                    if (domainLocationArray != null) {
                        for (String domainLocation : domainLocationArray) {
                            loader.add(domainLocation);
                        }
                    }
                    if (StringUtils.isNotBlank((String)(domainClassArrayStr = this.properties.getDomainClasses()))) {
                        String[] domainClassArray;
                        for (String domainClassUri : domainClassArray = domainClassArrayStr.split(";")) {
                            try {
                                Class<?> domainClass = Class.forName(domainClassUri);
                                loader.add(domainClass);
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    loader.build();
                }
            });
        }
    }
}

