/*
 * Decompiled with CFR 0.152.
 */
package org.nico.ourbatis.el;

import java.util.List;
import org.nico.ourbatis.xml.Document;
import org.nico.ourbatis.xml.DocumentType;
import org.nico.ourbatis.xml.SimpleScanner;

public class NoelFormat {
    private String document;
    private StringBuilder builder = new StringBuilder();

    public NoelFormat(String document) {
        this.document = document;
    }

    public void append(String body) {
        this.builder.append(body);
    }

    public String result() {
        return this.builder.toString();
    }

    public NoelFormat format() {
        this.format(new SimpleScanner(this.document).scan().results(), 0);
        return this;
    }

    private NoelFormat format(List<Document> documents, int n) {
        StringBuilder tab = new StringBuilder();
        int tn = n;
        while (tn-- > 0) {
            tab.append("\t");
        }
        for (int index = 0; index < documents.size(); ++index) {
            String[] contents;
            Document document = documents.get(index);
            if (document.getBeforeContent() != null) {
                String[] contents2;
                for (String content : contents2 = document.getBeforeContent().split(System.lineSeparator())) {
                    this.builder.append((CharSequence)tab);
                    this.builder.append(content.trim());
                    this.builder.append(System.lineSeparator());
                }
            }
            String paramStr = document.getParameterString();
            if (document.getType() == DocumentType.SINGLE) {
                this.builder.append((CharSequence)tab);
                this.builder.append("<" + document.getName() + " " + paramStr + document.getTail() + ">");
                this.builder.append(System.lineSeparator());
            } else {
                this.builder.append((CharSequence)tab);
                this.builder.append("<" + document.getName() + " " + paramStr + " >");
                this.builder.append(System.lineSeparator());
                if (document.getChilds() != null && !document.getChilds().isEmpty()) {
                    this.format(document.getChilds(), n + 1);
                } else {
                    this.builder.append((CharSequence)tab);
                    this.builder.append(document.getContent());
                    this.builder.append(System.lineSeparator());
                }
                this.builder.append((CharSequence)tab);
                this.builder.append("</" + document.getName() + ">");
                this.builder.append(System.lineSeparator());
            }
            if (index != documents.size() - 1 || document.getAfterContent() == null) continue;
            for (String content : contents = document.getAfterContent().split(System.lineSeparator())) {
                this.builder.append((CharSequence)tab);
                this.builder.append(content.trim());
                this.builder.append(System.lineSeparator());
            }
        }
        return this;
    }
}

