/*
 * Decompiled with CFR 0.152.
 */
package org.nico.ourbatis.el;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nico.ourbatis.utils.ReflectUtils;

public class NoelRender {
    private String prefix;
    private String suffix;
    private String split;
    private static final String BLANK = "";

    public NoelRender(String prefix, String suffix) {
        this.suffix = suffix;
        this.prefix = prefix;
        this.split = ".";
    }

    public NoelRender(String prefix, String suffix, String split) {
        this.suffix = suffix;
        this.prefix = prefix;
        this.split = split;
    }

    public String rending(Object o, String text, String key) {
        String prefixKey = this.prefix + key;
        String assemblySplit = prefixKey + this.split;
        String assmeblySuffix = prefixKey + this.suffix;
        String[] segments = this.splitRender(text, prefixKey);
        StringBuilder result = new StringBuilder();
        Arrays.asList(segments).forEach(target -> {
            if (target.startsWith(assemblySplit) || target.startsWith(assmeblySuffix)) {
                int indexof = (target = target.substring(this.prefix.length(), target.length() - this.suffix.length())).indexOf(this.split);
                target = indexof != -1 ? this.valueWrapper(this.getChain(o, (String)target)) : this.valueWrapper(this.getValue(o, (String)target));
            }
            result.append((String)target);
        });
        return result.toString();
    }

    public String[] splitRender(String text, String elem) {
        char[] renderChars = text.toCharArray();
        StringBuilder result = new StringBuilder();
        ArrayList<String> results = new ArrayList<String>();
        int headNode = 0;
        boolean finding = false;
        for (int index = 0; index < renderChars.length; ++index) {
            char currentChar = renderChars[index];
            if (finding) {
                boolean access = true;
                for (int start = 0; start < this.suffix.length(); ++start) {
                    if (this.suffix.charAt(start) == renderChars[start + index]) continue;
                    access = false;
                    break;
                }
                if (access) {
                    results.add(result.toString() + this.suffix);
                    result.setLength(0);
                    finding = false;
                } else {
                    result.append(currentChar);
                }
            } else {
                headNode = text.indexOf(elem, index);
                if (headNode != -1) {
                    results.add(text.substring(index, headNode));
                    index = headNode + elem.length() - 1;
                    result.append(elem);
                    finding = true;
                } else {
                    results.add(text.substring(index));
                    break;
                }
            }
            if (index != renderChars.length - 1) continue;
            result.setLength(0);
        }
        return results.toArray(new String[0]);
    }

    public String valueWrapper(Object value) {
        return value == null ? BLANK : value.toString();
    }

    public Object getChain(Object obj, String fieldNames) {
        String[] fieldSegs = fieldNames.split("\\" + this.split);
        Object target = obj;
        for (int index = 0; index < fieldSegs.length; ++index) {
            String segs = fieldSegs[index];
            if (target == null) continue;
            target = this.getValue(target, segs);
        }
        return target;
    }

    public Object getValue(Object obj, String key) {
        Object target = null;
        if (obj instanceof Map) {
            target = ((Map)obj).get(key);
        } else if (obj instanceof List) {
            target = ((List)obj).get(Integer.valueOf(key));
        } else {
            return ReflectUtils.getFieldValue(key, obj);
        }
        return target;
    }
}

